/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.wizards;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.core.ui.wizards.ContainerContentProvider;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.model.AdaptableList;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class ContainerSelectionGroup
extends Composite {
    private Listener listener;
    private boolean allowNewContainerName = true;
    private boolean showClosedProjects = true;
    private IContainer selectedContainer;
    private String projectNature = "";
    private Text containerNameField;
    private TreeViewer treeViewer;
    private static final String DEFAULT_MSG_NEW_ALLOWED = IDEWorkbenchMessages.ContainerGroup_message;
    private static final String DEFAULT_MSG_SELECT_ONLY = IDEWorkbenchMessages.ContainerGroup_selectFolder;
    private static final int SIZING_SELECTION_PANE_WIDTH = 220;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;
    private int fResourceFilter = -1;
    private String[] validProjectList = null;

    public ContainerSelectionGroup(Composite composite, Listener listener, boolean bl) {
        this(composite, listener, bl, null);
    }

    public ContainerSelectionGroup(Composite composite, Listener listener, boolean bl, String string) {
        this(composite, listener, bl, string, true, "", -1);
    }

    public ContainerSelectionGroup(Composite composite, Listener listener, boolean bl, String string, boolean bl2, String string2, int n) {
        super(composite, 0);
        this.listener = listener;
        this.allowNewContainerName = bl;
        this.showClosedProjects = bl2;
        this.projectNature = string2;
        this.fResourceFilter = n;
        this.setFont(composite.getFont());
        if (n == 1) {
            string = Messages.getString((String)"com.unisys.os2200.i18nSupport.messages", (String)"ContainerGroup.selectProject");
        }
        if (string != null) {
            this.createContents(string);
        } else if (bl) {
            this.createContents(DEFAULT_MSG_NEW_ALLOWED);
        } else {
            this.createContents(DEFAULT_MSG_SELECT_ONLY);
        }
    }

    public ContainerSelectionGroup(Composite composite, Listener listener, boolean bl, String string, boolean bl2, String string2, int n, String[] stringArray) {
        super(composite, 0);
        this.listener = listener;
        this.allowNewContainerName = bl;
        this.showClosedProjects = bl2;
        this.projectNature = string2;
        this.fResourceFilter = n;
        this.setFont(composite.getFont());
        this.validProjectList = stringArray;
        if (n == 1) {
            string = Messages.getString((String)"com.unisys.os2200.i18nSupport.messages", (String)"ContainerGroup.selectProject");
        }
        if (string != null) {
            this.createContents(string);
        } else if (bl) {
            this.createContents(DEFAULT_MSG_NEW_ALLOWED);
        } else {
            this.createContents(DEFAULT_MSG_SELECT_ONLY);
        }
    }

    public void containerSelectionChanged(IContainer iContainer) {
        this.selectedContainer = iContainer;
        if (this.allowNewContainerName) {
            if (iContainer == null) {
                this.containerNameField.setText("");
            } else {
                this.containerNameField.setText(iContainer.getFullPath().makeRelative().toString());
            }
        }
        if (this.listener != null) {
            Event event = new Event();
            event.type = 13;
            event.widget = this;
            this.listener.handleEvent(event);
        }
    }

    public void createContents(String string) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 64);
        label.setText(string);
        label.setFont(this.getFont());
        if (this.allowNewContainerName) {
            GridData gridData = new GridData();
            gridData.widthHint = 470;
            this.containerNameField = new Text((Composite)this, 2052);
            this.containerNameField.setLayoutData((Object)gridData);
            this.containerNameField.addListener(24, this.listener);
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer();
    }

    protected void createTreeViewer() {
        DrillDownComposite drillDownComposite = new DrillDownComposite((Composite)this, 2048);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 220;
        gridData.heightHint = 300;
        drillDownComposite.setLayoutData((Object)gridData);
        this.treeViewer = new TreeViewer((Composite)drillDownComposite, 0);
        drillDownComposite.setChildTree(this.treeViewer);
        ContainerContentProvider containerContentProvider = new ContainerContentProvider();
        containerContentProvider.showClosedProjects(this.showClosedProjects);
        containerContentProvider.setResourceFilter(this.fResourceFilter);
        this.treeViewer.setContentProvider((IContentProvider)containerContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                ContainerSelectionGroup.this.containerSelectionChanged((IContainer)iStructuredSelection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                ISelection iSelection = doubleClickEvent.getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    if (ContainerSelectionGroup.this.treeViewer.getExpandedState(object)) {
                        ContainerSelectionGroup.this.treeViewer.collapseToLevel(object, 1);
                    } else {
                        ContainerSelectionGroup.this.treeViewer.expandToLevel(object, 1);
                    }
                }
            }
        });
        if (this.projectNature.trim().length() == 0) {
            this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
            this.treeViewer.refresh();
        } else {
            AdaptableList adaptableList = new AdaptableList();
            try {
                int n;
                IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                HashMap hashMap = null;
                if (this.validProjectList != null) {
                    hashMap = new HashMap();
                    n = 0;
                    while (n < this.validProjectList.length) {
                        hashMap.put(this.validProjectList[n], null);
                        ++n;
                    }
                }
                n = 0;
                while (n < iProjectArray.length) {
                    if (iProjectArray[n].getProject().isOpen() && iProjectArray[n].getProject().hasNature(this.projectNature)) {
                        if (hashMap != null) {
                            if (hashMap.containsKey(CommonBuildUtil.getTargetApplicationType(iProjectArray[n].getProject()))) {
                                adaptableList.add((IAdaptable)iProjectArray[n].getProject());
                            }
                        } else {
                            adaptableList.add((IAdaptable)iProjectArray[n].getProject());
                        }
                    }
                    ++n;
                }
                hashMap = null;
                this.treeViewer.setInput((Object)adaptableList);
                this.treeViewer.refresh();
            }
            catch (CoreException coreException) {
                CorePlugin.logError((Exception)((Object)coreException));
            }
        }
    }

    public IPath getContainerFullPath() {
        if (this.allowNewContainerName) {
            String string = this.containerNameField.getText();
            if (string == null || string.length() < 1) {
                return null;
            }
            return new Path(string).makeAbsolute();
        }
        if (this.selectedContainer == null) {
            return null;
        }
        return this.selectedContainer.getFullPath();
    }

    public void setInitialFocus() {
        if (this.allowNewContainerName) {
            this.containerNameField.setFocus();
        } else {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelectedContainer(IContainer iContainer) {
        this.selectedContainer = iContainer;
        ArrayList<IContainer> arrayList = new ArrayList<IContainer>();
        IContainer iContainer2 = iContainer.getParent();
        while (iContainer2 != null) {
            arrayList.add(0, iContainer2);
            iContainer2 = iContainer2.getParent();
        }
        this.treeViewer.setExpandedElements(arrayList.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)iContainer), true);
    }

    public String getFolderName() {
        return this.containerNameField.getText();
    }
}

