/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.wizards;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cobol.core.ui.util.UICommonUtility;
import org.eclipse.cobol.core.util.StatusUtil;
import org.eclipse.cobol.core.util.ValidationManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractMainWizardPage
extends WizardPage {
    private IStatus fCurrStatus;
    private boolean fPageVisible;
    private Control fFocusControl;
    private boolean isFileType = false;

    public AbstractMainWizardPage(String string, String string2, String string3) {
        super(string, string2, null);
        this.setDescription(string3);
        this.fCurrStatus = StatusUtil.createStatus(0, "");
    }

    public AbstractMainWizardPage(String string, String string2, String string3, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
        this.setDescription(string3);
        this.fCurrStatus = StatusUtil.createStatus(0, "");
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.fPageVisible = bl;
        if (bl && this.fCurrStatus.matches(4)) {
            this.updateStatus(StatusUtil.createStatus(4, ""));
        }
        if (bl && this.fFocusControl != null) {
            this.fFocusControl.setFocus();
        }
    }

    public void updateStatus(IStatus iStatus) {
        if (iStatus != null) {
            this.fCurrStatus = iStatus;
            this.setPageComplete(!iStatus.matches(4));
            if (this.fPageVisible) {
                StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
            }
        }
    }

    public void updateStatus(IStatus[] iStatusArray) {
        this.fCurrStatus = StatusUtil.getMostSevere(iStatusArray);
        this.updateStatus(this.fCurrStatus);
    }

    public void handleFieldChanged(Text text, String string) {
        int n = this.getValidationType(text);
        boolean bl = this.isTextFileType();
        if (bl) {
            IStatus[] iStatusArray = new IStatus[2];
            iStatusArray[0] = ValidationManager.validate(n, text.getText());
            iStatusArray[0] = UICommonUtility.getCustomizedStatus(iStatusArray[0], string);
            if (iStatusArray[0] != null) {
                if (iStatusArray[0].getSeverity() != 4) {
                    boolean bl2 = UICommonUtility.checkDuplicateFileName(text);
                    if (bl2) {
                        iStatusArray[0] = this.getDuplicateClassStatus(text.getText(), UICommonUtility.getTextContentType(text));
                        UICommonUtility.updatePageStatusForCurrentText(iStatusArray[0], text);
                        iStatusArray[1] = UICommonUtility.validateCurrentPage();
                        this.updateStatus(iStatusArray[1]);
                    } else {
                        UICommonUtility.updatePageStatusForCurrentText(iStatusArray[0], text);
                        iStatusArray[1] = UICommonUtility.validateCurrentPage();
                        this.updateStatus(iStatusArray[1]);
                    }
                } else {
                    UICommonUtility.updatePageStatusForCurrentText(iStatusArray[0], text);
                    iStatusArray[1] = UICommonUtility.validateCurrentPage();
                    this.updateStatus(iStatusArray[1]);
                }
            }
        } else {
            this.handleFieldChangedForNormalText(n, text, string);
        }
    }

    private void handleFieldChangedForNormalText(int n, Text text, String string) {
        IStatus[] iStatusArray = new IStatus[2];
        iStatusArray[0] = ValidationManager.validate(n, text.getText());
        iStatusArray[0] = UICommonUtility.getCustomizedStatus(iStatusArray[0], string);
        UICommonUtility.updatePageStatusForCurrentText(iStatusArray[0], text);
        iStatusArray[1] = UICommonUtility.validateCurrentPage();
        this.updateStatus(iStatusArray[1]);
    }

    protected void setFocusControl(Control control) {
        this.fFocusControl = control;
    }

    public IStatus getCurrentStatus() {
        return this.fCurrStatus;
    }

    public IStatus getDuplicateClassStatus(String string, String string2) {
        IStatus iStatus = ValidationManager.createStatusForDuplicateFileNameError(string, string2);
        return iStatus;
    }

    public abstract Text[] getAllTextControls();

    protected void updateListOfFileTypeTextControls(Vector vector) {
    }

    public boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    protected int getValidationType(Text text) {
        if (text.getData() != null) {
            String string = text.getData().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if ((string = stringTokenizer.nextToken()).equalsIgnoreCase("FILE")) {
                this.isFileType = true;
                return 0;
            }
            if (string.equalsIgnoreCase("FOLDER")) {
                this.isFileType = false;
                return 2;
            }
            if (string.equalsIgnoreCase("SPECIAL_CHARACTERS")) {
                this.isFileType = true;
                return 9;
            }
        }
        this.isFileType = false;
        return 1;
    }

    public boolean isTextFileType() {
        return this.isFileType;
    }

    protected void setFileType(boolean bl) {
        this.isFileType = bl;
    }
}

