/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.wizards;

import java.util.Vector;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public abstract class AbstractMainWizard
extends Wizard
implements INewWizard {
    protected static String DIALOG_SETTINGS_KEY = "AbstractMainWizard";
    protected IWorkbench fWorkbench;
    protected IStructuredSelection fSelection;
    private IWizardPage fLastPage;
    private Vector fileTextList;

    public AbstractMainWizard() {
        this.initializeDefaultPageImageDescriptor();
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.fWorkbench = iWorkbench;
        this.fSelection = iStructuredSelection;
    }

    protected void initializeDefaultPageImageDescriptor() {
    }

    public boolean canFinish() {
        IWizardPage iWizardPage = this.getContainer().getCurrentPage();
        return iWizardPage == this.fLastPage && iWizardPage.isPageComplete();
    }

    protected void openResource(final IResource iResource) {
        Display display;
        IWorkbenchPage iWorkbenchPage;
        if (iResource.getType() == 1 && (iWorkbenchPage = CorePlugin.getDefault().getActivePage()) != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string;
                        IEditorDescriptor iEditorDescriptor = IDE.getDefaultEditor((IFile)((IFile)iResource));
                        if (iEditorDescriptor == null) {
                            string = PlatformUI.getWorkbench().getEditorRegistry();
                            iEditorDescriptor = string.findEditor("org.eclipse.ui.systemInPlaceEditor");
                        }
                        string = "org.eclipse.ui.systemExternalEditor";
                        if (iEditorDescriptor != null) {
                            string = iEditorDescriptor.getId();
                        }
                        iWorkbenchPage.openEditor((IEditorInput)new FileEditorInput((IFile)iResource), string);
                    }
                    catch (PartInitException partInitException) {
                        CorePlugin.log(partInitException);
                    }
                }
            });
        }
    }

    protected void selectAndReveal(IResource iResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)iResource, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
    }

    protected void initDialogSettings() {
        IDialogSettings iDialogSettings = CorePlugin.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(DIALOG_SETTINGS_KEY);
        if (iDialogSettings2 == null) {
            iDialogSettings2 = new DialogSettings(DIALOG_SETTINGS_KEY);
            iDialogSettings.addSection(iDialogSettings2);
        }
        this.setDialogSettings(iDialogSettings2);
    }

    protected void setLastPage(IWizardPage iWizardPage) {
        this.fLastPage = iWizardPage;
    }

    public void setFileTypeTextControls(Text text) {
        if (this.fileTextList == null) {
            this.fileTextList = new Vector();
        }
        this.fileTextList.addElement(text);
    }

    public void setFileTypeTextControls(Text text, int n) {
        if (this.fileTextList == null) {
            this.fileTextList = new Vector();
        }
        this.fileTextList.set(n, text);
    }

    public Vector getAllFileTypeTextControls() {
        if (this.fileTextList == null) {
            this.fileTextList = new Vector();
        }
        return this.fileTextList;
    }
}

