/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.util;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.ui.wizards.AbstractMainWizardPage;
import org.eclipse.cobol.core.util.StatusUtil;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class UICommonUtility {
    private static final String EXTERNALIZE_NORMAL = "NORMAL";
    private static final String EXTERNALIZE_COLON = ":";
    public static final String NORMAL = "NORMAL";
    public static final String FILE_TYPE = "FILE";
    public static final String JAVA_PACKAGE_TYPE = "PACKAGE";
    public static final String FOLDER_TYPE = "FOLDER";
    public static final String SPECIAL_CHARACTERS = "SPECIAL_CHARACTERS";
    private static final String DEFAULT_BLANK1_TEXT_ERROR_MSG = Messages.getString((String)"This_field_cannot_be_blank_11");
    private static HashMap textsStatusHash;
    private static String[] keyList;
    private static Vector fileTypeTextsList;
    private static ArrayList disabledTextNames;
    private static int fApplicationType;
    private static boolean fGenerateExceptions;
    private static String fProjectName;

    public static boolean checkDuplicateFileName(Text text) {
        String string = UICommonUtility.getTextContentType(text);
        if (fileTypeTextsList != null) {
            int n = 0;
            while (n < fileTypeTextsList.size()) {
                String string2;
                String string3;
                Text text2 = (Text)fileTypeTextsList.elementAt(n);
                if (!text.equals(text2) && (string3 = UICommonUtility.getTextContentType(text2)) != null && !string3.equalsIgnoreCase("NORMAL") && string3.equalsIgnoreCase(string) && (string2 = text2.getText()).equalsIgnoreCase(text.getText())) {
                    return true;
                }
                ++n;
            }
            UICommonUtility.checkRestTextsForDuplicate(text);
        }
        return false;
    }

    public static String getTextContentType(Text text) {
        if (text.getData() != null) {
            String string = text.getData().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, EXTERNALIZE_COLON);
            return stringTokenizer.nextToken();
        }
        return "NORMAL";
    }

    public static String getTextName(Text text) {
        if (text.getData() != null) {
            String string = text.getData().toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, EXTERNALIZE_COLON);
            stringTokenizer.nextToken();
            return stringTokenizer.nextToken();
        }
        return null;
    }

    public static IStatus validateCurrentPage() {
        if (keyList != null) {
            IStatus[] iStatusArray = new IStatus[keyList.length];
            int n = 0;
            while (n < keyList.length) {
                if (disabledTextNames != null) {
                    if (!disabledTextNames.contains(keyList[n]) && textsStatusHash != null && textsStatusHash.containsKey(keyList[n])) {
                        iStatusArray[n] = (IStatus)textsStatusHash.get(keyList[n]);
                    }
                } else if (textsStatusHash != null && textsStatusHash.containsKey(keyList[n])) {
                    iStatusArray[n] = (IStatus)textsStatusHash.get(keyList[n]);
                }
                if (iStatusArray[n] != null && iStatusArray[n].matches(4)) {
                    return iStatusArray[n];
                }
                ++n;
            }
            return StatusUtil.getMostSevere(iStatusArray);
        }
        return null;
    }

    public static void updatePageStatusForCurrentText(IStatus iStatus, Text text) {
        if (textsStatusHash == null) {
            textsStatusHash = new HashMap();
        }
        String string = UICommonUtility.getTextName(text);
        textsStatusHash.put(string, iStatus);
    }

    public static void resetPageStatus(Text[] textArray) {
        keyList = new String[textArray.length];
        int n = 0;
        while (n < textArray.length) {
            Text text = textArray[n];
            if (UICommonUtility.getTextName(text) != null) {
                UICommonUtility.keyList[n] = UICommonUtility.getTextName(text).trim();
            }
            ++n;
        }
    }

    public static void updateFileTypeList(Vector vector) {
        fileTypeTextsList = vector;
    }

    public static Vector getAllFileTypeTextsList() {
        return fileTypeTextsList;
    }

    public static void updateDisabledTextList(String string, boolean bl) {
        if (disabledTextNames == null) {
            disabledTextNames = new ArrayList();
        }
        if (bl) {
            disabledTextNames.add(string);
        } else {
            disabledTextNames.remove(string);
        }
    }

    private static void checkRestTextsForDuplicate(Text text) {
        String string = text.getText().substring(0, text.getText().length() - 1);
        if (string != null && !string.equals("")) {
            UICommonUtility.updateTheDuplicateStatusToOkForTheOnlyMatchingText(text, string);
        }
    }

    private static void updateTheDuplicateStatusToOkForTheOnlyMatchingText(Text text, String string) {
        int n = 0;
        Object object = null;
        String string2 = UICommonUtility.getTextContentType(text);
        String string3 = null;
        if (fileTypeTextsList != null) {
            Object object2;
            int n2 = 0;
            while (n2 < fileTypeTextsList.size()) {
                object2 = (Text)fileTypeTextsList.elementAt(n2);
                if (object2 != text && (string3 = UICommonUtility.getTextContentType(object2)) != null && string3.equalsIgnoreCase(string2) && string.equalsIgnoreCase(object2.getText()) && ++n == 1) {
                    object = object2;
                }
                ++n2;
            }
            if (n == 1) {
                Status status = new Status(0, CorePlugin.getPluginId(), -1, Messages.getString((String)"_3"), null);
                object2 = UICommonUtility.getTextName(object);
                textsStatusHash.put(object2, status);
            }
        }
    }

    public static void dispose() {
        if (textsStatusHash != null) {
            textsStatusHash.clear();
            textsStatusHash = null;
        }
        keyList = null;
        if (fileTypeTextsList != null) {
            fileTypeTextsList.clear();
            fileTypeTextsList = null;
        }
        if (disabledTextNames != null) {
            disabledTextNames = null;
        }
    }

    public static void selectGroupMode(boolean bl, Composite composite, boolean bl2) {
        Control[] controlArray = composite.getChildren();
        String string = null;
        int n = 0;
        while (n < controlArray.length) {
            if (bl2 || !(controlArray[n] instanceof Button) || n != 0) {
                if (controlArray[n] instanceof Composite) {
                    UICommonUtility.selectGroupMode(bl, (Composite)controlArray[n], true);
                }
                if (controlArray[n] instanceof Text) {
                    string = UICommonUtility.getTextName((Text)controlArray[n]);
                    if (!bl) {
                        UICommonUtility.updateDisabledTextList(string, true);
                    } else {
                        UICommonUtility.updateDisabledTextList(string, false);
                    }
                }
                controlArray[n].setEnabled(bl);
            }
            ++n;
        }
    }

    public static void selectGroupMode(boolean bl, Composite composite, boolean bl2, AbstractMainWizardPage abstractMainWizardPage) {
        Control[] controlArray = composite.getChildren();
        String string = null;
        int n = 0;
        while (n < controlArray.length) {
            if (bl2 || !(controlArray[n] instanceof Button) || n != 0) {
                if (controlArray[n] instanceof Composite) {
                    UICommonUtility.selectGroupMode(bl, (Composite)controlArray[n], true);
                }
                if (controlArray[n] instanceof Text) {
                    string = UICommonUtility.getTextName((Text)controlArray[n]);
                    if (!bl) {
                        UICommonUtility.updateDisabledTextList(string, true);
                    } else {
                        UICommonUtility.updateDisabledTextList(string, false);
                    }
                }
                controlArray[n].setEnabled(bl);
                IStatus iStatus = UICommonUtility.validateCurrentPage();
                abstractMainWizardPage.updateStatus(iStatus);
            }
            ++n;
        }
    }

    public static int getApplicationType() {
        return fApplicationType;
    }

    public static void setApplicationType(int n) {
        fApplicationType = n;
    }

    public static boolean isGenerateExceptions() {
        return fGenerateExceptions;
    }

    public static void setGenerateExceptions(boolean bl) {
        fGenerateExceptions = bl;
    }

    public static String getProjectName() {
        return fProjectName;
    }

    public static void setProjectName(String string) {
        fProjectName = string;
    }

    public static void registerControlForDefaultBlank(Text text, AbstractMainWizardPage abstractMainWizardPage, String string) {
        IStatus iStatus = UICommonUtility.getStatusForBlankInput(string);
        UICommonUtility.updatePageStatusForCurrentText(iStatus, text);
        abstractMainWizardPage.setPageComplete(false);
    }

    public static void resetDefaultStatusForGroupTextsToOK(Composite composite, AbstractMainWizardPage abstractMainWizardPage) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Text && ((Text)controlArray[n]).getText().equals("")) {
                UICommonUtility.resetControlStatusToOK((Text)controlArray[n], abstractMainWizardPage);
            }
            ++n;
        }
    }

    public static void resetDefaultStatusForGroupTexts(Control[] controlArray, AbstractMainWizardPage abstractMainWizardPage, String[] stringArray) {
        int n = 0;
        while (n < controlArray.length) {
            if (controlArray[n] instanceof Text && ((Text)controlArray[n]).getText().equals("")) {
                UICommonUtility.registerControlForDefaultBlank((Text)controlArray[n], abstractMainWizardPage, stringArray[n]);
            }
            ++n;
        }
    }

    private static void resetControlStatusToOK(Text text, AbstractMainWizardPage abstractMainWizardPage) {
        Status status = new Status(0, CorePlugin.getPluginId(), -1, Messages.getString((String)"_3"), null);
        UICommonUtility.updatePageStatusForCurrentText((IStatus)status, text);
        IStatus iStatus = UICommonUtility.validateCurrentPage();
        abstractMainWizardPage.updateStatus(iStatus);
    }

    public static int getTextControlsCountInGroup(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = 0;
        int n2 = 0;
        while (n2 < controlArray.length) {
            if (controlArray[n2] instanceof Text) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public static Control[] getAllTextChildren(Composite composite) {
        Control[] controlArray = composite.getChildren();
        Control[] controlArray2 = new Control[UICommonUtility.getTextControlsCountInGroup(composite)];
        int n = -1;
        int n2 = 0;
        while (n2 < controlArray.length) {
            if (controlArray[n2] instanceof Text) {
                controlArray2[++n] = (Text)controlArray[n2];
            }
            ++n2;
        }
        return controlArray2;
    }

    public static String[] getContentTypes() {
        String string = Messages.getString((String)"com.unisys.os2200.i18nSupport.messages", (String)"UICommonUtility.ContentTypes");
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, EXTERNALIZE_COLON);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n] = stringTokenizer.nextToken();
            ++n;
        }
        return stringArray;
    }

    public static final IStatus getCustomizedStatus(IStatus iStatus, String string) {
        if (!iStatus.isOK()) {
            String string2 = iStatus.getMessage();
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            String string3 = string2.concat(EXTERNALIZE_COLON).concat(string);
            iStatus = iStatus.getSeverity() == 4 ? new Status(4, CorePlugin.getPluginId(), -1, string3, null) : new Status(2, CorePlugin.getPluginId(), -1, string3, null);
        }
        return iStatus;
    }

    public static IStatus getStatusForBlankInput(String string) {
        Status status = new Status(4, CorePlugin.getPluginId(), -1, DEFAULT_BLANK1_TEXT_ERROR_MSG, null);
        return UICommonUtility.getCustomizedStatus((IStatus)status, string);
    }
}

