/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.projectmanagement;

import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.ProjectBuildToolsInteraction;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;

public class ProjectNature {
    private static String COBOL_BUILDER_ID = "org.eclipse.cobol.core.COBOLBuilder";
    private IProject fProject;

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject iProject) {
        this.fProject = iProject;
    }

    public void removeFromBuildSpec() throws CoreException {
        try {
            if (COBOL_BUILDER_ID != null) {
                IProjectDescription iProjectDescription = this.getProject().getDescription();
                ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
                int n = 0;
                while (n < iCommandArray.length) {
                    if (iCommandArray[n].getBuilderName().equals(COBOL_BUILDER_ID)) {
                        ICommand[] iCommandArray2 = new ICommand[iCommandArray.length - 1];
                        System.arraycopy(iCommandArray, 0, iCommandArray2, 0, n);
                        System.arraycopy(iCommandArray, n + 1, iCommandArray2, n, iCommandArray.length - n - 1);
                        iProjectDescription.setBuildSpec(iCommandArray2);
                        this.getProject().setDescription(iProjectDescription, null);
                        return;
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            CorePlugin.logError("ERROR removeFromBuildSpec of ProjectNature", (Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CorePlugin.logError("ERROR removeFromBuildSpec of ProjectNature", exception);
        }
    }

    public void addToBuildSpec(String string) throws CoreException {
        try {
            if (string != null) {
                ICommand iCommand = null;
                IProjectDescription iProjectDescription = this.fProject.getDescription();
                iCommand = ProjectBuildToolsInteraction.getBuildCommand(string);
                ICommand[] iCommandArray = new ICommand[]{iCommand};
                iProjectDescription.setBuildSpec(iCommandArray);
                this.fProject.setDescription(iProjectDescription, null);
            }
        }
        catch (CoreException coreException) {
            CorePlugin.logError("ERROR addToBuildSpec of ProjectNature", (Exception)((Object)coreException));
        }
        catch (Exception exception) {
            CorePlugin.logError("ERROR addToBuildSpec of ProjectNature", exception);
        }
    }
}

