/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.preferences;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class DefaultColorEditor {
    private Point fExtent;
    private Image fImage;
    private RGB fColorValue;
    private Color fColor;
    private Button fButton;

    public DefaultColorEditor(Composite composite) {
        this.fButton = new Button(composite, 8);
        this.fButton.setFont(composite.getFont());
        this.fExtent = this.computeImageSize((Control)composite);
        this.fImage = new Image((Device)composite.getDisplay(), this.fExtent.x, this.fExtent.y);
        GC gC = new GC((Drawable)this.fImage);
        gC.setBackground(this.fButton.getBackground());
        gC.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
        gC.dispose();
        this.fButton.setImage(this.fImage);
        this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ColorDialog colorDialog = new ColorDialog(DefaultColorEditor.this.fButton.getShell());
                colorDialog.setRGB(DefaultColorEditor.this.fColorValue);
                RGB rGB = colorDialog.open();
                if (rGB != null) {
                    DefaultColorEditor.this.fColorValue = rGB;
                    DefaultColorEditor.this.updateColorImage();
                }
            }
        });
        this.fButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                if (DefaultColorEditor.this.fImage != null) {
                    DefaultColorEditor.this.fImage.dispose();
                    DefaultColorEditor.this.fImage = null;
                }
                if (DefaultColorEditor.this.fColor != null) {
                    DefaultColorEditor.this.fColor.dispose();
                    DefaultColorEditor.this.fColor = null;
                }
            }
        });
    }

    public RGB getColorValue() {
        return this.fColorValue;
    }

    public void setColorValue(RGB rGB) {
        this.fColorValue = rGB;
        this.updateColorImage();
    }

    public Button getButton() {
        return this.fButton;
    }

    protected void updateColorImage() {
        Display display = this.fButton.getDisplay();
        GC gC = new GC((Drawable)this.fImage);
        gC.setForeground(display.getSystemColor(2));
        gC.drawRectangle(0, 2, this.fExtent.x - 1, this.fExtent.y - 4);
        if (this.fColor != null) {
            this.fColor.dispose();
        }
        this.fColor = new Color((Device)display, this.fColorValue);
        gC.setBackground(this.fColor);
        gC.fillRectangle(1, 3, this.fExtent.x - 2, this.fExtent.y - 5);
        gC.dispose();
        this.fButton.setImage(this.fImage);
    }

    protected Point computeImageSize(Control control) {
        GC gC = new GC((Drawable)control);
        Font font = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gC.setFont(font);
        int n = gC.getFontMetrics().getHeight();
        gC.dispose();
        Point point = new Point(n * 3 - 6, n);
        return point;
    }
}

