/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.guiutility;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class GUIComponentCreationUtility {
    protected static String ERROR_MESSAGE_COMPOSITE = "GUIComponentCreationUtility::Composite passed is null";
    private static String TEXT = ".text";
    private static String TOOLTIP = ".tooltip";
    private static String CLASS_IDENTIFIER = "GUIComponentCreationUtility";
    private static String COLON = "::";
    private static String ERROR_MESSAGE_KEY = String.valueOf(CLASS_IDENTIFIER) + COLON + "Key passed is null";
    private static String ERROR_MESSAGE_BUNDLE = String.valueOf(CLASS_IDENTIFIER) + COLON + "GUIComponentCreationUtility::Bundle passed is null";
    private static String ERROR_MESSAGE_CONTROL = String.valueOf(CLASS_IDENTIFIER) + COLON + "GUIComponentCreationUtility::Control passed is null";
    private static String ERROR_MESSAGE_LAYOUTDATA = String.valueOf(CLASS_IDENTIFIER) + COLON + "The layoutdata specified for the component is not compatible with its parent's layout. The component has not been created. ";
    private static int COLUMN_WEIGHT_DATA = 50;

    protected static void _assert(Composite composite) {
        Assert.isNotNull((Object)composite, (String)ERROR_MESSAGE_COMPOSITE);
    }

    private static void _assert(Control control, String string, ResourceBundle resourceBundle) {
        Assert.isNotNull((Object)control, (String)ERROR_MESSAGE_CONTROL);
        Assert.isNotNull((Object)string, (String)ERROR_MESSAGE_KEY);
        Assert.isNotNull((Object)resourceBundle, (String)ERROR_MESSAGE_BUNDLE);
    }

    public static GridLayout createGridLayout(Composite composite, int n) {
        GUIComponentCreationUtility._assert(composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        if (n > 0) {
            gridLayout.numColumns = n;
        }
        composite.setLayout((Layout)gridLayout);
        return gridLayout;
    }

    public static GridLayout createBlankGridLayout(Composite composite, int n, boolean bl) {
        GUIComponentCreationUtility._assert(composite);
        GridLayout gridLayout = new GridLayout();
        if (!bl) {
            gridLayout.marginWidth = 0;
        }
        gridLayout.marginHeight = 0;
        if (n > 0) {
            gridLayout.numColumns = n;
        }
        composite.setLayout((Layout)gridLayout);
        return gridLayout;
    }

    public static FormLayout createFormLayout(Composite composite) {
        GUIComponentCreationUtility._assert(composite);
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 10;
        formLayout.marginWidth = 10;
        composite.setLayout((Layout)formLayout);
        return formLayout;
    }

    public static RowLayout createRowLayout(Composite composite, int n) {
        GUIComponentCreationUtility._assert(composite);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = n;
        rowLayout.marginLeft = 10;
        rowLayout.marginRight = 10;
        rowLayout.marginTop = 10;
        rowLayout.marginBottom = 10;
        composite.setLayout((Layout)rowLayout);
        return rowLayout;
    }

    public static FillLayout createFillLayout(Composite composite, int n) {
        GUIComponentCreationUtility._assert(composite);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = n;
        composite.setLayout((Layout)fillLayout);
        return fillLayout;
    }

    protected static Group createGroup(Composite composite, int n, String string) {
        GUIComponentCreationUtility._assert(composite);
        Group group = new Group(composite, n);
        group.setFont(composite.getFont());
        if (string != null) {
            group.setText(string);
        }
        return group;
    }

    public static Group createGroup(Composite composite, int n, Object object, String string, ResourceBundle resourceBundle) {
        if (!GUIComponentCreationUtility.isArgumentsValid(composite, object, string, resourceBundle)) {
            return null;
        }
        String string2 = "";
        try {
            string2 = resourceBundle.getString(string.concat(TEXT));
        }
        catch (MissingResourceException missingResourceException) {
            string2 = String.valueOf('!') + string + '!';
        }
        Group group = GUIComponentCreationUtility.createGroup(composite, n, string2);
        group.setFont(composite.getFont());
        group.setLayoutData(object);
        return group;
    }

    protected static Button createButton(Composite composite, int n, String string) {
        GUIComponentCreationUtility._assert(composite);
        Button button = new Button(composite, n);
        button.setFont(composite.getFont());
        if (string != null) {
            button.setText(string);
        }
        return button;
    }

    public static Button createButton(Composite composite, int n, Object object, String string, ResourceBundle resourceBundle) {
        if (!GUIComponentCreationUtility.isArgumentsValid(composite, object, string, resourceBundle)) {
            return null;
        }
        String string2 = "";
        try {
            string2 = resourceBundle.getString(string.concat(TEXT));
        }
        catch (MissingResourceException missingResourceException) {
            string2 = String.valueOf('!') + string + '!';
        }
        Button button = GUIComponentCreationUtility.createButton(composite, n, string2);
        button.setLayoutData(object);
        return button;
    }

    protected static Label createLabel(Composite composite, int n, String string) {
        GUIComponentCreationUtility._assert(composite);
        Label label = new Label(composite, n);
        label.setFont(composite.getFont());
        label.setText(string);
        return label;
    }

    public static Label createLabel(Composite composite, int n, Object object, String string, ResourceBundle resourceBundle) {
        if (!GUIComponentCreationUtility.isArgumentsValid(composite, object, string, resourceBundle)) {
            return null;
        }
        String string2 = "";
        try {
            string2 = resourceBundle.getString(string.concat(TEXT));
        }
        catch (MissingResourceException missingResourceException) {
            string2 = String.valueOf('!') + string + '!';
        }
        Label label = GUIComponentCreationUtility.createLabel(composite, n, string2);
        label.setLayoutData(object);
        return label;
    }

    protected static Text createText(Composite composite, int n, String string) {
        GUIComponentCreationUtility._assert(composite);
        Text text = new Text(composite, n);
        text.setFont(composite.getFont());
        if (string != null && string.length() > 0) {
            text.setText(string);
        }
        return text;
    }

    public static Text createText(Composite composite, int n, Object object, String string, ResourceBundle resourceBundle) {
        if (!GUIComponentCreationUtility.isArgumentsValid(composite, object, string, resourceBundle)) {
            return null;
        }
        Text text = null;
        String string2 = "";
        if (string.length() > 0) {
            try {
                string2 = resourceBundle.getString(string.concat(TEXT));
            }
            catch (MissingResourceException missingResourceException) {
                string2 = String.valueOf('!') + string + '!';
            }
        }
        text = GUIComponentCreationUtility.createText(composite, n, string2);
        text.setLayoutData(object);
        return text;
    }

    public static Text createText(Composite composite, int n, Object object, String string) {
        Text text = null;
        text = GUIComponentCreationUtility.createText(composite, n, string);
        text.setLayoutData(object);
        return text;
    }

    protected static Combo createCombo(Composite composite, int n, String[] stringArray, int n2) {
        GUIComponentCreationUtility._assert(composite);
        Combo combo = new Combo(composite, n);
        combo.setFont(composite.getFont());
        if (stringArray != null) {
            combo.setItems(stringArray);
            if (n2 >= 0) {
                combo.select(n2);
            }
        }
        return combo;
    }

    protected static List createList(Composite composite, int n, String[] stringArray) {
        GUIComponentCreationUtility._assert(composite);
        List list = new List(composite, n);
        list.setFont(composite.getFont());
        if (stringArray != null) {
            list.setItems(stringArray);
        }
        return list;
    }

    public static List createList(Composite composite, int n, GridData gridData) {
        GUIComponentCreationUtility._assert(composite);
        List list = new List(composite, n);
        list.setFont(composite.getFont());
        if (gridData != null) {
            list.setLayoutData((Object)gridData);
        }
        return list;
    }

    public static Composite createComposite(Composite composite, int n, Object object) {
        GUIComponentCreationUtility._assert(composite);
        if (!GUIComponentCreationUtility.isLayoutDataValid(composite, object)) {
            return null;
        }
        Composite composite2 = new Composite(composite, n);
        composite2.setFont(composite.getFont());
        composite2.setLayoutData(object);
        return composite2;
    }

    public static Combo createCombo(Composite composite, int n, String[] stringArray, int n2, Object object) {
        GUIComponentCreationUtility._assert(composite);
        if (!GUIComponentCreationUtility.isLayoutDataValid(composite, object)) {
            return null;
        }
        Combo combo = GUIComponentCreationUtility.createCombo(composite, n, stringArray, n2);
        combo.setFont(composite.getFont());
        combo.setLayoutData(object);
        return combo;
    }

    public static List createList(Composite composite, int n, String[] stringArray, Object object) {
        GUIComponentCreationUtility._assert(composite);
        if (!GUIComponentCreationUtility.isLayoutDataValid(composite, object)) {
            return null;
        }
        List list = GUIComponentCreationUtility.createList(composite, n, stringArray);
        list.setFont(composite.getFont());
        list.setLayoutData(object);
        return list;
    }

    public static Table createTable(Composite composite, int n, Object object) {
        GUIComponentCreationUtility._assert(composite);
        if (!GUIComponentCreationUtility.isLayoutDataValid(composite, object)) {
            return null;
        }
        Table table = new Table(composite, n);
        table.setFont(composite.getFont());
        table.setLayoutData(object);
        return table;
    }

    public static Tree createTree(Composite composite, int n, Object object) {
        GUIComponentCreationUtility._assert(composite);
        if (!GUIComponentCreationUtility.isLayoutDataValid(composite, object)) {
            return null;
        }
        Tree tree = new Tree(composite, n);
        tree.setFont(composite.getFont());
        tree.setLayoutData(object);
        return tree;
    }

    public static void setToolTipText(Control control, String string, ResourceBundle resourceBundle) {
        GUIComponentCreationUtility._assert(control, string, resourceBundle);
        String string2 = "";
        try {
            string2 = resourceBundle.getString(string.concat(TOOLTIP));
        }
        catch (MissingResourceException missingResourceException) {
            string2 = String.valueOf('!') + string + '!';
        }
        control.setToolTipText(string2);
    }

    private static boolean isArgumentsValid(Composite composite, Object object, String string, ResourceBundle resourceBundle) {
        GUIComponentCreationUtility._assert((Control)composite, string, resourceBundle);
        return GUIComponentCreationUtility.isLayoutDataValid(composite, object);
    }

    private static boolean isLayoutDataValid(Composite composite, Object object) {
        Layout layout = composite.getLayout();
        if (object == null) {
            return true;
        }
        if (layout instanceof RowLayout && object instanceof RowData) {
            return true;
        }
        if (layout instanceof GridLayout && object instanceof GridData) {
            return true;
        }
        if (layout instanceof FormLayout && object instanceof FormData) {
            return true;
        }
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)CLASS_IDENTIFIER, (String)ERROR_MESSAGE_LAYOUTDATA);
        return false;
    }

    public static Table createTable(Composite composite, String[] stringArray) {
        try {
            Table table = new Table(composite, 2048);
            table.setFont(composite.getFont());
            GridData gridData = new GridData(1808);
            table.setLayoutData((Object)gridData);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            table = GUIComponentCreationUtility.addColumns(table, stringArray, tableLayout);
            return table;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Table createTable(Composite composite, int n, String[] stringArray) {
        try {
            Table table = new Table(composite, n);
            table.setFont(composite.getFont());
            GridData gridData = new GridData(1808);
            table.setLayoutData((Object)gridData);
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            TableLayout tableLayout = new TableLayout();
            table.setLayout((Layout)tableLayout);
            table = GUIComponentCreationUtility.addColumns(table, stringArray, tableLayout);
            return table;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Table addColumns(Table table, String[] stringArray, TableLayout tableLayout) {
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setText(stringArray[n2]);
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(COLUMN_WEIGHT_DATA));
            ++n2;
        }
        return table;
    }

    public static String getText(ResourceBundle resourceBundle, String string) {
        return resourceBundle.getString(string.concat(TEXT));
    }

    public static String getToolTip(ResourceBundle resourceBundle, String string) {
        return resourceBundle.getString(string.concat(TOOLTIP));
    }
}

