/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.editor;

import com.unisys.os2200.i18nSupport.Messages;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class Editor
extends AbstractTextEditor {
    LineNumberRulerColumn fLineNumberRulerColumn;
    String RESOURCE_NAME = "org.eclipse.cobol.core.ui.org.eclipse.cobol.core.ui.editor.EditorMessages";

    public void doSaveAs() {
        this.performSaveAs((IProgressMonitor)new NullProgressMonitor());
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void performSaveAs(IProgressMonitor iProgressMonitor) {
        try {
            boolean bl;
            block26: {
                Object object;
                IDocumentProvider iDocumentProvider;
                IFile iFile;
                Shell shell = this.getSite().getShell();
                SaveAsDialog saveAsDialog = new SaveAsDialog(shell);
                saveAsDialog.create();
                IEditorInput iEditorInput = this.getEditorInput();
                IFile iFile2 = iFile = iEditorInput instanceof IFileEditorInput ? ((IFileEditorInput)iEditorInput).getFile() : null;
                if (iFile != null) {
                    saveAsDialog.setOriginalFile(iFile);
                }
                if ((iDocumentProvider = this.getDocumentProvider()).isDeleted((Object)iEditorInput) && iFile != null) {
                    object = MessageFormat.format(Messages.getString((String)this.RESOURCE_NAME, (String)"Editor.warning.save.delete"), iFile.getName());
                    saveAsDialog.setMessage((String)object, 2);
                }
                if (saveAsDialog.open() == 1) {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.setCanceled(true);
                    }
                    return;
                }
                object = saveAsDialog.getResult();
                if (object == null) {
                    if (iProgressMonitor != null) {
                        iProgressMonitor.setCanceled(true);
                    }
                    return;
                }
                IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
                IFile iFile3 = iWorkspace.getRoot().getFile(object);
                FileEditorInput fileEditorInput = new FileEditorInput(iFile3);
                WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation((IEditorInput)fileEditorInput){
                    private final /* synthetic */ IEditorInput val$newInput;
                    {
                        this.val$newInput = iEditorInput;
                    }

                    public void execute(IProgressMonitor iProgressMonitor) throws CoreException {
                        Editor.this.getDocumentProvider().saveDocument(iProgressMonitor, (Object)this.val$newInput, Editor.this.getDocumentProvider().getDocument((Object)Editor.this.getEditorInput()), true);
                    }
                };
                bl = false;
                try {
                    this.getDocumentProvider().aboutToChange((Object)fileEditorInput);
                    new ProgressMonitorDialog(shell).run(false, true, (IRunnableWithProgress)workspaceModifyOperation);
                    bl = true;
                }
                catch (InterruptedException interruptedException) {
                    this.getDocumentProvider().changed((Object)fileEditorInput);
                    if (bl) {
                        this.setInput((IEditorInput)fileEditorInput);
                    }
                    break block26;
                }
                catch (InvocationTargetException invocationTargetException) {
                    try {
                        Throwable throwable = invocationTargetException.getTargetException();
                        String string = Messages.getString((String)this.RESOURCE_NAME, (String)"Editor.error.save.title");
                        String string2 = MessageFormat.format(Messages.getString((String)this.RESOURCE_NAME, (String)"Editor.error.save.message"), throwable.getMessage());
                        if (throwable instanceof CoreException) {
                            CoreException coreException = (CoreException)throwable;
                            IStatus iStatus = coreException.getStatus();
                            if (iStatus != null) {
                                switch (iStatus.getSeverity()) {
                                    case 1: {
                                        MessageDialog.openInformation((Shell)shell, (String)string, (String)string2);
                                        break;
                                    }
                                    case 2: {
                                        MessageDialog.openWarning((Shell)shell, (String)string, (String)string2);
                                        break;
                                    }
                                    default: {
                                        MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                                        break;
                                    }
                                }
                            } else {
                                MessageDialog.openError((Shell)shell, (String)string, (String)string2);
                            }
                        }
                        break block26;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.getDocumentProvider().changed((Object)fileEditorInput);
                        if (bl) {
                            this.setInput((IEditorInput)fileEditorInput);
                        }
                    }
                }
                this.getDocumentProvider().changed((Object)fileEditorInput);
                if (bl) {
                    this.setInput((IEditorInput)fileEditorInput);
                }
            }
            if (iProgressMonitor != null) {
                iProgressMonitor.setCanceled(!bl);
            }
            this.updateStatusField("InputPosition");
        }
        catch (Exception exception) {
            CorePlugin.logError(exception);
        }
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler compositeRuler = new CompositeRuler();
        compositeRuler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12));
        if (this.isLineNumberRulerVisible()) {
            compositeRuler.addDecorator(1, this.createLineNumberRulerColumn());
        }
        return compositeRuler;
    }

    protected boolean isLineNumberRulerVisible() {
        return true;
    }

    protected IVerticalRulerColumn createLineNumberRulerColumn() {
        this.fLineNumberRulerColumn = new LineNumberRulerColumn();
        this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        return this.fLineNumberRulerColumn;
    }

    protected void initializeLineNumberRulerColumn(LineNumberRulerColumn lineNumberRulerColumn) {
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getProperty();
        if ("lineNumberRuler".equals(string)) {
            if (this.isLineNumberRulerVisible()) {
                this.showLineNumberRuler();
            } else {
                this.hideLineNumberRuler();
            }
            return;
        }
        if (this.fLineNumberRulerColumn != null && ("lineNumberColor".equals(string) || "AbstractTextEditor.Color.Background.SystemDefault".equals(string) || "AbstractTextEditor.Color.Background".equals(string))) {
            this.initializeLineNumberRulerColumn(this.fLineNumberRulerColumn);
        }
        super.handlePreferenceStoreChanged(propertyChangeEvent);
    }

    private void showLineNumberRuler() {
        IVerticalRuler iVerticalRuler = this.getVerticalRuler();
        if (iVerticalRuler instanceof CompositeRuler) {
            CompositeRuler compositeRuler = (CompositeRuler)iVerticalRuler;
            compositeRuler.addDecorator(1, this.createLineNumberRulerColumn());
        }
    }

    private void hideLineNumberRuler() {
        IVerticalRuler iVerticalRuler = this.getVerticalRuler();
        if (iVerticalRuler instanceof CompositeRuler) {
            CompositeRuler compositeRuler = (CompositeRuler)iVerticalRuler;
            compositeRuler.removeDecorator(1);
        }
    }
}

