/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.common.text;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class DefaultWordRule
extends WordRule {
    protected IWordDetector fDetector;
    private StringBuffer fBuffer = new StringBuffer();

    public DefaultWordRule(IWordDetector iWordDetector) {
        super(iWordDetector);
        this.fDetector = iWordDetector;
    }

    public DefaultWordRule(IWordDetector iWordDetector, IToken iToken) {
        super(iWordDetector, iToken);
        this.fDetector = iWordDetector;
    }

    public void addWord(String string, IToken iToken) {
        super.addWord(string, iToken);
    }

    public IToken evaluate(ICharacterScanner iCharacterScanner) {
        char c = (char)iCharacterScanner.read();
        if (this.fDetector.isWordStart(c)) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append(c);
            } while ((c = (char)iCharacterScanner.read()) != '\uffffffff' && this.fDetector.isWordPart(c));
            iCharacterScanner.unread();
            IToken iToken = (IToken)this.fWords.get(this.fBuffer.toString());
            if (iToken != null) {
                return iToken;
            }
            if (this.fDefaultToken.isUndefined()) {
                this.unreadBuffer(iCharacterScanner);
            }
            return this.fDefaultToken;
        }
        iCharacterScanner.unread();
        return Token.UNDEFINED;
    }
}

