/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.common.text;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.ui.common.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractCodeScanner
extends BufferedRuleBasedScanner {
    private IColorManager fColorManager;
    private IPreferenceStore fPreferenceStore;
    private Map fTokenMap = new HashMap();
    private String[] fPropertyNamesColor;
    private String[] fPropertyNamesStyle;
    private static final String STYLE = "_bold";

    protected abstract String[] getTokenProperties();

    protected abstract List createRules();

    public AbstractCodeScanner(IColorManager iColorManager, IPreferenceStore iPreferenceStore) {
        this.fColorManager = iColorManager;
        this.fPreferenceStore = iPreferenceStore;
    }

    public final void initialize() {
        try {
            this.fPropertyNamesColor = this.getTokenProperties();
            int n = this.fPropertyNamesColor.length;
            this.fPropertyNamesStyle = new String[n];
            int n2 = 0;
            while (n2 < n) {
                this.fPropertyNamesStyle[n2] = String.valueOf(this.fPropertyNamesColor[n2]) + STYLE;
                this.addToken(this.fPropertyNamesColor[n2], this.fPropertyNamesStyle[n2]);
                ++n2;
            }
            this.initializeRules();
        }
        catch (NoSuchElementException noSuchElementException) {
            CorePlugin.logError(noSuchElementException);
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
    }

    private void addToken(String string, String string2) {
        try {
            boolean bl = false;
            RGB rGB = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)string);
            this.fColorManager.bindColor(string, rGB);
            bl = this.fPreferenceStore.getBoolean(string2);
            this.fTokenMap.put(string, new Token((Object)new TextAttribute(this.fColorManager.getColor(string), null, bl ? 1 : 0)));
        }
        catch (NoSuchElementException noSuchElementException) {}
    }

    protected Token getToken(String string) {
        return (Token)this.fTokenMap.get(string);
    }

    private void initializeRules() {
        List list = this.createRules();
        if (list != null) {
            IRule[] iRuleArray = new IRule[list.size()];
            list.toArray(iRuleArray);
            this.setRules(iRuleArray);
        }
    }

    private int indexOf(String string) {
        try {
            if (string != null) {
                int n = this.fPropertyNamesColor.length;
                int n2 = 0;
                while (n2 < n) {
                    if (string.equals(this.fPropertyNamesColor[n2]) || string.equals(this.fPropertyNamesStyle[n2])) {
                        return n2;
                    }
                    ++n2;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        return -1;
    }

    public boolean affectsBehavior(PropertyChangeEvent propertyChangeEvent) {
        return this.indexOf(propertyChangeEvent.getProperty()) >= 0;
    }

    public void adaptToPreferenceChange(PropertyChangeEvent propertyChangeEvent) {
        String string = "";
        int n = 0;
        try {
            string = propertyChangeEvent.getProperty();
            n = this.indexOf(string);
            Token token = this.getToken(this.fPropertyNamesColor[n]);
            if (this.fPropertyNamesColor[n].equals(string)) {
                this.adaptToColorChange(token, propertyChangeEvent);
            } else {
                this.adaptToStyleChange(token, propertyChangeEvent);
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        catch (NoSuchElementException noSuchElementException) {
            CorePlugin.logError(noSuchElementException);
        }
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent propertyChangeEvent) {
        RGB rGB = null;
        Object object = propertyChangeEvent.getNewValue();
        if (object instanceof RGB) {
            rGB = (RGB)object;
        } else if (object instanceof String) {
            rGB = StringConverter.asRGB((String)((String)object));
        }
        if (rGB != null) {
            String string = propertyChangeEvent.getProperty();
            this.fColorManager.bindColor(string, rGB);
            Object object2 = token.getData();
            if (object2 instanceof TextAttribute) {
                TextAttribute textAttribute = (TextAttribute)object2;
                token.setData((Object)new TextAttribute(this.fColorManager.getColor(string), textAttribute.getBackground(), textAttribute.getStyle()));
            }
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent propertyChangeEvent) {
        Object object;
        boolean bl = false;
        Object object2 = propertyChangeEvent.getNewValue();
        if (object2 instanceof Boolean) {
            bl = (Boolean)object2;
        } else if (object2 instanceof String) {
            object = (String)object2;
            if ("true".equals(object)) {
                bl = true;
            } else if ("false".equals(object)) {
                bl = false;
            }
        }
        object = token.getData();
        if (object instanceof TextAttribute) {
            boolean bl2;
            TextAttribute textAttribute = (TextAttribute)object;
            boolean bl3 = bl2 = textAttribute.getStyle() == 1;
            if (bl2 != bl) {
                token.setData((Object)new TextAttribute(textAttribute.getForeground(), textAttribute.getBackground(), bl ? 1 : 0));
            }
        }
    }
}

