/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.common;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class TableUtil {
    private Table fTable;
    private int[] fControlTypes;
    private ControlEditor fEditor;
    private TableCursor fCursor;
    private KeyListener fKeyListener;
    private TraverseListener fTraverseListener;
    private FocusListener fFocusListener;
    private SelectionListener fCursorSelectionListener;
    private MouseListener fCursorMouseListener;
    private IControlActivationNotifier fControlActivationNotifier;
    private HashMap fDefaultComboValues;
    private HashMap fComboEditableStates;
    private TableItem fCurrentItem = null;
    private int fCurrentCol = -1;
    private Image[] fImages;

    public TableUtil(Table table, int[] nArray, IControlActivationNotifier iControlActivationNotifier) {
        this.fTable = table;
        this.fControlActivationNotifier = iControlActivationNotifier;
        Assert.isTrue((nArray.length == this.fTable.getColumnCount() ? 1 : 0) != 0);
        this.fControlTypes = nArray;
        this.initializeListeners();
        this.configureTable();
        this.fDefaultComboValues = new HashMap(5);
        this.fComboEditableStates = new HashMap(5);
    }

    public void setImages(Image[] imageArray) {
        this.fImages = imageArray;
    }

    public String[][] readTableData() {
        String[][] stringArray = null;
        TableItem[] tableItemArray = this.fTable.getItems();
        int n = tableItemArray.length;
        if (n < 1) {
            return stringArray;
        }
        int n2 = this.fTable.getColumnCount();
        stringArray = new String[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                stringArray[n3][n4] = tableItemArray[n3].getText(n4);
                ++n4;
            }
            ++n3;
        }
        return stringArray;
    }

    public boolean writeTableData(String[][] stringArray) {
        Assert.isNotNull((Object)stringArray);
        int n = stringArray.length;
        int n2 = stringArray[0].length;
        int n3 = 0;
        while (n3 < n) {
            String[] stringArray2 = new String[n2];
            int n4 = 0;
            while (n4 < n2) {
                stringArray2[n4] = stringArray[n3][n4];
                ++n4;
            }
            TableItem tableItem = new TableItem(this.fTable, 16384);
            tableItem.setText(stringArray2);
            ++n3;
        }
        if (!this.isTableConfigured()) {
            this.configureTable();
        }
        return true;
    }

    public boolean addRow(String[] stringArray) {
        Assert.isNotNull((Object)stringArray);
        Assert.isTrue((stringArray.length == this.fTable.getColumnCount() ? 1 : 0) != 0);
        TableItem tableItem = new TableItem(this.fTable, 16384);
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                if (3 == this.fControlTypes[n]) {
                    tableItem.setImage(n, this.fImages[0]);
                } else {
                    tableItem.setText(n, string);
                }
                ++n;
            }
        }
        this.fTable.setSelection(this.fTable.getItemCount() - 1);
        if (!this.isTableConfigured()) {
            this.configureTable();
        }
        return true;
    }

    public boolean deleteRow() {
        int n;
        TableItem[] tableItemArray = this.fTable.getSelection();
        TableItem tableItem = tableItemArray.length > 0 ? tableItemArray[0] : null;
        int n2 = this.fTable.getSelectionIndex();
        int n3 = n = n2 == this.fTable.getItemCount() - 1 ? n2 - 1 : n2;
        if (tableItem != null) {
            tableItem.dispose();
            if (this.fTable.getItemCount() == 0) {
                this.deConfigureTable();
            } else {
                this.fTable.setSelection(n);
                if (this.fCursor != null) {
                    this.fCursor.setSelection(this.fTable.getItem(n), this.fCursor.getColumn());
                    this.fCursor.setFocus();
                }
            }
        }
        return true;
    }

    public void setDefaultComboValues(String[] stringArray, int n, boolean bl) {
        Assert.isTrue((n >= 0 && n < this.fControlTypes.length ? 1 : 0) != 0);
        Integer n2 = new Integer(n);
        this.fDefaultComboValues.put(n2, stringArray);
        this.fComboEditableStates.put(n2, new Boolean(bl));
    }

    public void dispose() {
        this.deConfigureTable();
        this.fControlActivationNotifier = null;
        this.fKeyListener = null;
        this.fTraverseListener = null;
        this.fFocusListener = null;
        this.fCursorMouseListener = null;
        this.fCursorSelectionListener = null;
        if (this.fDefaultComboValues != null) {
            this.fDefaultComboValues.clear();
            this.fDefaultComboValues = null;
        }
        this.fImages = null;
        this.fTable = null;
    }

    private void initializeListeners() {
        this.initializeKeyListener();
        this.initializeTraverseListener();
        this.initializeFocusListener();
        this.initializeCursorSelectionListener();
        this.initializeCursorMouseListener();
    }

    private void configureTable() {
        if (this.fTable.getItemCount() >= 1 && this.fCursor == null) {
            this.fCursor = new TableCursor(this.fTable, 0);
            this.fEditor = new ControlEditor((Composite)this.fCursor);
            this.fEditor.grabHorizontal = true;
            this.fEditor.grabVertical = true;
            this.fCursor.addSelectionListener(this.fCursorSelectionListener);
            this.fCursor.addMouseListener(this.fCursorMouseListener);
        }
    }

    private void deConfigureTable() {
        if (this.fTable != null) {
            if (this.fEditor != null) {
                this.disposeEditorControl(this.fEditor.getEditor());
                this.fEditor.setEditor(null);
                this.fEditor.dispose();
                this.fEditor = null;
            }
            if (this.fCursor != null && !this.fCursor.isDisposed()) {
                this.fCursor.removeMouseListener(this.fCursorMouseListener);
                this.fCursor.dispose();
                this.fCursor = null;
            }
        }
        this.fImages = null;
    }

    private boolean isTableConfigured() {
        return this.fCursor != null;
    }

    private KeyListener initializeKeyListener() {
        if (this.fKeyListener == null) {
            this.fKeyListener = new KeyAdapter(){

                public void keyPressed(KeyEvent keyEvent) {
                    Control control = (Control)keyEvent.getSource();
                    boolean bl = true;
                    if (TableUtil.this.fControlActivationNotifier != null) {
                        bl = TableUtil.this.fControlActivationNotifier.statusValidated(control);
                    }
                    if (bl) {
                        if (keyEvent.character == '\r') {
                            TableUtil.this.captureEditedValues(control);
                            TableUtil.this.disposeEditorControl(control);
                        } else if (keyEvent.character == '\u001b') {
                            TableUtil.this.disposeEditorControl(control);
                        }
                    } else {
                        control.setFocus();
                    }
                }
            };
        }
        return this.fKeyListener;
    }

    private TraverseListener initializeTraverseListener() {
        if (this.fTraverseListener == null) {
            this.fTraverseListener = new TraverseListener(){

                public void keyTraversed(TraverseEvent traverseEvent) {
                    Control control = (Control)traverseEvent.getSource();
                    if (traverseEvent.detail == 2) {
                        TableUtil.this.disposeEditorControl(control);
                    } else if (traverseEvent.detail == 4) {
                        boolean bl = true;
                        if (TableUtil.this.fControlActivationNotifier != null) {
                            bl = TableUtil.this.fControlActivationNotifier.statusValidated(control);
                        }
                        if (bl) {
                            TableUtil.this.captureEditedValues(control);
                            TableUtil.this.disposeEditorControl(control);
                            TableUtil.this.fCursor.setFocus();
                        } else {
                            control.setFocus();
                        }
                    }
                    traverseEvent.doit = false;
                }
            };
        }
        return this.fTraverseListener;
    }

    private FocusListener initializeFocusListener() {
        if (this.fFocusListener == null) {
            this.fFocusListener = new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    Control control = (Control)focusEvent.getSource();
                    boolean bl = true;
                    if (TableUtil.this.fControlActivationNotifier != null) {
                        bl = TableUtil.this.fControlActivationNotifier.statusValidated(control);
                    }
                    if (bl) {
                        TableUtil.this.captureEditedValues(control);
                        TableUtil.this.disposeEditorControl(control);
                        TableUtil.this.fCursor.setFocus();
                    } else {
                        TableUtil.this.fCurrentCol = TableUtil.this.fCursor.getColumn();
                        TableUtil.this.fCurrentItem = TableUtil.this.fCursor.getRow();
                        control.setFocus();
                    }
                }
            };
        }
        return this.fFocusListener;
    }

    private SelectionListener initializeCursorSelectionListener() {
        if (this.fCursorSelectionListener == null) {
            this.fCursorSelectionListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    TableUtil.this.handleWidgetSelection();
                }

                public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                    TableUtil.this.handleWidgetDefaultSelection();
                }
            };
        }
        return this.fCursorSelectionListener;
    }

    private MouseListener initializeCursorMouseListener() {
        if (this.fCursorMouseListener == null) {
            this.fCursorMouseListener = new MouseAdapter(){

                public void mouseDown(MouseEvent mouseEvent) {
                    super.mouseDown(mouseEvent);
                    TableUtil.this.handleWidgetDefaultSelection();
                }
            };
        }
        return this.fCursorMouseListener;
    }

    private void handleWidgetSelection() {
        boolean bl = this.disposeEditorControl(this.fEditor.getEditor());
        if (bl) {
            this.fTable.setSelection(new TableItem[]{this.fCursor.getRow()});
        } else {
            this.fTable.setSelection(new TableItem[]{this.fCurrentItem});
            this.fCursor.setSelection(this.fCurrentItem, this.fCurrentCol);
            this.fCursor.setFocus();
        }
    }

    private void handleWidgetDefaultSelection() {
        boolean bl = this.disposeEditorControl(this.fEditor.getEditor());
        if (bl) {
            this.createNewControls();
        } else {
            this.fTable.setSelection(new TableItem[]{this.fCurrentItem});
            this.fCursor.setSelection(this.fCurrentItem, this.fCurrentCol);
            this.fCursor.setFocus();
        }
    }

    private void createNewControls() {
        if (this.fControlActivationNotifier != null) {
            this.fControlActivationNotifier.controlActivated();
        }
        TableItem tableItem = this.fCursor.getRow();
        int n = this.fCursor.getColumn();
        Text text = null;
        switch (this.fControlTypes[n]) {
            case 0: {
                break;
            }
            case 2: {
                Text text2 = new Text((Composite)this.fCursor, 0);
                text2.setText(tableItem.getText(n));
                text = text2;
                this.fEditor.horizontalAlignment = 16384;
                this.fEditor.verticalAlignment = 128;
                text2.addKeyListener(this.fKeyListener);
                break;
            }
            case 1: {
                Combo combo = null;
                boolean bl = (Boolean)this.fComboEditableStates.get(new Integer(n));
                combo = bl ? new Combo((Composite)this.fCursor, 2048) : new Combo((Composite)this.fCursor, 2056);
                combo.setItems(this.retrieveDefaultComboValues(n));
                combo.setText(tableItem.getText(n));
                text = combo;
                combo.addTraverseListener(this.fTraverseListener);
                combo.addKeyListener(this.fKeyListener);
                this.fEditor.horizontalAlignment = 16384;
                this.fEditor.verticalAlignment = 0x1000000;
                break;
            }
            case 3: {
                Button button = new Button((Composite)this.fCursor, 32);
                if (tableItem.getImage(n) == this.fImages[0]) {
                    button.setSelection(true);
                } else {
                    button.setSelection(false);
                    tableItem.setImage(n, this.fImages[1]);
                }
                text = button;
                this.fEditor.horizontalAlignment = 0x1000000;
                this.fEditor.verticalAlignment = 128;
            }
        }
        if (text != null) {
            this.fEditor.grabHorizontal = true;
            this.fEditor.grabVertical = true;
            this.fEditor.setEditor((Control)text);
            text.setFocus();
            text.addFocusListener(this.fFocusListener);
        }
    }

    private void captureEditedValues(Control control) {
        TableItem tableItem = this.fCursor.getRow();
        int n = this.fCursor.getColumn();
        String string = null;
        if (control instanceof Text) {
            string = ((Text)control).getText();
        } else if (control instanceof Combo) {
            string = ((Combo)control).getText();
        } else if (control instanceof Button) {
            boolean bl = ((Button)control).getSelection();
            string = "";
            if (bl) {
                tableItem.setImage(n, this.fImages[0]);
            } else {
                tableItem.setImage(n, this.fImages[1]);
            }
        }
        tableItem.setText(n, string);
    }

    private boolean disposeEditorControl(Control control) {
        if (control != null && !control.isDisposed()) {
            boolean bl;
            if (this.fControlActivationNotifier != null && !(bl = this.fControlActivationNotifier.statusValidated(control))) {
                control.setFocus();
                return false;
            }
            if (this.fControlActivationNotifier != null) {
                this.fControlActivationNotifier.controlDeactivated();
            }
            control.removeKeyListener(this.fKeyListener);
            control.removeTraverseListener(this.fTraverseListener);
            control.removeFocusListener(this.fFocusListener);
            control.dispose();
        }
        return true;
    }

    private String[] retrieveDefaultComboValues(int n) {
        Iterator iterator = this.fDefaultComboValues.keySet().iterator();
        String[] stringArray = null;
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            if (n2 != n) continue;
            stringArray = (String[])this.fDefaultComboValues.get(n2);
        }
        Assert.isNotNull(stringArray);
        return stringArray;
    }

    public static interface IControlActivationNotifier {
        public void controlActivated();

        public void controlDeactivated();

        public boolean statusValidated(Control var1);
    }
}

