/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.common;

import org.eclipse.cobol.core.ui.IUIPluginImages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;

public class StatusLine
extends CLabel {
    private static final RGB ERROR_BACKGROUND_RGB = new RGB(230, 226, 221);
    private Color fNormalMsgAreaBackground = this.getBackground();
    private Color fErrorMsgAreaBackground = null;

    public StatusLine(Composite composite) {
        this(composite, 16512);
    }

    public StatusLine(Composite composite, int n) {
        super(composite, n);
    }

    private static Image findImage(IStatus iStatus) {
        if (iStatus.isOK()) {
            return null;
        }
        if (iStatus.matches(4)) {
            return IUIPluginImages.get("org.eclipse.cobol.core.ui.error_obj.gif");
        }
        if (iStatus.matches(2)) {
            return IUIPluginImages.get("org.eclipse.cobol.core.ui.warning_obj.gif");
        }
        if (iStatus.matches(1)) {
            return IUIPluginImages.get("org.eclipse.cobol.core.ui.info_obj.gif");
        }
        return null;
    }

    public void setErrorStatus(IStatus iStatus) {
        String string;
        if (iStatus != null && (string = iStatus.getMessage()) != null && string.length() > 0) {
            this.setText(string);
            this.setImage(StatusLine.findImage(iStatus));
            if (this.fErrorMsgAreaBackground == null) {
                this.fErrorMsgAreaBackground = new Color((Device)this.getDisplay(), ERROR_BACKGROUND_RGB);
            }
            this.setBackground(this.fErrorMsgAreaBackground);
            return;
        }
        this.setText("");
        this.setImage(null);
        this.setBackground(this.fNormalMsgAreaBackground);
    }

    public void dispose() {
        if (this.fErrorMsgAreaBackground != null) {
            this.fErrorMsgAreaBackground.dispose();
            this.fErrorMsgAreaBackground = null;
        }
        super.dispose();
    }
}

