/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.common;

import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.core.runtime.IStatus;

public class StatusInfo
implements IStatus {
    private String fStatusMessage;
    private int fSeverity;

    public StatusInfo() {
        this(0, null);
    }

    public StatusInfo(int n, String string) {
        this.fStatusMessage = string;
        this.fSeverity = n;
    }

    public boolean isOK() {
        return this.fSeverity == 0;
    }

    public boolean isError() {
        return this.fSeverity == 4;
    }

    public String getMessage() {
        return this.fStatusMessage;
    }

    public void setError(String string) {
        if (string != null) {
            this.fStatusMessage = string;
            this.fSeverity = 4;
        }
    }

    public void setOK() {
        this.fStatusMessage = null;
        this.fSeverity = 0;
    }

    public boolean matches(int n) {
        return (this.fSeverity & n) != 0;
    }

    public boolean isMultiStatus() {
        return false;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getPlugin() {
        try {
            return CorePlugin.getPluginId();
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
            return "";
        }
    }

    public Throwable getException() {
        return null;
    }

    public int getCode() {
        return this.fSeverity;
    }

    public IStatus[] getChildren() {
        return new IStatus[0];
    }
}

