/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.common;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private static ExceptionHandler fgInstance = new ExceptionHandler();

    public static void handle(CoreException coreException, Shell shell, String string, String string2) {
        fgInstance.perform(coreException, shell, string, string2);
    }

    public static void handle(InvocationTargetException invocationTargetException, Shell shell, String string, String string2) {
        fgInstance.perform(invocationTargetException, shell, string, string2);
    }

    public static void handle(InterruptedException interruptedException, Shell shell, String string, String string2) {
        fgInstance.perform(interruptedException, shell, string, string2);
    }

    protected void perform(CoreException coreException, Shell shell, String string, String string2) {
        CorePlugin.log(coreException);
        IStatus iStatus = coreException.getStatus();
        if (iStatus != null) {
            ErrorDialog.openError((Shell)shell, (String)string, (String)string2, (IStatus)iStatus);
        } else {
            this.displayMessageDialog(coreException, coreException.getMessage(), shell, string, string2);
        }
    }

    protected void perform(InvocationTargetException invocationTargetException, Shell shell, String string, String string2) {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof CoreException) {
            this.perform((CoreException)throwable, shell, string, string2);
        } else {
            CorePlugin.log(invocationTargetException);
            if (invocationTargetException.getMessage() != null && invocationTargetException.getMessage().length() > 0) {
                this.displayMessageDialog(invocationTargetException, invocationTargetException.getMessage(), shell, string, string2);
            } else {
                this.displayMessageDialog(invocationTargetException, throwable.getMessage(), shell, string, string2);
            }
        }
    }

    protected void perform(InterruptedException interruptedException, Shell shell, String string, String string2) {
        CorePlugin.log(interruptedException);
        if (interruptedException.getMessage() != null && interruptedException.getMessage().length() > 0) {
            this.displayMessageDialog(interruptedException, interruptedException.getMessage(), shell, string, string2);
        }
    }

    private void displayMessageDialog(Throwable throwable, String string, Shell shell, String string2, String string3) {
        StringWriter stringWriter = new StringWriter();
        if (string3 != null) {
            stringWriter.write(string3);
            stringWriter.write("\n\n");
        }
        if (string == null || string.length() == 0) {
            stringWriter.write(Messages.getString((String)"ExceptionDialog.seeErrorLogMessage"));
        } else {
            stringWriter.write(string);
        }
        MessageDialog.openError((Shell)shell, (String)string2, (String)stringWriter.toString());
    }
}

