/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.build.properties;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.ProjectBuildToolsInteraction;
import org.eclipse.cobol.core.build.ant.AntScriptGenerator;
import org.eclipse.cobol.core.build.util.TaskViewhelper;
import org.eclipse.cobol.core.registry.internal.IBuildToolDescriptor;
import org.eclipse.cobol.core.registry.internal.IBuildToolRegistry;
import org.eclipse.cobol.core.registry.internal.ITargetApplicationTypeDescriptor;
import org.eclipse.cobol.core.registry.internal.ITargetApplicationTypeRegistry;
import org.eclipse.cobol.core.registry.internal.core.BuildToolDescriptor;
import org.eclipse.cobol.core.registry.internal.core.TargetApplicationTypeDescriptor;
import org.eclipse.cobol.core.ui.IUIHelpContextIds;
import org.eclipse.cobol.core.ui.build.BuildUiUtil;
import org.eclipse.cobol.core.ui.build.dialogs.AddBuildToolsDialog;
import org.eclipse.cobol.core.ui.build.dialogs.AddBuildToolsFromApplicationDialog;
import org.eclipse.cobol.core.ui.build.properties.BuildToolData;
import org.eclipse.cobol.core.ui.guiutility.GUIComponentCreationUtility;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class BuildToolsSettingPropertyPage
extends PropertyPage {
    private Table fBuildToolsTable = null;
    private Button fAddFromAppButton = null;
    private Button fAddButton = null;
    private Button fRemoveButton = null;
    private Button fUpButton = null;
    private Button fDownButton = null;
    private Label fErrorLabel = null;
    private ICommand fBuilderCommand = null;
    private ArrayList imagesToDispose = new ArrayList();
    private String fsOriginalTargetApplicationType = null;
    private static final int BUTTON_WIDTH = 125;

    private void addBuildToolsToTable(ICommand iCommand) {
        if (iCommand == null) {
            return;
        }
        Map map = iCommand.getArguments();
        if (map != null) {
            this.fsOriginalTargetApplicationType = (String)map.get("originaltargetapplicationtype");
            map.remove("originaltargetapplicationtype");
            int n = map.size();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                IBuildToolDescriptor iBuildToolDescriptor;
                String string = (String)map.get(String.valueOf(n3 + 1));
                if (string != null && CorePlugin.getDefault() != null && (iBuildToolDescriptor = CorePlugin.getDefault().getBuildToolsRegistry().find(string)) != null) {
                    n2 = this.addBuildTool(iBuildToolDescriptor, n2);
                }
                ++n3;
            }
        }
    }

    private Button createButton(Composite composite, String string, ResourceBundle resourceBundle) {
        GridData gridData = new GridData();
        gridData.widthHint = this.convertHorizontalDLUsToPixels(125);
        gridData.heightHint = this.convertVerticalDLUsToPixels(14);
        Button button = GUIComponentCreationUtility.createButton(composite, 8, gridData, string, resourceBundle);
        final Composite composite2 = composite;
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildToolsSettingPropertyPage.this.handleButtonPressed((Button)selectionEvent.widget, composite2);
            }
        });
        return button;
    }

    protected Control createContents(Composite composite) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData gridData = new GridData();
        Composite composite2 = GUIComponentCreationUtility.createComposite(composite, 0, gridData);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(1808));
        gridData = new GridData();
        Composite composite3 = new Composite(composite2, 0);
        composite3.setFont(composite2.getFont());
        composite3.setLayoutData((Object)new GridData(1808));
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        composite3.setLayout((Layout)gridLayout);
        this.fBuildToolsTable = new Table(composite3, 68356);
        this.fBuildToolsTable.setFont(composite3.getFont());
        gridData = new GridData(1808);
        gridData.heightHint = 150;
        gridData.widthHint = 200;
        this.fBuildToolsTable.setLayoutData((Object)gridData);
        this.fBuildToolsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                BuildToolsSettingPropertyPage.this.handleTableSelectionChanged();
            }
        });
        gridData = new GridData(2);
        Composite composite4 = GUIComponentCreationUtility.createComposite(composite3, 0, gridData);
        gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite4.setLayout((Layout)gridLayout);
        this.fAddFromAppButton = this.createButton(composite4, "BuildToolsSettingPropertyPage.AddFromApplication", Messages.getResourceBundle());
        this.fAddButton = this.createButton(composite4, "BuildToolsSettingPropertyPage.AddBuildTool", Messages.getResourceBundle());
        this.fAddButton = this.createButton(composite4, "BuildToolsSettingPropertyPage.AddBuildTool", Messages.getResourceBundle());
        this.fRemoveButton.setEnabled(false);
        this.fUpButton = this.createButton(composite4, "BuildToolsSettingPropertyPage.Up", Messages.getResourceBundle());
        this.fUpButton.setEnabled(false);
        this.fDownButton = this.createButton(composite4, "BuildToolsSettingPropertyPage.Down", Messages.getResourceBundle());
        this.fDownButton.setEnabled(false);
        this.fErrorLabel = new Label(composite2, 64);
        this.fErrorLabel.setFont(composite2.getFont());
        this.fErrorLabel.setText("");
        GC gC = new GC((Drawable)this.fErrorLabel);
        FontMetrics fontMetrics = gC.getFontMetrics();
        int n = fontMetrics.getHeight();
        gC.dispose();
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = n * 5;
        this.fErrorLabel.setLayoutData((Object)gridData);
        this.fErrorLabel.setForeground(new Color((Device)this.fErrorLabel.getDisplay(), 255, 0, 0));
        try {
            this.fBuilderCommand = ProjectBuildToolsInteraction.provideBuilderCommand(this.getInputProject());
        }
        catch (CoreException coreException) {}
        this.addBuildToolsToTable(this.fBuilderCommand);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, IUIHelpContextIds.BUILD_PROPERTY_PAGE);
        return composite2;
    }

    public void dispose() {
        super.dispose();
        for (Image image : this.imagesToDispose) {
            if (image == null) continue;
            image.dispose();
        }
        this.imagesToDispose.clear();
    }

    private IProject getInputProject() {
        Object object;
        IAdaptable iAdaptable = this.getElement();
        if (iAdaptable instanceof IProject) {
            return (IProject)iAdaptable;
        }
        if (iAdaptable != null && (object = iAdaptable.getAdapter(IResource.class)) != null && object instanceof IProject) {
            return (IProject)object;
        }
        return null;
    }

    private void handleButtonPressed(Button button, Composite composite) {
        if (button == this.fAddFromAppButton) {
            this.addBuildToolFromTAT(composite);
        } else if (button == this.fAddButton) {
            this.addBuildTool(composite);
        } else if (button == this.fRemoveButton) {
            this.removeBuildTool(composite);
        } else if (button == this.fUpButton) {
            this.moveSelectionUp();
        } else if (button == this.fDownButton) {
            this.moveSelectionDown();
        }
        this.handleTableSelectionChanged();
        this.fBuildToolsTable.setFocus();
        this.validateDependencyRule();
    }

    private void addBuildTool(Composite composite) {
        AddBuildToolsDialog addBuildToolsDialog = new AddBuildToolsDialog(composite.getShell(), Messages.getString((String)"BuildToolsSettingPropertyPage.AddBuildToolDialogTitle"), Messages.getString((String)"BuildToolsSettingPropertyPage.AddBuildToolDialogMessage"), this.getInputProject());
        addBuildToolsDialog.setElementsToFilter(this.getCurrentBuildDescriptors());
        if (addBuildToolsDialog.open() == 0) {
            BuildToolDescriptor buildToolDescriptor = (BuildToolDescriptor)addBuildToolsDialog.getSelectedElement();
            this.addEnabledBuildTool(composite, buildToolDescriptor);
        }
    }

    private void addEnabledBuildTool(Composite composite, BuildToolDescriptor buildToolDescriptor) {
        if (buildToolDescriptor != null) {
            if (buildToolDescriptor.isBuildToolEnabled()) {
                this.addBuildTool(buildToolDescriptor, -1);
            } else {
                this.showMessage(composite, Messages.getString((String)"BuildToolsSettingPropertyPage.BuildToolNotSupported.title"), Messages.getFormattedString((String)"BuildToolsSettingPropertyPage.BuildToolNotSupported.message", (Object)buildToolDescriptor.getLabel()));
            }
        }
    }

    private void addBuildToolFromTAT(Composite composite) {
        AddBuildToolsFromApplicationDialog addBuildToolsFromApplicationDialog = new AddBuildToolsFromApplicationDialog(composite.getShell(), Messages.getString((String)"BuildToolsSettingPropertyPage.AddBuildToolFromAppDialogTitle"), Messages.getString((String)"BuildToolsSettingPropertyPage.AddBuildToolFromAppDialogMessage"), this.getInputProject());
        addBuildToolsFromApplicationDialog.setElementsToFilter(this.getCurrentBuildDescriptors());
        if (addBuildToolsFromApplicationDialog.open() == 0) {
            TargetApplicationTypeDescriptor targetApplicationTypeDescriptor = (TargetApplicationTypeDescriptor)addBuildToolsFromApplicationDialog.getSelectedElement();
            this.addBuildToolsFromTargetApplicationType(composite, targetApplicationTypeDescriptor);
        }
    }

    private ArrayList getCurrentBuildDescriptors() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.fBuildToolsTable.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            BuildToolData buildToolData = (BuildToolData)this.fBuildToolsTable.getItem(n2).getData();
            arrayList.add(buildToolData.getBuildToolId());
            ++n2;
        }
        return arrayList;
    }

    private void addBuildToolsFromTargetApplicationType(Composite composite, TargetApplicationTypeDescriptor targetApplicationTypeDescriptor) {
        if (targetApplicationTypeDescriptor != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(targetApplicationTypeDescriptor.getPreCompilerTools());
            arrayList.add(targetApplicationTypeDescriptor.getCompilerTool());
            arrayList.addAll(targetApplicationTypeDescriptor.getPostCompilerTools());
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)arrayList.get(n2);
                IBuildToolRegistry iBuildToolRegistry = CorePlugin.getDefault().getBuildToolsRegistry();
                if (iBuildToolRegistry != null) {
                    BuildToolDescriptor buildToolDescriptor = (BuildToolDescriptor)iBuildToolRegistry.find(string);
                    this.addEnabledBuildTool(composite, buildToolDescriptor);
                }
                ++n2;
            }
        }
    }

    private int addBuildTool(IBuildToolDescriptor iBuildToolDescriptor, int n) {
        boolean bl;
        int n2 = n;
        if (iBuildToolDescriptor != null && (bl = iBuildToolDescriptor.isBuildToolEnabled())) {
            TableItem tableItem;
            String string = iBuildToolDescriptor.getId();
            int n3 = this.fBuildToolsTable.getItemCount();
            int n4 = 0;
            while (n4 < n3) {
                String string2;
                BuildToolData buildToolData;
                tableItem = this.fBuildToolsTable.getItem(n4);
                if (tableItem != null && (buildToolData = (BuildToolData)tableItem.getData()) != null && (string2 = buildToolData.getBuildToolId()) != null && string2.equals(string)) {
                    return n2;
                }
                ++n4;
            }
            if (n2 == -1) {
                n2 = this.getPositionToAdd(string);
            }
            BuildToolData buildToolData = new BuildToolData();
            buildToolData.setBuildToolId(iBuildToolDescriptor.getId());
            buildToolData.setSequenceNo(n2 + 1);
            tableItem = new TableItem(this.fBuildToolsTable, 0, n2);
            tableItem.setData((Object)buildToolData);
            tableItem.setText(iBuildToolDescriptor.getLabel());
            tableItem.setImage(iBuildToolDescriptor.getImageDescriptor().createImage());
            int n5 = this.fBuildToolsTable.getItemCount();
            int n6 = 0;
            while (n6 < n5) {
                TableItem tableItem2 = this.fBuildToolsTable.getItem(n6);
                BuildToolData buildToolData2 = (BuildToolData)tableItem2.getData();
                buildToolData2.setSequenceNo(n6 + 1);
                tableItem2.setData((Object)buildToolData2);
                ++n6;
            }
            if (n == -1) {
                this.fBuildToolsTable.setSelection(n2);
            }
            this.fBuildToolsTable.setFocus();
            return n2 + 1;
        }
        return n2;
    }

    private void removeBuildTool(Composite composite) {
        int n = this.fBuildToolsTable.getSelectionIndex();
        String string = this.getBuildToolIdToBeDeleted(n);
        if (string != null && this.isBuildToolNecessaryForApplicationType(string)) {
            this.showMessage(composite, Messages.getString((String)"BuildToolsSettingPropertyPage.Cannot_Delete_2"), Messages.getFormattedString((String)"BuildToolsSettingPropertyPage.{0}_is_necessary_for_this_project._It_cannot_be_deleted_3", (Object)TargetApplicationTypeDescriptor.getBuildToolName(string)));
        } else {
            TableItem[] tableItemArray = this.fBuildToolsTable.getSelection();
            if (tableItemArray != null && this.fBuildToolsTable.getSelectionCount() == 1) {
                tableItemArray[0].dispose();
            }
            int n2 = this.fBuildToolsTable.getItemCount();
            int n3 = n;
            while (n3 < n2) {
                TableItem tableItem = this.fBuildToolsTable.getItem(n3);
                BuildToolData buildToolData = (BuildToolData)tableItem.getData();
                int n4 = buildToolData.getSequenceNo();
                buildToolData.setSequenceNo(n4 - 1);
                tableItem.setData((Object)buildToolData);
                ++n3;
            }
            if (n == this.fBuildToolsTable.getItemCount()) {
                this.fBuildToolsTable.setSelection(this.fBuildToolsTable.getItemCount() - 1);
            } else {
                this.fBuildToolsTable.setSelection(n);
            }
        }
    }

    private void showMessage(Composite composite, String string, String string2) {
        String string3 = string;
        String string4 = string2;
        MessageDialog.openInformation((Shell)composite.getShell(), (String)string3, (String)string4);
    }

    private String getBuildToolIdToBeDeleted(int n) {
        BuildToolData buildToolData;
        TableItem tableItem;
        if (n >= 0 && n < this.fBuildToolsTable.getItemCount() && (tableItem = this.fBuildToolsTable.getItem(n)) != null && (buildToolData = (BuildToolData)tableItem.getData()) != null) {
            return buildToolData.getBuildToolId();
        }
        return null;
    }

    private boolean isBuildToolNecessaryForApplicationType(String string) {
        ArrayList arrayList;
        ITargetApplicationTypeDescriptor iTargetApplicationTypeDescriptor = this.provideTargetApplicationTypeDescriptor();
        return iTargetApplicationTypeDescriptor != null && (arrayList = iTargetApplicationTypeDescriptor.getNecessaryBuildTools()) != null && arrayList.contains(string);
    }

    private ITargetApplicationTypeDescriptor provideTargetApplicationTypeDescriptor() {
        ITargetApplicationTypeRegistry iTargetApplicationTypeRegistry = null;
        ITargetApplicationTypeDescriptor iTargetApplicationTypeDescriptor = null;
        if (CorePlugin.getDefault() != null) {
            iTargetApplicationTypeRegistry = CorePlugin.getDefault().getTargetApplicationTypeRegistry();
        }
        if (iTargetApplicationTypeRegistry != null) {
            iTargetApplicationTypeDescriptor = iTargetApplicationTypeRegistry.find(this.fsOriginalTargetApplicationType);
        }
        return iTargetApplicationTypeDescriptor;
    }

    private void handleTableSelectionChanged() {
        this.fAddFromAppButton.setEnabled(true);
        this.fAddButton.setEnabled(true);
        int n = this.fBuildToolsTable.getSelectionIndex();
        int n2 = this.fBuildToolsTable.getItemCount();
        if (n >= 0) {
            this.fRemoveButton.setEnabled(true);
            this.fUpButton.setEnabled(n != 0);
            this.fDownButton.setEnabled(n < n2 - 1);
        }
    }

    private void move(int n, int n2) {
        TableItem tableItem = this.fBuildToolsTable.getItem(n);
        BuildToolData buildToolData = (BuildToolData)tableItem.getData();
        String string = tableItem.getText();
        Image image = tableItem.getImage();
        TableItem tableItem2 = this.fBuildToolsTable.getItem(n2);
        BuildToolData buildToolData2 = (BuildToolData)tableItem2.getData();
        String string2 = tableItem2.getText();
        Image image2 = tableItem2.getImage();
        int n3 = buildToolData2.getSequenceNo();
        buildToolData2.setSequenceNo(buildToolData.getSequenceNo());
        buildToolData.setSequenceNo(n3);
        tableItem.setData((Object)buildToolData2);
        tableItem.setText(string2);
        tableItem.setImage(image2);
        tableItem2.setData((Object)buildToolData);
        tableItem2.setText(string);
        tableItem2.setImage(image);
    }

    private void moveSelectionDown() {
        int n;
        if (this.fBuildToolsTable.getSelectionCount() == 1 && (n = this.fBuildToolsTable.getSelectionIndex()) < this.fBuildToolsTable.getItemCount() - 1) {
            this.move(n, n + 1);
            this.fBuildToolsTable.setSelection(n + 1);
        }
    }

    private void moveSelectionUp() {
        int n = this.fBuildToolsTable.getSelectionIndex();
        if (n > 0 && this.fBuildToolsTable.getSelectionCount() == 1) {
            this.move(n - 1, n);
            this.fBuildToolsTable.setSelection(n - 1);
        }
    }

    public void performDefaults() {
        ITargetApplicationTypeDescriptor iTargetApplicationTypeDescriptor;
        ITargetApplicationTypeRegistry iTargetApplicationTypeRegistry = null;
        if (CorePlugin.getDefault() != null) {
            iTargetApplicationTypeRegistry = CorePlugin.getDefault().getTargetApplicationTypeRegistry();
        }
        if (iTargetApplicationTypeRegistry != null && (iTargetApplicationTypeDescriptor = iTargetApplicationTypeRegistry.find(this.fsOriginalTargetApplicationType)) != null) {
            ArrayList arrayList;
            String string;
            this.fBuildToolsTable.removeAll();
            this.fBuildToolsTable.update();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList arrayList3 = iTargetApplicationTypeDescriptor.getPreCompilerTools();
            if (arrayList3.size() != 0) {
                arrayList2.addAll(arrayList3);
            }
            if ((string = iTargetApplicationTypeDescriptor.getCompilerTool()) != null) {
                arrayList2.add(string);
            }
            if ((arrayList = iTargetApplicationTypeDescriptor.getPostCompilerTools()) != null) {
                arrayList2.addAll(arrayList);
            }
            int n = 0;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                String string2 = (String)arrayList2.get(n3);
                IBuildToolRegistry iBuildToolRegistry = CorePlugin.getDefault().getBuildToolsRegistry();
                if (iBuildToolRegistry != null) {
                    IBuildToolDescriptor iBuildToolDescriptor = iBuildToolRegistry.find(string2);
                    n = this.addBuildTool(iBuildToolDescriptor, n);
                }
                ++n3;
            }
        }
        this.handleTableSelectionChanged();
        this.validateDependencyRule();
    }

    private boolean validateDependencyRule() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.fBuildToolsTable.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            BuildToolData buildToolData = (BuildToolData)this.fBuildToolsTable.getItem(n2).getData();
            String string = buildToolData.getBuildToolId();
            if (arrayList != null) {
                arrayList.add(string);
            }
            ++n2;
        }
        String string = TargetApplicationTypeDescriptor.validateBuildToolDependencyRule(arrayList, false);
        if (string != null && string.length() > 0) {
            this.logStatus(string);
            this.setValid(false);
            return false;
        }
        this.logStatus("");
        this.setValid(true);
        return true;
    }

    private int getPositionToAdd(String string) {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = this.fBuildToolsTable.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            object = (BuildToolData)this.fBuildToolsTable.getItem(n2).getData();
            String string2 = ((BuildToolData)object).getBuildToolId();
            if (arrayList != null) {
                arrayList.add(string2);
            }
            ++n2;
        }
        arrayList.add(string);
        n2 = n;
        while (n2 >= 0) {
            object = TargetApplicationTypeDescriptor.validateBuildToolDependencyRule(arrayList, true);
            if (object == null || ((String)object).length() == 0) {
                return n2;
            }
            if (n2 > 0) {
                arrayList.remove(n2);
                arrayList.add(n2 - 1, string);
            }
            --n2;
        }
        return n;
    }

    private void refreshProjectMarkers(Map map, Map map2) {
        Collection collection = map.values();
        collection.removeAll(map2.values());
        Object[] objectArray = collection.toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                String[] stringArray = CorePlugin.getDefault().getBuildToolsRegistry().find((String)objectArray[n]).getMarkerTypes();
                int n2 = 0;
                while (stringArray != null && n2 < stringArray.length) {
                    TaskViewhelper.removeAllProblemMarkers((IResource)this.getInputProject(), stringArray[n2], true);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public boolean performOk() {
        BuildToolData buildToolData;
        Vector<String> vector = new Vector<String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("originaltargetapplicationtype", this.fsOriginalTargetApplicationType);
        int n = this.fBuildToolsTable.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            buildToolData = (BuildToolData)this.fBuildToolsTable.getItem(n2).getData();
            String string = buildToolData.getBuildToolId();
            vector.add(string);
            hashMap.put(String.valueOf(buildToolData.getSequenceNo()), string);
            ++n2;
        }
        if (this.validateDependencyRule()) {
            Object object;
            IProject iProject = this.getInputProject();
            try {
                Object object2;
                buildToolData = ResourcesPlugin.getWorkspace().getDescription();
                boolean bl = buildToolData.isAutoBuilding();
                if (bl) {
                    buildToolData.setAutoBuilding(false);
                    try {
                        ResourcesPlugin.getWorkspace().setDescription((IWorkspaceDescription)buildToolData);
                    }
                    catch (CoreException coreException) {}
                }
                if ((object = iProject.getDescription()) != null) {
                    object2 = object.getBuildSpec();
                    int n3 = ((ICommand[])object2).length;
                    int n4 = 0;
                    while (n4 < n3) {
                        if (object2[n4].getBuilderName().equals("org.eclipse.cobol.core.COBOLBuilder")) {
                            Map map = object2[n4].getArguments();
                            this.refreshProjectMarkers(map, hashMap);
                            object2[n4].setArguments(hashMap);
                            break;
                        }
                        ++n4;
                    }
                    object.setBuildSpec((ICommand[])object2);
                    iProject.setDescription((IProjectDescription)object, null);
                }
                object2 = new AntScriptGenerator(this.getInputProject());
                ((AntScriptGenerator)object2).run();
                BuildUiUtil.refreshFromLocal(this.getInputProject());
                if (bl) {
                    buildToolData.setAutoBuilding(true);
                    try {
                        ResourcesPlugin.getWorkspace().setDescription((IWorkspaceDescription)buildToolData);
                    }
                    catch (CoreException coreException) {}
                }
            }
            catch (CoreException coreException) {}
            boolean bl = super.performOk();
            final IProject iProject2 = iProject;
            object = new Thread(){

                /*
                 * Exception decompiling
                 */
                @Override
                public void run() {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * java.lang.IndexOutOfBoundsException: Index: 0, Size: 0
                     *     at java.base/java.util.LinkedList.checkElementIndex(LinkedList.java:566)
                     *     at java.base/java.util.LinkedList.get(LinkedList.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.combineInlineable(Block.java:226)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:560)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredCatch.transformStructuredChildren(StructuredCatch.java:88)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:129)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredTry.transformStructuredChildren(StructuredTry.java:127)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                     *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement$Inliner.transform(Op04StructuredStatement.java:557)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.inlinePossibles(Op04StructuredStatement.java:709)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:855)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }
            };
            ((Thread)object).start();
            return bl;
        }
        return false;
    }

    private void logStatus(String string) {
        String string2 = "";
        if (string == null) {
            this.setValid(true);
        } else if (string != null && string.length() == 0) {
            this.setValid(true);
        } else {
            string2 = string;
            this.setValid(false);
        }
        if (this.fErrorLabel != null) {
            this.fErrorLabel.setText(string2);
        }
    }
}

