/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.build.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPartDescriptor;
import org.eclipse.ui.PlatformUI;

public abstract class BaseAddBuildToolsDialog
extends Dialog
implements Listener {
    protected IWorkbenchPartDescriptor fSelectedElement = null;
    private Table fElementsTable = null;
    private Button fOkButton = null;
    private Button fCancelButton = null;
    private String fsDialogTitle = "";
    private String fsDialogMessage = "";
    protected Label fsDescriptionLabel = null;
    protected IWorkbenchPartDescriptor[] fElements = null;
    protected Image[] fElementsImages = null;
    protected ArrayList falElementsToFilter = null;
    private static final int TABLE_WIDTH = 200;

    public BaseAddBuildToolsDialog(Shell shell) {
        super(shell);
    }

    protected void buttonPressed(int n) {
        super.buttonPressed(n);
    }

    public boolean close() {
        if (this.fElementsImages != null) {
            int n = this.fElementsImages.length;
            int n2 = 0;
            while (n2 < n) {
                if (this.fElementsImages[n2] != null) {
                    this.fElementsImages[n2].dispose();
                }
                ++n2;
            }
            this.fElementsImages = null;
        }
        return super.close();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fsDialogTitle);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 2;
        Label label = new Label(composite2, 0);
        label.setFont(composite2.getFont());
        label.setText(this.fsDialogMessage);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setFont(composite.getFont());
        this.fElementsTable = new Table(composite2, 2820);
        this.fElementsTable.setFont(composite2.getFont());
        this.fElementsTable.addListener(13, (Listener)this);
        this.fElementsTable.addListener(14, (Listener)this);
        this.fElementsTable.addListener(8, (Listener)this);
        GridData gridData2 = new GridData();
        gridData2.widthHint = this.convertHorizontalDLUsToPixels(200);
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 4;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.horizontalSpan = 2;
        this.fElementsTable.setLayoutData((Object)gridData2);
        gridData2.heightHint = this.fElementsTable.getItemHeight() * 12;
        this.fsDescriptionLabel = new Label(composite2, 0);
        this.fsDescriptionLabel.setFont(composite2.getFont());
        this.fsDescriptionLabel.setText("");
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 2;
        this.fsDescriptionLabel.setLayoutData((Object)gridData3);
        this.fsDescriptionLabel.setFont(composite.getFont());
        this.fillElementsTable();
        this.updateEnableState();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getHelpId());
        return composite2;
    }

    protected void fillElementsTable() {
        this.fElementsTable.removeAll();
        this.fElementsTable.update();
        IWorkbenchPartDescriptor[] iWorkbenchPartDescriptorArray = null;
        Image[] imageArray = null;
        iWorkbenchPartDescriptorArray = this.getElements();
        imageArray = this.fElementsImages;
        this.fElementsTable.setRedraw(false);
        int n = iWorkbenchPartDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = new TableItem(this.fElementsTable, 0);
            tableItem.setData((Object)iWorkbenchPartDescriptorArray[n2]);
            tableItem.setText(iWorkbenchPartDescriptorArray[n2].getLabel());
            tableItem.setImage(imageArray[n2]);
            ++n2;
        }
        this.fElementsTable.setRedraw(true);
    }

    protected abstract void filterElements();

    protected static Image[] getImages(IWorkbenchPartDescriptor[] iWorkbenchPartDescriptorArray) {
        Image[] imageArray = new Image[iWorkbenchPartDescriptorArray.length];
        int n = iWorkbenchPartDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            if (iWorkbenchPartDescriptorArray[n2] != null && iWorkbenchPartDescriptorArray[n2].getImageDescriptor() != null) {
                imageArray[n2] = iWorkbenchPartDescriptorArray[n2].getImageDescriptor().createImage();
            }
            ++n2;
        }
        return imageArray;
    }

    protected abstract IWorkbenchPartDescriptor[] getElements();

    public IWorkbenchPartDescriptor getSelectedElement() {
        return this.fSelectedElement;
    }

    public void handleEvent(Event event) {
        if (event.type == 8) {
            this.handleDoubleClickEvent();
            return;
        }
        if (event.widget == this.fElementsTable) {
            if (this.fElementsTable.getSelectionIndex() != -1) {
                this.fSelectedElement = (IWorkbenchPartDescriptor)this.fElementsTable.getSelection()[0].getData();
                this.showDescription();
            } else {
                this.fSelectedElement = null;
                this.fOkButton.setEnabled(false);
            }
        }
        this.updateEnableState();
    }

    protected abstract void showDescription();

    protected void handleDoubleClickEvent() {
        this.buttonPressed(0);
    }

    public void setMessage(String string) {
        this.fsDialogMessage = string;
    }

    public void setElementsToFilter(ArrayList arrayList) {
        this.falElementsToFilter = arrayList;
    }

    public void updateEnableState() {
        this.updateOkButton();
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.fOkButton = this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.fCancelButton = this.createButton(composite, 1, IDialogConstants.CANCEL_LABEL, false);
        this.fOkButton.setEnabled(false);
    }

    protected void updateOkButton() {
        if (this.fOkButton == null) {
            return;
        }
        if (this.fElementsTable.getSelectionCount() == 0) {
            this.fOkButton.setEnabled(false);
            return;
        }
        this.fOkButton.setEnabled(this.fSelectedElement != null);
    }

    public void setDialogTitle(String string) {
        this.fsDialogTitle = string;
    }

    protected abstract String getHelpId();
}

