/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorShiftAction
extends TextEditorAction
implements ISelectionChangedListener {
    private int fOperationCode;
    private ITextOperationTarget fOperationTarget = null;
    private ITextEditor fEditor;

    public EditorShiftAction(String string, int n) {
        super(Messages.getResourceBundle(), string, null);
        this.fOperationCode = n;
        this.setEnabled(false);
    }

    public void run() {
        if (this.fOperationCode != -1 && this.fOperationTarget != null) {
            this.fOperationTarget.doOperation(this.fOperationCode);
        }
    }

    public void setEditor(ITextEditor iTextEditor) {
        ISelectionProvider iSelectionProvider;
        if (this.getTextEditor() != null && (iSelectionProvider = this.getTextEditor().getSelectionProvider()) != null) {
            iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        super.setEditor(iTextEditor);
        this.fEditor = iTextEditor;
        if (iTextEditor != null) {
            iSelectionProvider = iTextEditor.getSelectionProvider();
            if (iSelectionProvider != null) {
                iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
            this.fOperationTarget = (ITextOperationTarget)iTextEditor.getAdapter(ITextOperationTarget.class);
        } else {
            this.fOperationTarget = null;
        }
        this.selectionChanged(null);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        boolean bl = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
        this.setEnabled(bl);
    }
}

