/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.ui.actions;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ResourceBundle;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.ui.IUIPluginImages;
import org.eclipse.cobol.core.ui.actions.EditorShiftAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.TextEditorAction;

public class EditorActionContributor
extends BasicTextEditorActionContributor {
    private TextEditorAction fShiftRightAction = new EditorShiftAction("ShiftRight.", 8);
    private TextEditorAction fShiftLeftAction = new EditorShiftAction("ShiftLeft.", 9);
    private RetargetTextEditorAction fCutAction;
    private RetargetTextEditorAction fCopyAction;
    private RetargetTextEditorAction fPasteAction;
    private RetargetTextEditorAction fUndoAction;
    private RetargetTextEditorAction fRedoAction;
    private RetargetTextEditorAction findAction;
    private final String SHIFT_RIGHT = "ShiftRight.";
    private final String SHIFT_LEFT = "ShiftLeft.";
    private final String CUT_PREFIX = "Cut.";
    private final String COPY_PREFIX = "Copy.";
    private final String PASTE_PREFIX = "Paste.";
    private final String UNDO_PREFIX = "Undo.";
    private final String REDO_PREFIX = "Redo.";
    private final String FIND = "Find.";

    public EditorActionContributor() {
        this.fShiftRightAction.setAccelerator(0);
        this.fShiftLeftAction.setAccelerator(0);
        ResourceBundle resourceBundle = Messages.getResourceBundle();
        this.fCutAction = new RetargetTextEditorAction(resourceBundle, "Cut.");
        this.fCopyAction = new RetargetTextEditorAction(resourceBundle, "Copy.");
        this.fPasteAction = new RetargetTextEditorAction(resourceBundle, "Paste.");
        this.fUndoAction = new RetargetTextEditorAction(resourceBundle, "Undo.");
        this.fRedoAction = new RetargetTextEditorAction(resourceBundle, "Redo.");
        this.findAction = new RetargetTextEditorAction(resourceBundle, "Find.");
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        super.contributeToMenu(iMenuManager);
        try {
            IMenuManager iMenuManager2 = iMenuManager.findMenuUsingPath("edit");
            if (iMenuManager2 != null) {
                iMenuManager2.add((IContributionItem)new Separator());
                iMenuManager2.add((IAction)this.fShiftRightAction);
                iMenuManager2.add((IAction)this.fShiftLeftAction);
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        super.contributeToToolBar(iToolBarManager);
        try {
            IUIPluginImages.setToolImageDescriptors((IAction)this.fCutAction, "cut_edit");
            IUIPluginImages.setToolImageDescriptors((IAction)this.fCopyAction, "copy_edit");
            IUIPluginImages.setToolImageDescriptors((IAction)this.fPasteAction, "paste_edit");
            IUIPluginImages.setToolImageDescriptors((IAction)this.fUndoAction, "undo_edit");
            IUIPluginImages.setToolImageDescriptors((IAction)this.fRedoAction, "redo_edit");
            IUIPluginImages.setToolImageDescriptors((IAction)this.findAction, "search");
            iToolBarManager.add((IAction)this.fCutAction);
            iToolBarManager.add((IAction)this.fCopyAction);
            iToolBarManager.add((IAction)this.fPasteAction);
            iToolBarManager.add((IContributionItem)new Separator());
            iToolBarManager.add((IAction)this.fUndoAction);
            iToolBarManager.add((IAction)this.fRedoAction);
            iToolBarManager.add((IContributionItem)new Separator());
            iToolBarManager.add((IAction)this.findAction);
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        super.setActiveEditor(iEditorPart);
        ITextEditor iTextEditor = null;
        if (iEditorPart instanceof ITextEditor) {
            iTextEditor = (ITextEditor)iEditorPart;
        }
        this.fShiftRightAction.setEditor(iTextEditor);
        this.fShiftLeftAction.setEditor(iTextEditor);
        this.fCutAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.CUT));
        this.fCopyAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.COPY));
        this.fPasteAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.PASTE));
        this.fUndoAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.UNDO));
        this.fRedoAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.REDO));
        this.findAction.setAction(this.getAction(iTextEditor, ITextEditorActionConstants.FIND));
    }
}

