/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.registry.internal.core;

import com.unisys.os2200.i18nSupport.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.registry.internal.IBuildToolDescriptor;
import org.eclipse.cobol.core.registry.internal.IBuildToolRegistry;
import org.eclipse.cobol.core.registry.internal.ITargetApplicationTypeDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;

public class TargetApplicationTypeDescriptor
implements ITargetApplicationTypeDescriptor {
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_PROJECT_TYPE = "projecttype";
    private static final String ATT_PROJECT_TYPE_ID = "id";
    private static final String BUILD_TOOL = "buildtool";
    private static final String LAUNCHER = "launcher";
    private static final String ATT_ICON = "icon";
    private static final String ATT_DESC = "description";
    private static final String BUILD_TOOL_ATT_ID = "id";
    private static final String BUILD_TOOL_NECESSARY_ID = "necessary";
    private static final String LAUNCHER_ATT_ID = "id";
    private static final String ATT_PRECOMPILERS = "precompilers";
    private static final String ATT_POSTCOMPILERS = "postcompilers";
    private static final String ATT_COMPILER = "compiler";
    private static final String PRE_COMPILER_TOOL = "pre_compiler_tool";
    private static final String COMPILER_TOOL = "compiler_tool";
    private static final String POST_COMPILER_TOOL = "post_compiler_tool";
    private static final String PROJECT_NATURE_ID = "natureid";
    private String fId = null;
    private String fLabel = null;
    private String fsDescription = null;
    private ArrayList falPojectType = null;
    private ArrayList falPreBuildToolIds = new ArrayList();
    private String fsCompilerBuildToolId = null;
    private ArrayList falPostBuildToolIds = new ArrayList();
    private String fsLauncher = null;
    private ImageDescriptor fImageDescriptor = null;
    private IConfigurationElement fConfigElement = null;
    private boolean fbValidContribution = true;
    private ArrayList falNecessaryBuildTools = null;

    public TargetApplicationTypeDescriptor(IConfigurationElement iConfigurationElement) throws CoreException {
        this.falPojectType = new ArrayList();
        this.falNecessaryBuildTools = new ArrayList();
        this.fConfigElement = iConfigurationElement;
        this.loadFromExtension();
        this.validateIdUniqueness();
        this.validateBuildToolDependencyRule();
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.fImageDescriptor != null) {
            return this.fImageDescriptor;
        }
        String string = this.fConfigElement.getAttribute(ATT_ICON);
        if (string == null) {
            return null;
        }
        IPluginDescriptor iPluginDescriptor = this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor();
        URL uRL = iPluginDescriptor.find((IPath)new Path(string));
        if (uRL != null) {
            this.fImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
            return this.fImageDescriptor;
        }
        try {
            uRL = new URL(iPluginDescriptor.getInstallURL(), string);
            this.fImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
            return this.fImageDescriptor;
        }
        catch (MalformedURLException malformedURLException) {
            this.fImageDescriptor = null;
            return null;
        }
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public String getLauncher() {
        return this.fsLauncher;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void loadFromExtension() throws CoreException {
        block31: {
            if (this.fConfigElement == null) break block31;
            this.fId = this.fConfigElement.getAttribute("id").trim();
            this.fLabel = this.fConfigElement.getAttribute("name");
            this.fsDescription = this.fConfigElement.getAttribute("description");
            var1_1 = this.fConfigElement.getChildren("projecttype");
            if (var1_1 != null) {
                var1_1.length;
            }
            var2_2 = this.fConfigElement.getChildren("precompilers");
            var3_3 = 0;
            if (var2_2 != null) {
                var3_3 = var2_2.length;
            }
            if (var3_3 == 1) {
                var4_4 = var2_2[0].getChildren("buildtool");
                var5_5 = 0;
                if (var4_4 != null) {
                    var5_5 = var4_4.length;
                }
                var6_6 = 0;
                while (var6_6 < var5_5) {
                    var7_8 = var4_4[var6_6].getAttribute("id");
                    if (var7_8 != null) {
                        if (this.isElementExistInList(var7_8 = var7_8.trim(), this.falPreBuildToolIds)) {
                            this.fbValidContribution = false;
                            throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.Duplicate_precompilers_as_{0}_2", (Object)var7_8), null));
                        }
                        var8_10 /* !! */  = CorePlugin.getDefault().getBuildToolsRegistry().find(var7_8);
                        if (var8_10 /* !! */  != null && var8_10 /* !! */ .getToolType().equals("pre_compiler_tool")) {
                            this.falPreBuildToolIds.add(var7_8);
                        }
                        this.AddToNecessaryBuildTools(var4_4[var6_6]);
                    }
                    ++var6_6;
                }
            } else if (var3_3 > 1) {
                this.fbValidContribution = false;
                throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.Duplicate_no_of_precompilers_entity_for_{0}_3", (Object)this.fId), null));
            }
            var4_4 = this.fConfigElement.getChildren("compiler");
            var5_5 = 0;
            if (var4_4 != null) {
                var5_5 = var4_4.length;
            }
            if (var5_5 != 1) ** GOTO lbl56
            var6_7 = var4_4[0].getChildren("buildtool");
            var7_9 = 0;
            if (var6_7 != null) {
                var7_9 = var6_7.length;
            }
            if (var7_9 == 1) {
                var8_10 /* !! */  = var6_7[0].getAttribute("id");
                if (var8_10 /* !! */  != null) {
                    var8_10 /* !! */  = var8_10 /* !! */ .trim();
                    var9_11 = CorePlugin.getDefault().getBuildToolsRegistry().find((String)var8_10 /* !! */ );
                    if (var9_11 != null && var9_11.getToolType().equals("compiler_tool")) {
                        this.fsCompilerBuildToolId = var8_10 /* !! */ ;
                    }
                    this.AddToNecessaryBuildTools(var6_7[0]);
                }
            } else {
                this.fbValidContribution = false;
                throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.Should_have_one_compiler_for_{0}_4", (Object)this.fId), null));
lbl56:
                // 1 sources

                this.fbValidContribution = false;
                throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.Duplicate_no_of_compilers_entity_for_{0}_5", (Object)this.fId), null));
            }
            var6_7 = this.fConfigElement.getChildren("postcompilers");
            var7_9 = 0;
            if (var6_7 != null) {
                var7_9 = var6_7.length;
            }
            if (var7_9 == 1) {
                var8_10 /* !! */  = var6_7[0].getChildren("buildtool");
                var9_12 = 0;
                if (var8_10 /* !! */  != null) {
                    var9_12 = var8_10 /* !! */ .length;
                }
                var10_14 = 0;
                while (var10_14 < var9_12) {
                    var11_15 = var8_10 /* !! */ [var10_14].getAttribute("id");
                    if (var11_15 != null) {
                        if (this.isElementExistInList(var11_15 = var11_15.trim(), this.falPostBuildToolIds)) {
                            this.fbValidContribution = false;
                            throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.Duplicate_postcompilers_as_{0}_6", (Object)var11_15), null));
                        }
                        var12_16 = CorePlugin.getDefault().getBuildToolsRegistry().find(var11_15);
                        if (var12_16 != null && var12_16.getToolType().equals("post_compiler_tool")) {
                            this.falPostBuildToolIds.add(var11_15);
                        }
                        this.AddToNecessaryBuildTools(var8_10 /* !! */ [var10_14]);
                    }
                    ++var10_14;
                }
            } else if (var7_9 > 1) {
                this.fbValidContribution = false;
                throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.Duplicate_no_of_postcompilers_entity_for_{0}_7", (Object)this.fId), null));
            }
            var8_10 /* !! */  = this.fConfigElement.getChildren("launcher");
            var9_13 = 0;
            if (var8_10 /* !! */  != null) {
                var9_13 = var8_10 /* !! */ .length;
            }
            if (var9_13 == 1) {
                this.fsLauncher = var8_10 /* !! */ [0].getAttribute("id");
                if (this.fsLauncher != null) {
                    this.fsLauncher = this.fsLauncher.trim();
                }
            } else if (var9_13 > 1) {
                this.fbValidContribution = false;
                throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getString((String)"TargetApplicationTypeDescriptor.Should_not_mention_more_than_one_launcher_8"), null));
            }
            if (this.fId == null || this.fLabel == null) {
                throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.Missing_id_or_label_for_{0}__9", (Object)this.fId), null));
            }
        }
    }

    private void AddToNecessaryBuildTools(IConfigurationElement iConfigurationElement) {
        if (iConfigurationElement != null) {
            String string = iConfigurationElement.getAttribute("id");
            String string2 = iConfigurationElement.getAttribute(BUILD_TOOL_NECESSARY_ID);
            if (string != null && string2 != null && string2.equals("true")) {
                this.falNecessaryBuildTools.add(string);
            }
        }
    }

    private void validateIdUniqueness() throws CoreException {
        ITargetApplicationTypeDescriptor iTargetApplicationTypeDescriptor = CorePlugin.getDefault().getTargetApplicationTypeRegistry().find(this.fId);
        if (iTargetApplicationTypeDescriptor != null) {
            this.fbValidContribution = false;
            throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.target_application_type_id_is_not_unique_for_{0}_10", (Object)this.fId), null));
        }
    }

    private boolean isElementExistInList(String string, ArrayList arrayList) {
        if (arrayList != null) {
            for (String string2 : arrayList) {
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getBuildToolName(String string) {
        IBuildToolDescriptor iBuildToolDescriptor;
        IBuildToolRegistry iBuildToolRegistry;
        if (string != null && (iBuildToolRegistry = CorePlugin.getDefault().getBuildToolsRegistry()) != null && (iBuildToolDescriptor = iBuildToolRegistry.find(string)) != null) {
            String string2 = iBuildToolDescriptor.getLabel();
            return string2;
        }
        return string;
    }

    private static String getBuildToolNames(ArrayList arrayList) {
        IBuildToolRegistry iBuildToolRegistry;
        StringBuffer stringBuffer = new StringBuffer();
        if (arrayList != null && (iBuildToolRegistry = CorePlugin.getDefault().getBuildToolsRegistry()) != null) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                IBuildToolDescriptor iBuildToolDescriptor = iBuildToolRegistry.find((String)arrayList.get(n2));
                if (iBuildToolDescriptor != null) {
                    String string = iBuildToolDescriptor.getLabel();
                    stringBuffer.append("\"" + string + "\"");
                    stringBuffer.append(" ");
                }
                ++n2;
            }
            return stringBuffer.toString();
        }
        return arrayList.toString();
    }

    public static String validateBuildToolDependencyRule(ArrayList arrayList, boolean bl) {
        int n;
        int n2;
        Object object;
        int n3;
        Object object2;
        IBuildToolDescriptor iBuildToolDescriptor;
        String string;
        int n4;
        String string2 = "";
        int n5 = arrayList.size();
        IBuildToolRegistry iBuildToolRegistry = CorePlugin.getDefault().getBuildToolsRegistry();
        if (!bl) {
            n4 = 0;
            while (n4 < n5) {
                string = (String)arrayList.get(n4);
                if (iBuildToolRegistry != null && (iBuildToolDescriptor = iBuildToolRegistry.find(string)) != null) {
                    object2 = iBuildToolDescriptor.getExclusiveTools();
                    n3 = ((ArrayList)object2).size();
                    int n6 = 0;
                    while (n6 < n3) {
                        if (arrayList.contains(((ArrayList)object2).get(n6))) {
                            string2 = Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.{0}_buildtool_has_to_be_exclusive_with_the_tool_{1}_12", (Object)new Object[]{TargetApplicationTypeDescriptor.getBuildToolName((String)((ArrayList)object2).get(n6)), TargetApplicationTypeDescriptor.getBuildToolName(string)});
                            return string2;
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < n5) {
                string = (String)arrayList.get(n4);
                if (iBuildToolRegistry != null && (iBuildToolDescriptor = iBuildToolRegistry.find(string)) != null && !arrayList.containsAll((Collection<?>)(object2 = iBuildToolDescriptor.getNecessaryTools()))) {
                    string2 = Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.{0}_should_have_the_following_necessary_build_tools__{1}_13", (Object)new Object[]{TargetApplicationTypeDescriptor.getBuildToolName(string), TargetApplicationTypeDescriptor.getBuildToolNames((ArrayList)object2)});
                    return string2;
                }
                ++n4;
            }
        }
        n4 = 0;
        while (n4 < n5) {
            string = (String)arrayList.get(n4);
            if (iBuildToolRegistry != null && (iBuildToolDescriptor = iBuildToolRegistry.find(string)) != null) {
                object2 = iBuildToolDescriptor.getPreTools();
                ArrayList arrayList2 = iBuildToolDescriptor.getPostTools();
                List list = arrayList.subList(0, n4);
                object = arrayList.subList(n4 + 1, n5);
                int n7 = ((ArrayList)object2).size();
                n2 = 0;
                while (n2 < n7) {
                    if (((String)((ArrayList)object2).get(n2)).equals("*") && (n = object.size()) > 0) {
                        string2 = Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.{0}_should_be_the_last_tool__20", (Object)TargetApplicationTypeDescriptor.getBuildToolName(string));
                        return string2;
                    }
                    ++n2;
                }
                n2 = arrayList2.size();
                n = 0;
                while (n < n2) {
                    int n8;
                    if (((String)arrayList2.get(n)).equals("*") && (n8 = list.size()) > 0) {
                        string2 = Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.{0}_should_be_the_first_tool_23", (Object)TargetApplicationTypeDescriptor.getBuildToolName(string));
                        return string2;
                    }
                    ++n;
                }
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n5) {
            string = (String)arrayList.get(n4);
            if (iBuildToolRegistry != null && (iBuildToolDescriptor = iBuildToolRegistry.find(string)) != null && ((String)(object2 = iBuildToolDescriptor.getToolType())).equalsIgnoreCase(COMPILER_TOOL)) {
                n3 = 0;
                while (n3 < n4) {
                    String string3;
                    String string4 = (String)arrayList.get(n3);
                    object = iBuildToolRegistry.find(string4);
                    if (object != null && (string3 = object.getToolType()) != null && string3.equalsIgnoreCase(POST_COMPILER_TOOL)) {
                        string2 = Messages.getFormattedString((String)"TargetApplicationTypeDescriptor._{0}_should_appear_after_the_tool_{1}_24", (Object)new Object[]{TargetApplicationTypeDescriptor.getBuildToolName(string4), TargetApplicationTypeDescriptor.getBuildToolName(string)});
                        return string2;
                    }
                    ++n3;
                }
                n3 = n4 + 1;
                while (n3 < n5) {
                    String string5;
                    String string6 = (String)arrayList.get(n3);
                    object = iBuildToolRegistry.find(string6);
                    if (object != null && (string5 = object.getToolType()) != null && string5.equalsIgnoreCase(PRE_COMPILER_TOOL)) {
                        string2 = Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.{0}_should_appear_before_the_tool_{1}_21", (Object)new Object[]{TargetApplicationTypeDescriptor.getBuildToolName(string6), TargetApplicationTypeDescriptor.getBuildToolName(string)});
                        return string2;
                    }
                    ++n3;
                }
                break;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n5) {
            string = (String)arrayList.get(n4);
            if (iBuildToolRegistry != null && (iBuildToolDescriptor = iBuildToolRegistry.find(string)) != null) {
                object2 = iBuildToolDescriptor.getPreTools();
                ArrayList arrayList3 = iBuildToolDescriptor.getPostTools();
                List list = arrayList.subList(0, n4);
                object = arrayList.subList(n4 + 1, n5);
                int n9 = ((ArrayList)object2).size();
                n2 = 0;
                while (n2 < n9) {
                    if (object.contains(((ArrayList)object2).get(n2))) {
                        string2 = Messages.getFormattedString((String)"TargetApplicationTypeDescriptor.{0}_should_appear_before_the_tool_{1}_21", (Object)new Object[]{TargetApplicationTypeDescriptor.getBuildToolName((String)((ArrayList)object2).get(n2)), TargetApplicationTypeDescriptor.getBuildToolName(string)});
                        return string2;
                    }
                    ++n2;
                }
                n2 = arrayList3.size();
                n = 0;
                while (n < n2) {
                    if (list.contains(arrayList3.get(n))) {
                        string2 = Messages.getFormattedString((String)"TargetApplicationTypeDescriptor._{0}_should_appear_after_the_tool_{1}_24", (Object)new Object[]{TargetApplicationTypeDescriptor.getBuildToolName((String)arrayList3.get(n)), TargetApplicationTypeDescriptor.getBuildToolName(string)});
                        return string2;
                    }
                    ++n;
                }
            }
            ++n4;
        }
        return string2;
    }

    private void validateBuildToolDependencyRule() throws CoreException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.falPreBuildToolIds != null) {
            arrayList.addAll(this.falPreBuildToolIds);
        }
        if (this.fsCompilerBuildToolId != null) {
            arrayList.add(this.fsCompilerBuildToolId);
        }
        if (this.falPostBuildToolIds != null) {
            arrayList.addAll(this.falPostBuildToolIds);
        }
        if ((string = TargetApplicationTypeDescriptor.validateBuildToolDependencyRule(arrayList, false)).length() > 0) {
            throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, string, null));
        }
    }

    public boolean isContributionValid() {
        return this.fbValidContribution;
    }

    @Override
    public String getDescription() {
        return this.fsDescription;
    }

    @Override
    public ArrayList getProjectTypes() {
        return this.falPojectType;
    }

    @Override
    public String getCompilerTool() {
        return this.fsCompilerBuildToolId;
    }

    @Override
    public ArrayList getPostCompilerTools() {
        return this.falPostBuildToolIds;
    }

    @Override
    public ArrayList getPreCompilerTools() {
        return this.falPreBuildToolIds;
    }

    @Override
    public ArrayList getNecessaryBuildTools() {
        return this.falNecessaryBuildTools;
    }
}

