/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.registry.internal.core;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.core.registry.internal.ICOBOLContributorDescriptor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.BusyIndicator;

public class COBOLContributorDescriptor
implements ICOBOLContributorDescriptor {
    private static final String PROVIDER_ID = "id";
    private static final String PROVIDER_NAME = "name";
    private static final String PROVIDER_CLSNAME = "contributorClass";
    private static final String PROVIDER_ICON = "icon";
    private IConfigurationElement fConfigElement;
    private String fProviderId;
    private String fProviderName;
    private String fProviderClass;
    private ICOBOLContributor fContributor;
    private boolean fIsValidContribution = true;
    private ImageDescriptor fImageDescriptor;

    public COBOLContributorDescriptor(IConfigurationElement iConfigurationElement) throws CoreException {
        this.fConfigElement = iConfigurationElement;
        this.loadFromContribution();
        this.checkIDUniqueness();
        this.validateClass(iConfigurationElement);
    }

    private void loadFromContribution() throws CoreException {
        if (this.fConfigElement != null) {
            this.fProviderId = this.fConfigElement.getAttribute(PROVIDER_ID).trim();
            this.fProviderName = this.fConfigElement.getAttribute(PROVIDER_NAME).trim();
            this.fProviderClass = this.fConfigElement.getAttribute(PROVIDER_CLSNAME).trim();
        }
    }

    private void checkIDUniqueness() {
    }

    private void validateClass(IConfigurationElement iConfigurationElement) throws CoreException {
        if (this.fIsValidContribution) {
            this.fContributor = this.createContributorClass(iConfigurationElement);
            if (this.fContributor != null) {
                return;
            }
            this.fIsValidContribution = false;
            throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, "Class not found", null));
        }
    }

    private ICOBOLContributor createContributorClass(IConfigurationElement iConfigurationElement) throws CoreException {
        Object object = COBOLContributorDescriptor.createExtension(iConfigurationElement, PROVIDER_CLSNAME);
        return (ICOBOLContributor)object;
    }

    public static Object createExtension(final IConfigurationElement iConfigurationElement, final String string) throws CoreException {
        IPluginDescriptor iPluginDescriptor = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor();
        if (iPluginDescriptor.isPluginActivated()) {
            return iConfigurationElement.createExecutableExtension(string);
        }
        final Object[] objectArray = new Object[1];
        final CoreException[] coreExceptionArray = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    objectArray[0] = iConfigurationElement.createExecutableExtension(string);
                }
                catch (CoreException coreException) {
                    coreExceptionArray[0] = coreException;
                }
            }
        });
        if (coreExceptionArray[0] != null) {
            throw coreExceptionArray[0];
        }
        return objectArray[0];
    }

    public String getId() {
        return this.fProviderId;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fImageDescriptor != null) {
            return this.fImageDescriptor;
        }
        String string = this.fConfigElement.getAttribute(PROVIDER_ICON);
        if (string == null) {
            return null;
        }
        IPluginDescriptor iPluginDescriptor = this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor();
        URL uRL = iPluginDescriptor.find((IPath)new Path(string));
        if (uRL != null) {
            this.fImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
            return this.fImageDescriptor;
        }
        try {
            uRL = new URL(iPluginDescriptor.getInstallURL(), string);
            this.fImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
            return this.fImageDescriptor;
        }
        catch (MalformedURLException malformedURLException) {
            this.fImageDescriptor = null;
            return null;
        }
    }

    public String getLabel() {
        return this.fProviderName;
    }

    public boolean isValidContribution() {
        return this.fIsValidContribution;
    }

    @Override
    public IConfigurationElement getConfigurationElement() {
        return this.fConfigElement;
    }

    @Override
    public ICOBOLContributor getCOBOLContributor() {
        return this.fContributor;
    }

    @Override
    public String getProviderID() {
        return this.fProviderId;
    }

    @Override
    public String getProviderName() {
        return this.fProviderName;
    }
}

