/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.registry.internal.core;

import com.unisys.os2200.i18nSupport.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.model.IBuildTool;
import org.eclipse.cobol.core.registry.internal.IBuildToolDescriptor;
import org.eclipse.cobol.core.registry.internal.core.CoreUtility;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;

public class BuildToolDescriptor
implements IBuildToolDescriptor {
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "class";
    private static final String ATT_PROJECT_TYPE = "projecttype";
    private static final String ATT_PROJECT_TYPE_ID = "id";
    private static final String ATT_ICON = "icon";
    private static final String ATT_DESC = "description";
    private static final String ATT_TOOL_TYPE = "tooltype";
    private static final String ATT_MARKER_TYPE = "markertype";
    private static final String ATT_ENABLED = "enabled";
    private static final String ATT_PRE_TOOLS = "pretools";
    private static final String ATT_POST_TOOLS = "posttools";
    private static final String ATT_NECESSARY_TOOLS = "necessarytools";
    private static final String ATT_EXCLUSIVE_TOOLS = "exclusivetools";
    private static final String ATT_BUILD_TOOLS_ID = "id";
    private String fId = null;
    private String fLabel = null;
    private String fClassName = null;
    private boolean bBuildToolEnabled = true;
    private ArrayList falPojectType = null;
    private ImageDescriptor fImageDescriptor = null;
    private String fsDescription = null;
    private String fsToolType = null;
    private String[] fMarkerTypes = null;
    private ArrayList falPreTools = null;
    private ArrayList falPostTools = null;
    private ArrayList falNecessaryTools = null;
    private ArrayList falExclusiveTools = null;
    private IConfigurationElement fConfigElement = null;
    private boolean fbValidContribution = true;

    public BuildToolDescriptor(IConfigurationElement iConfigurationElement) throws CoreException {
        this.fConfigElement = iConfigurationElement;
        this.falPojectType = new ArrayList();
        this.falPreTools = new ArrayList();
        this.falPostTools = new ArrayList();
        this.falNecessaryTools = new ArrayList();
        this.falExclusiveTools = new ArrayList();
        this.loadFromExtension();
        this.validateIdUniqueness();
        this.validateClass();
        this.validatePreAndPostTools();
    }

    private boolean isValidMarker(String string) {
        return true;
    }

    private void loadFromExtension() throws CoreException {
        if (this.fConfigElement != null) {
            String string;
            IConfigurationElement[] iConfigurationElementArray;
            this.fId = this.fConfigElement.getAttribute("id").trim();
            this.fLabel = this.fConfigElement.getAttribute(ATT_NAME);
            this.fsDescription = this.fConfigElement.getAttribute(ATT_DESC);
            this.fsToolType = this.fConfigElement.getAttribute(ATT_TOOL_TYPE);
            if (this.fsToolType == null) {
                this.fbValidContribution = false;
                throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.tooltype_is_missing_for_{0}_1", (Object)this.fId), null));
            }
            String string2 = this.fConfigElement.getAttribute(ATT_MARKER_TYPE);
            if (string2 != null) {
                int n = 0;
                iConfigurationElementArray = new StringTokenizer(string2, ",");
                this.fMarkerTypes = new String[iConfigurationElementArray.countTokens()];
                while (iConfigurationElementArray.hasMoreTokens()) {
                    this.fMarkerTypes[n++] = iConfigurationElementArray.nextToken().trim();
                    this.isValidMarker(this.fMarkerTypes[n - 1]);
                }
            }
            this.bBuildToolEnabled = (string = this.fConfigElement.getAttribute(ATT_ENABLED)) == null ? true : (string.equalsIgnoreCase("true") ? true : !string.equalsIgnoreCase("false"));
            this.fClassName = this.fConfigElement.getAttribute(ATT_CLASS).trim();
            iConfigurationElementArray = this.fConfigElement.getChildren(ATT_PROJECT_TYPE);
            int n = 0;
            if (iConfigurationElementArray != null) {
                n = iConfigurationElementArray.length;
            }
            int n2 = 0;
            while (n2 < n) {
                String string3 = iConfigurationElementArray[n2].getAttribute("id");
                if (string3 != null) {
                    if (this.isElementExistsInList(string3 = string3.trim(), this.falPojectType)) {
                        this.fbValidContribution = false;
                        throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.Duplicate_project_types_as_{0}__2", (Object)string3), null));
                    }
                    this.falPojectType.add(string3);
                }
                ++n2;
            }
            IConfigurationElement[] iConfigurationElementArray2 = this.fConfigElement.getChildren(ATT_PRE_TOOLS);
            int n3 = 0;
            if (iConfigurationElementArray2 != null) {
                n3 = iConfigurationElementArray2.length;
            }
            int n4 = 0;
            while (n4 < n3) {
                String string4 = iConfigurationElementArray2[n4].getAttribute("id");
                if (string4 != null) {
                    if (this.isElementExistsInList(string4 = string4.trim(), this.falPreTools)) {
                        this.fbValidContribution = false;
                        throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.Duplicate_pre_tools_as_{0}_3", (Object)string4), null));
                    }
                    this.falPreTools.add(string4);
                }
                ++n4;
            }
            IConfigurationElement[] iConfigurationElementArray3 = this.fConfigElement.getChildren(ATT_POST_TOOLS);
            int n5 = 0;
            if (iConfigurationElementArray3 != null) {
                n5 = iConfigurationElementArray3.length;
            }
            int n6 = 0;
            while (n6 < n5) {
                String string5 = iConfigurationElementArray3[n6].getAttribute("id");
                if (string5 != null) {
                    if (this.isElementExistsInList(string5 = string5.trim(), this.falPostTools)) {
                        this.fbValidContribution = false;
                        throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.Duplicate_post_tools_{0}_4", (Object)string5), null));
                    }
                    this.falPostTools.add(string5);
                }
                ++n6;
            }
            IConfigurationElement[] iConfigurationElementArray4 = this.fConfigElement.getChildren(ATT_NECESSARY_TOOLS);
            int n7 = 0;
            if (iConfigurationElementArray4 != null) {
                n7 = iConfigurationElementArray4.length;
            }
            int n8 = 0;
            while (n8 < n7) {
                String string6 = iConfigurationElementArray4[n8].getAttribute("id");
                if (string6 != null) {
                    if (this.isElementExistsInList(string6 = string6.trim(), this.falNecessaryTools)) {
                        this.fbValidContribution = false;
                        throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.Duplicate_necessary_tools_as_{0}_5", (Object)string6), null));
                    }
                    this.falNecessaryTools.add(string6);
                }
                ++n8;
            }
            IConfigurationElement[] iConfigurationElementArray5 = this.fConfigElement.getChildren(ATT_EXCLUSIVE_TOOLS);
            int n9 = 0;
            if (iConfigurationElementArray5 != null) {
                n9 = iConfigurationElementArray5.length;
            }
            int n10 = 0;
            while (n10 < n9) {
                String string7 = iConfigurationElementArray5[n10].getAttribute("id");
                if (string7 != null) {
                    if (this.isElementExistsInList(string7 = string7.trim(), this.falExclusiveTools)) {
                        this.fbValidContribution = false;
                        throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.Duplicate_exclusive_tools_as_{0}_6", (Object)string7), null));
                    }
                    this.falExclusiveTools.add(string7);
                }
                ++n10;
            }
            if (this.fId == null || this.fLabel == null || this.fClassName == null) {
                throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.Missing_id_or_label_or_class_name_for_{0}_7", (Object)this.fId), null));
            }
        }
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        if (this.fImageDescriptor != null) {
            return this.fImageDescriptor;
        }
        String string = this.fConfigElement.getAttribute(ATT_ICON);
        if (string == null) {
            return null;
        }
        IPluginDescriptor iPluginDescriptor = this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor();
        URL uRL = iPluginDescriptor.find((IPath)new Path(string));
        if (uRL != null) {
            this.fImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
            return this.fImageDescriptor;
        }
        try {
            uRL = new URL(iPluginDescriptor.getInstallURL(), string);
            this.fImageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
            return this.fImageDescriptor;
        }
        catch (MalformedURLException malformedURLException) {
            this.fImageDescriptor = null;
            return null;
        }
    }

    @Override
    public String getLabel() {
        return this.fLabel;
    }

    @Override
    public String getClassName() {
        return this.fClassName;
    }

    @Override
    public String[] getMarkerTypes() {
        return this.fMarkerTypes;
    }

    @Override
    public ArrayList getProjectTypes() {
        return this.falPojectType;
    }

    private void validateIdUniqueness() throws CoreException {
        IBuildToolDescriptor iBuildToolDescriptor;
        if (CorePlugin.getDefault() != null && (iBuildToolDescriptor = CorePlugin.getDefault().getBuildToolsRegistry().find(this.fId)) != null) {
            this.fbValidContribution = false;
            throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.Duplicate_build_tool_id_as_{0}_8", (Object)this.fId), null));
        }
    }

    private void validateClass() throws CoreException {
        if (this.fbValidContribution) {
            if (this.createBuildTool() != null) {
                return;
            }
            this.fbValidContribution = false;
            throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.Class_not_found_for_{0}_9", (Object)this.fId), null));
        }
    }

    public boolean isContributionValid() {
        return this.fbValidContribution;
    }

    @Override
    public IBuildTool createBuildTool() throws CoreException {
        Object object = CoreUtility.createExtension(this.fConfigElement, ATT_CLASS);
        return (IBuildTool)object;
    }

    private boolean isElementExistsInList(String string, ArrayList arrayList) {
        if (arrayList != null) {
            for (String string2 : arrayList) {
                if (string2 == null || !string2.equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    private void validatePreAndPostTools() throws CoreException {
        if (this.falPreTools != null && this.falPreTools.contains("*") && this.falPreTools.size() != 1) {
            throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.Should_contain_only_one_entry_with_*_for_pretools_of_{0}_11", (Object)this.fId), null));
        }
        if (this.falPostTools != null && this.falPostTools.contains("*") && this.falPostTools.size() != 1) {
            throw new CoreException((IStatus)new Status(4, this.fConfigElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier(), 0, Messages.getFormattedString((String)"BuildToolDescriptor.Should_contain_only_one_entry_with_*_for_posttools_of_{0}_13", (Object)this.fId), null));
        }
    }

    @Override
    public String getDescription() {
        return this.fsDescription;
    }

    @Override
    public ArrayList getExclusiveTools() {
        return this.falExclusiveTools;
    }

    @Override
    public ArrayList getNecessaryTools() {
        return this.falNecessaryTools;
    }

    @Override
    public ArrayList getPostTools() {
        return this.falPostTools;
    }

    @Override
    public ArrayList getPreTools() {
        return this.falPreTools;
    }

    @Override
    public String getToolType() {
        return this.fsToolType;
    }

    @Override
    public boolean isBuildToolEnabled() {
        return this.bBuildToolEnabled;
    }
}

