/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build.util.ant;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cobol.core.ICommonConstants;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.core.build.util.ant.FileSet;

public class AntScriptGeneratorHelper {
    public static String generateAntCallTask(int n, String string, String string2, Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<antcall");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("target", string, true));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("inheritAll", string2, false));
        if (map == null) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append(">");
            Set set = map.entrySet();
            for (Map.Entry entry : set) {
                stringBuffer.append(AntScriptGeneratorHelper.generateParam(n + 1, (String)entry.getKey(), (String)entry.getValue()));
            }
            stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
            stringBuffer.append("</antcall>");
        }
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public static String generateArg(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<arg");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("line", string, false));
        stringBuffer.append("/>");
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public static String generateString(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String generateComment(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<!-- ");
        stringBuffer.append(string);
        stringBuffer.append(" -->");
        return stringBuffer.toString();
    }

    public static String generateAttribute(String string, String string2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && string2 == null) {
            string2 = "";
        }
        if (string2 != null) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append("=");
            stringBuffer.append(AntScriptGeneratorHelper.generateQuotes(string2));
        }
        return stringBuffer.toString();
    }

    public static String generateDeleteTask(int n, String string, String string2, FileSet[] fileSetArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<delete");
        if (string != null) {
            stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("dir", string, false));
        }
        if (string2 != null) {
            stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("file", string2, false));
        }
        if (fileSetArray == null) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append(">");
            stringBuffer.append(ICommonConstants.EOL);
            int n2 = 0;
            while (n2 < fileSetArray.length) {
                stringBuffer.append(fileSetArray[n2].generateFileSetTask(n + 1));
                ++n2;
            }
            stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
            stringBuffer.append("</delete>");
        }
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public static String generateExecTask(int n, String string, String string2, String string3, List list) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<exec");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("dir", string2, false));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("executable", string, true));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("failonerror", string3, true));
        if (list == null || list.size() == 0) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append(">");
            stringBuffer.append(ICommonConstants.EOL);
            int n2 = 0;
            while (n2 < list.size()) {
                stringBuffer.append(AntScriptGeneratorHelper.generateArg(n + 1, (String)list.get(n2)));
                ++n2;
            }
            stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
            stringBuffer.append("</exec>");
        }
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public static String generateMkdirTask(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<mkdir");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("dir", CommonBuildUtil.charToCode(string), false));
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public static String generateUptodateTask(int n, String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<uptodate");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("property", string, true));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("targetfile", string2, true));
        stringBuffer.append(">");
        stringBuffer.append(ICommonConstants.EOL);
        stringBuffer.append(AntScriptGeneratorHelper.generateSrcfilesTask(n + 1, string3, string4));
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("</uptodate>");
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public static String generateEchoTask(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<echo");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("message", string, true));
        stringBuffer.append("/>");
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public static String generateTaskdefTask(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<taskdef");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("name", string, true));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("classname", string2, true));
        stringBuffer.append("/>");
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public static String generateErrorTask(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<error");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("message", string, true));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("fail", string2, true));
        stringBuffer.append("/>");
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public static String generateFailTask(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<fail");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("message", string, true));
        stringBuffer.append("/>");
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public static String generateParam(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<param");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("name", string, true));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("value", string2, true));
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public static String generateProjectDeclaration(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<project");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("name", string, false));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("default", string2, true));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("basedir", string3, false));
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static String generateProjectDeclarationEnd() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("</project>");
        return stringBuffer.toString();
    }

    public static String generateProperty(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<property");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("name", string, true));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("value", CommonBuildUtil.charToCode(string2), true));
        stringBuffer.append("/>");
        return stringBuffer.toString();
    }

    public static String generateQuotes(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
        return stringBuffer.toString();
    }

    public static String generateStartTag(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static String generateEndTag(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("</");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }

    public static String generateTab(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\t");
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String generateTargetDeclaration(int n, String string, String string2, String string3, String string4, String string5) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<target");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("name", string, true));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("depends", string2, false));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("if", string3, false));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("unless", string4, false));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("description", string5, false));
        stringBuffer.append(">");
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public static String generateTargetDeclarationEnd(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("</target>");
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    private static String generateSrcfilesTask(int n, String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateTab(n));
        stringBuffer.append("<srcfiles");
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("dir", string, true));
        stringBuffer.append(AntScriptGeneratorHelper.generateAttribute("includes", string2, true));
        stringBuffer.append("/>");
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }
}

