/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build.util;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class TaskViewhelper {
    private static TaskViewhelper fTaskViewHelper = null;
    private ArrayList falProblemMarkers = new ArrayList();

    private TaskViewhelper() {
        fTaskViewHelper = this;
    }

    public static TaskViewhelper getDefault() {
        if (fTaskViewHelper == null) {
            fTaskViewHelper = new TaskViewhelper();
        }
        return fTaskViewHelper;
    }

    public ArrayList getProblemMarkerType(String string) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        while (n < this.falProblemMarkers.size()) {
            ProblemMarker problemMarker = (ProblemMarker)this.falProblemMarkers.get(n);
            if (problemMarker.getType().equals(string)) {
                arrayList.add(new Integer(problemMarker.getSeverity()));
            }
            ++n;
        }
        return arrayList;
    }

    public void addProblemMarker(IResource iResource, String string, int n, int n2, Integer n3, Integer n4, Integer n5) {
        ProblemMarker problemMarker = new ProblemMarker("org.eclipse.cobol.core.problem", iResource, string, n, n2, n3, n4, n5);
        if (problemMarker != null) {
            this.falProblemMarkers.add(problemMarker);
        }
    }

    public void addProblemMarker(IResource iResource, String string, int n, int n2, Integer n3, Integer n4, Integer n5, Map map) {
        ProblemMarker problemMarker = new ProblemMarker("org.eclipse.cobol.core.problem", iResource, string, n, n2, n3, n4, n5, map);
        this.falProblemMarkers.add(problemMarker);
    }

    public void addProblemMarker(String string, IResource iResource, String string2, int n, int n2, Integer n3, Integer n4, Integer n5, Map map) {
        ProblemMarker problemMarker = new ProblemMarker(string, iResource, string2, n, n2, n3, n4, n5, map);
        this.falProblemMarkers.add(problemMarker);
    }

    public void addProblemMarker(String string, IResource iResource, String string2, int n, int n2, Integer n3, Integer n4, Integer n5) {
        ProblemMarker problemMarker = new ProblemMarker(string, iResource, string2, n, n2, n3, n4, n5);
        this.falProblemMarkers.add(problemMarker);
    }

    public void flush() {
        this.refreshResources();
        ArrayList arrayList = this.falProblemMarkers;
        if (arrayList != null && arrayList.size() > 0) {
            IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                    int n = TaskViewhelper.this.falProblemMarkers.size();
                    int n2 = 0;
                    while (n2 < n) {
                        ProblemMarker problemMarker = (ProblemMarker)TaskViewhelper.this.falProblemMarkers.get(n2);
                        IResource iResource = problemMarker.getResource();
                        if (iResource != null) {
                            String string = problemMarker.getMessage();
                            int n3 = problemMarker.getSeverity();
                            int n4 = problemMarker.getPriority();
                            Integer n5 = problemMarker.getLineNumber();
                            Integer n6 = problemMarker.getCharStart();
                            Integer n7 = problemMarker.getCharEnd();
                            HashMap<String, String> hashMap = problemMarker.getAttributes();
                            if (hashMap == null) {
                                hashMap = new HashMap<String, String>();
                            }
                            hashMap.put("message", string);
                            hashMap.put("priority", (String)((Object)new Integer(n4)));
                            hashMap.put("severity", (String)((Object)new Integer(n3)));
                            if (n5 != null && n5 != 0) {
                                hashMap.put("lineNumber", (String)((Object)n5));
                            }
                            if (n6 != null && n6 != 0 && n7 != null && n7 != 0) {
                                hashMap.put("charStart", (String)((Object)n6));
                                hashMap.put("charEnd", (String)((Object)n7));
                            }
                            HashMap<String, String> hashMap2 = hashMap;
                            try {
                                IMarker iMarker = problemMarker.getType() == null ? iResource.createMarker("org.eclipse.cobol.core.problem") : iResource.createMarker(problemMarker.getType());
                                if (hashMap2 != null) {
                                    iMarker.setAttributes(hashMap2);
                                }
                            }
                            catch (CoreException coreException) {
                                CorePlugin.logError((Exception)((Object)coreException));
                            }
                        }
                        ++n2;
                    }
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(iWorkspaceRunnable, null);
            }
            catch (CoreException coreException) {
                CorePlugin.logError((Exception)((Object)coreException));
            }
        }
        this.falProblemMarkers.clear();
    }

    private void refreshResources() {
        int n = this.falProblemMarkers.size();
        ArrayList<IProject> arrayList = new ArrayList<IProject>();
        int n2 = 0;
        while (n2 < n) {
            ProblemMarker problemMarker = (ProblemMarker)this.falProblemMarkers.get(n2);
            if (problemMarker != null) {
                IResource iResource = problemMarker.getResource();
                IProject iProject = null;
                if (iResource != null) {
                    iProject = iResource.getProject();
                }
                if (iProject != null && iProject.exists() && !arrayList.contains(iProject)) {
                    arrayList.add(iProject);
                    try {
                        iProject.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException coreException) {
                        CorePlugin.logError((Exception)((Object)coreException));
                    }
                }
                if (iResource == null || !iResource.exists()) {
                    this.falProblemMarkers.remove(n2);
                    n = this.falProblemMarkers.size();
                    --n2;
                }
            }
            ++n2;
        }
    }

    public static void removeAllProblemMarkers(IResource iResource) {
        TaskViewhelper.removeAllProblemMarkers(iResource, "org.eclipse.cobol.core.problem", true);
    }

    public static void removeAllProblemMarkers(IResource iResource, String string, boolean bl) {
        try {
            ICommand[] iCommandArray;
            if (((IProject)iResource).getDescription().hasNature("org.eclipse.cobol.core.COBOLNature") && (iCommandArray = ((IProject)iResource).getDescription().getBuildSpec()) != null && iCommandArray.length > 0) {
                int n = 0;
                while (n < iCommandArray.length) {
                    if (iCommandArray[n].getArguments().containsValue("org.eclipse.cobol.core.build.cobolproject")) {
                        IMarker[] iMarkerArray = iResource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                        int n2 = 0;
                        while (n2 < iMarkerArray.length) {
                            IResource iResource2 = iMarkerArray[n2].getResource();
                            if (iMarkerArray[n2].exists()) {
                                iResource2.deleteMarkers(iMarkerArray[n2].getType(), true, 2);
                            } else {
                                iMarkerArray[n2].delete();
                            }
                            ++n2;
                        }
                    } else if (iResource != null && string != null) {
                        iResource.deleteMarkers(string, bl, 2);
                    }
                    ++n;
                }
            }
        }
        catch (CoreException coreException) {
            CorePlugin.logError((Exception)((Object)coreException));
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CorePlugin.logError(exception);
        }
    }

    public static void refreshBuildFailedMarker(IResource iResource) {
        if (iResource == null) {
            return;
        }
        try {
            IMarker[] iMarkerArray = ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager().findMarkers(iResource, "org.eclipse.cobol.core.problem", true, 2);
            int n = -1;
            int n2 = 0;
            int n3 = 0;
            while (n3 < iMarkerArray.length) {
                if (TaskViewhelper.isBuildFailedMarker(iMarkerArray[n3])) {
                    n = n3;
                }
                if (iMarkerArray[n3].getAttribute("severity", 0) == 2 && ++n2 > 1) break;
                ++n3;
            }
            if (n2 == 1 && n != -1) {
                ((Workspace)ResourcesPlugin.getWorkspace()).getMarkerManager().removeMarker(iResource, iMarkerArray[n].getId());
            }
        }
        catch (Exception exception) {}
    }

    private static boolean isBuildFailedMarker(IMarker iMarker) {
        try {
            if (iMarker.getType().equals("org.eclipse.cobol.core.problem") && iMarker.getAttribute("severity", 0) == 2 && iMarker.getAttribute("priority", 0) == 2 && iMarker.getAttribute("message").equals(Messages.getString((String)"BuildLogger.BuildFailed"))) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    class ProblemMarker {
        String type = null;
        IResource resource = null;
        String message = null;
        int severity = 0;
        int priority = 0;
        Integer lineNumber = null;
        Integer charStart = null;
        Integer charEnd = null;
        Map attributes = null;

        public ProblemMarker(String string, IResource iResource, String string2, int n, int n2, Integer n3, Integer n4, Integer n5) {
            this.type = string;
            this.resource = iResource;
            this.message = string2;
            this.severity = n;
            this.priority = n2;
            this.lineNumber = n3;
            this.charStart = n4;
            this.charEnd = n5;
        }

        public ProblemMarker(String string, IResource iResource, String string2, int n, int n2, Integer n3, Integer n4, Integer n5, Map map) {
            this.type = string;
            this.resource = iResource;
            this.message = string2;
            this.severity = n;
            this.priority = n2;
            this.lineNumber = n3;
            this.charStart = n4;
            this.charEnd = n5;
            this.attributes = map;
        }

        public String getType() {
            return this.type;
        }

        public Integer getCharEnd() {
            return this.charEnd;
        }

        public Integer getCharStart() {
            return this.charStart;
        }

        public Integer getLineNumber() {
            return this.lineNumber;
        }

        public String getMessage() {
            return this.message;
        }

        public int getPriority() {
            return this.priority;
        }

        public IResource getResource() {
            return this.resource;
        }

        public int getSeverity() {
            return this.severity;
        }

        public Map getAttributes() {
            return this.attributes;
        }
    }
}

