/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build.util;

import java.util.ArrayList;
import org.eclipse.cobol.core.build.ant.AntScriptGenerator;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;

public final class ResourceChangeListener
implements IResourceChangeListener {
    private static ResourceChangeListener fListener = null;
    private static ArrayList fFileExtensions = null;

    private ResourceChangeListener() {
        fFileExtensions = new ArrayList();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace != null) {
            iWorkspace.addResourceChangeListener((IResourceChangeListener)this, 8);
        }
    }

    public static ResourceChangeListener getDefault() {
        if (fListener == null) {
            fListener = new ResourceChangeListener();
        }
        return fListener;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getType() == 8) {
            AntScriptGenerator antScriptGenerator = null;
            IResourceDelta[] iResourceDeltaArray = null;
            ArrayList<IProject> arrayList = new ArrayList<IProject>();
            if (iResourceChangeEvent.getDelta().getResource().getType() == 8) {
                iResourceDeltaArray = iResourceChangeEvent.getDelta().getAffectedChildren();
            }
            if (iResourceDeltaArray == null) {
                return;
            }
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                IProject iProject = (IProject)iResourceDeltaArray[n].getResource();
                if (!(iProject != null && iProject.isAccessible() && iProject.exists() && iProject.isOpen() && CommonBuildUtil.isValidProject(iProject))) {
                    iResourceDeltaArray[n] = null;
                } else if (iResourceDeltaArray[n] != null && (iResourceDeltaArray[n].getKind() == 1 || (iResourceDeltaArray[n].getFlags() & 0x4000) != 0) && !arrayList.contains(iProject) && CommonBuildUtil.isValidProject(iProject)) {
                    arrayList.add(iProject);
                    iResourceDeltaArray[n] = null;
                }
                if (iResourceDeltaArray[n] != null) {
                    this.findResourceDeltaForFile(iResourceDeltaArray[n], arrayList);
                } else if (iProject != null) {
                    IProject[] iProjectArray = iProject.getReferencingProjects();
                    int n2 = 0;
                    while (iProjectArray != null && n2 < iProjectArray.length) {
                        if (iProjectArray[n2] != null && iProjectArray[n2].isAccessible() && !arrayList.contains(iProjectArray[n2]) && CommonBuildUtil.isValidProject(iProjectArray[n2])) {
                            arrayList.add(iProjectArray[n2]);
                        }
                        ++n2;
                    }
                }
                ++n;
            }
            IProject iProject = null;
            int n3 = arrayList.size();
            int n4 = 0;
            while (n4 < n3) {
                iProject = (IProject)arrayList.get(n4);
                if (iProject != null && iProject.isAccessible()) {
                    antScriptGenerator = new AntScriptGenerator(iProject);
                    antScriptGenerator.run();
                }
                ++n4;
            }
        }
    }

    private void findResourceDeltaForFile(IResourceDelta iResourceDelta, ArrayList arrayList) {
        IResourceDelta[] iResourceDeltaArray = iResourceDelta.getAffectedChildren();
        if (iResourceDeltaArray == null || iResourceDeltaArray.length == 0) {
            String string;
            IResource iResource = iResourceDelta.getResource();
            if (arrayList.contains(iResource.getProject())) {
                return;
            }
            if ((iResourceDelta.getKind() == 1 || iResourceDelta.getKind() == 2 || iResourceDelta.getKind() == 262144) && iResource.getType() == 1 && (string = ((IFile)iResource).getFileExtension()) != null) {
                string = string.toLowerCase();
                arrayList.add(iResource.getProject());
            }
        } else {
            int n = 0;
            while (n < iResourceDeltaArray.length) {
                this.findResourceDeltaForFile(iResourceDeltaArray[n], arrayList);
                ++n;
            }
        }
    }

    public static void addFileExtension(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        String string2 = new String(string);
        if (string2.charAt(0) == '.') {
            string2 = string2.substring(1);
        }
        string2 = string2.toLowerCase();
        if (fFileExtensions == null) {
            fFileExtensions = new ArrayList();
            fFileExtensions.add(string2);
            return;
        }
        if (!fFileExtensions.contains(string2)) {
            fFileExtensions.add(string2);
        }
    }
}

