/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build.util;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;

public final class ProjectUtil {
    public static final int FILE = 0;
    public static final int ABSOLUTE_PATH = 1;
    public static final int RELATIVE_PATH = 2;
    private static String fProjectPath = null;
    private static int fProjectPathLength = 0;

    public static Object[] getFilesInProject(IProject iProject, String string, int n) {
        fProjectPath = iProject.getLocation().toOSString();
        fProjectPathLength = fProjectPath.length();
        File file = new File(fProjectPath);
        ArrayList arrayList = new ArrayList();
        ProjectUtil.addFilesInFolder(file, arrayList, string, n);
        switch (n) {
            case 0: {
                Object[] objectArray = new File[arrayList.size()];
                objectArray = arrayList.toArray(objectArray);
                return objectArray;
            }
        }
        Object[] objectArray = new String[arrayList.size()];
        objectArray = arrayList.toArray(objectArray);
        return objectArray;
    }

    private static void addFilesInFolder(File file, ArrayList arrayList, String string, int n) {
        File[] fileArray = null;
        try {
            fileArray = file.listFiles();
        }
        catch (SecurityException securityException) {
            return;
        }
        if (fileArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < fileArray.length) {
            if (fileArray[n2] != null && string != null && string.length() != 0 && fileArray[n2].exists()) {
                if (fileArray[n2].isDirectory()) {
                    ProjectUtil.addFilesInFolder(fileArray[n2], arrayList, string, n);
                } else if (fileArray[n2].getName().endsWith(string)) {
                    switch (n) {
                        case 0: {
                            arrayList.add(fileArray[n2]);
                            break;
                        }
                        case 1: {
                            arrayList.add(fileArray[n2].getAbsolutePath());
                            break;
                        }
                        case 2: {
                            arrayList.add(fileArray[n2].getAbsolutePath().substring(fProjectPathLength + 1));
                            break;
                        }
                    }
                }
            }
            ++n2;
        }
    }

    public static Object[] getFilesInFolder(String string, String string2, int n) {
        File file = new File(string);
        if (!(n != 2 && file.isAbsolute() && file.exists() && file.isDirectory())) {
            return new String[0];
        }
        ArrayList arrayList = new ArrayList();
        ProjectUtil.addFilesInFolder(file, arrayList, string2, n);
        switch (n) {
            case 0: {
                Object[] objectArray = new File[arrayList.size()];
                objectArray = arrayList.toArray(objectArray);
                return objectArray;
            }
        }
        Object[] objectArray = new String[arrayList.size()];
        objectArray = arrayList.toArray(objectArray);
        return objectArray;
    }

    public static File findFileInFolder(String string, String string2) {
        if (string == null || string2 == null || string2.length() == 0) {
            return null;
        }
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        final String string3 = string2;
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.exists() && file.getName().equals(string3);
            }
        };
        FileFilter fileFilter2 = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null || fileArray.length == 0) {
            File[] fileArray2 = file.listFiles(fileFilter2);
            int n = 0;
            while (n < fileArray2.length) {
                File file2 = ProjectUtil.findFileInFolder(fileArray2[n].getAbsolutePath(), string2);
                if (file2 != null) {
                    return file2;
                }
                ++n;
            }
        } else {
            return fileArray[0];
        }
        return null;
    }

    public static boolean addAntClasspathEntry(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = new String(string);
        if (string2 == null || string2.length() == 0) {
            return false;
        }
        Path path = new Path(string2);
        File file = new File(string2);
        if (!file.exists()) {
            return false;
        }
        string2 = path.toString();
        if (file.isDirectory()) {
            stringBuffer.append("/");
            string2 = stringBuffer.toString();
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URL[] uRLArray = AntCorePlugin.getPlugin().getPreferences().getCustomURLs();
        int n = 0;
        while (n < uRLArray.length) {
            arrayList.add(uRLArray[n]);
            ++n;
        }
        try {
            URL uRL = new URL("file", "", string2);
            if (!arrayList.contains(uRL)) {
                arrayList.add(uRL);
                URL[] uRLArray2 = new URL[arrayList.size()];
                int n2 = 0;
                while (n2 < uRLArray2.length) {
                    uRLArray2[n2] = (URL)arrayList.get(n2);
                    ++n2;
                }
                AntCorePlugin.getPlugin().getPreferences().setCustomURLs(uRLArray2);
                AntCorePlugin.getPlugin().getPreferences().updatePluginPreferences();
                return true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            CorePlugin.logError(malformedURLException);
        }
        return false;
    }

    public static void deleteAntClasspathEntry(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        String string2 = new String(string);
        if (string2 == null || string2.length() == 0) {
            return;
        }
        Path path = new Path(string2);
        File file = new File(string2);
        string2 = path.toString();
        if (file.isDirectory() && !string2.endsWith("/")) {
            stringBuffer.append("/");
            string2 = stringBuffer.toString();
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URL[] uRLArray = AntCorePlugin.getPlugin().getPreferences().getCustomURLs();
        int n = 0;
        while (n < uRLArray.length) {
            arrayList.add(uRLArray[n]);
            ++n;
        }
        try {
            URL uRL = new URL("file", "", string2);
            if (arrayList.contains(uRL)) {
                arrayList.remove(uRL);
                URL[] uRLArray2 = new URL[arrayList.size()];
                int n2 = 0;
                while (n2 < uRLArray2.length) {
                    uRLArray2[n2] = (URL)arrayList.get(n2);
                    ++n2;
                }
                AntCorePlugin.getPlugin().getPreferences().setCustomURLs(uRLArray2);
                AntCorePlugin.getPlugin().getPreferences().updatePluginPreferences();
            }
        }
        catch (MalformedURLException malformedURLException) {
            CorePlugin.logError(malformedURLException);
        }
    }
}

