/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build.util;

import com.unisys.os2200.i18nSupport.Messages;
import java.util.HashMap;
import org.eclipse.ant.internal.ui.launchConfigurations.AntProcess;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamMonitor;
import org.eclipse.ant.internal.ui.launchConfigurations.AntStreamsProxy;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.util.COBOLBuildLaunch;
import org.eclipse.cobol.core.build.util.COBOLBuildProcess;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;

public class LogViewHelper {
    private static LogViewHelper logViewHelper = null;
    private static final String BUILD_CANCEL_MSG = "org.eclipse.core.runtime.OperationCanceledException: Build canceled.";
    boolean bErrorMessageDisplayed = false;
    private AntProcess fProcess = null;
    private String fProcessID = "";
    private ILaunch launch = null;

    private LogViewHelper() {
        logViewHelper = this;
    }

    public static LogViewHelper getDefault() {
        if (logViewHelper == null) {
            logViewHelper = new LogViewHelper();
        }
        return logViewHelper;
    }

    public void initConsoleView(String string, int n) {
        ILaunchConfiguration iLaunchConfiguration = LogViewHelper.newConfig("Building " + string, string, n);
        if (iLaunchConfiguration == null) {
            return;
        }
        try {
            if (iLaunchConfiguration instanceof ILaunchConfigurationWorkingCopy) {
                ((ILaunchConfigurationWorkingCopy)iLaunchConfiguration).setAttribute("project", string);
                ((ILaunchConfigurationWorkingCopy)iLaunchConfiguration).setAttribute("buildtype", n);
                ((ILaunchConfigurationWorkingCopy)iLaunchConfiguration).doSave();
            } else {
                iLaunchConfiguration.getAttributes().put("project", string);
                iLaunchConfiguration.getAttributes().put("buildtype", Integer.toString(n));
            }
        }
        catch (CoreException coreException) {
            CorePlugin.logError((Exception)((Object)coreException));
        }
        if (this.launch == null || this.launch != null && this.launch.isTerminated()) {
            this.launch = new COBOLBuildLaunch(iLaunchConfiguration, "run", null);
        }
        if (this.launch.getProcesses().length == 0) {
            long l = System.currentTimeMillis();
            String string2 = Long.toString(l);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(IProcess.ATTR_PROCESS_TYPE, "org.eclipse.ant.ui.antProcess");
            hashMap.put("antprocessid", string2);
            hashMap.put("antlocation", String.valueOf(string) + "/build.xml");
            COBOLBuildProcess cOBOLBuildProcess = new COBOLBuildProcess(CommonBuildUtil.renderProcessLabel(Messages.getString((String)"COBOL_Builder_Process")), this.launch, hashMap);
            DebugPlugin.getDefault().getLaunchManager().addLaunch(this.launch);
            LogViewHelper.getDefault().setAntProcess(cOBOLBuildProcess);
            LogViewHelper.getDefault().setProcessID(string2);
        }
    }

    public void clearConsole() {
        this.getMonitor(0).flushContents();
        this.getMonitor(1).flushContents();
        this.getMonitor(2).flushContents();
        this.getMonitor(3).flushContents();
        this.getMonitor(4).flushContents();
    }

    public void refreshConsoleTree() {
    }

    public void createNewOutputStructureElement(String string) {
    }

    public void finishCurrentOutputStructureElement() {
    }

    public void logMessageInLogConsole(String string, int n, int n2) {
        if (n <= n2 && string != null && string.length() > 0) {
            if (BUILD_CANCEL_MSG.equals(string)) {
                return;
            }
            try {
                if (this.getAntProcess() != null) {
                    this.getMonitor(n).append(String.valueOf(string) + "\n");
                }
                if (!(n != 0 || string.startsWith("[") && string.endsWith("]"))) {
                    this.bErrorMessageDisplayed = true;
                }
            }
            catch (NullPointerException nullPointerException) {
                CorePlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CorePlugin.logError(exception);
            }
        }
    }

    public void flush() {
    }

    public int toConsolePriority(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
        }
        return 2;
    }

    public boolean isErrorMessageDisplayed() {
        return this.bErrorMessageDisplayed;
    }

    public void setErrorMessageDisplayed(boolean bl) {
        this.bErrorMessageDisplayed = bl;
    }

    private AntStreamMonitor getMonitor(int n) {
        AntStreamsProxy antStreamsProxy = (AntStreamsProxy)this.fProcess.getStreamsProxy();
        AntStreamMonitor antStreamMonitor = null;
        switch (n) {
            case 2: {
                antStreamMonitor = (AntStreamMonitor)antStreamsProxy.getOutputStreamMonitor();
                break;
            }
            case 0: {
                antStreamMonitor = (AntStreamMonitor)antStreamsProxy.getErrorStreamMonitor();
                break;
            }
            case 4: {
                antStreamMonitor = antStreamsProxy.getDebugStreamMonitor();
                break;
            }
            case 1: {
                antStreamMonitor = antStreamsProxy.getWarningStreamMonitor();
                break;
            }
            case 3: {
                antStreamMonitor = antStreamsProxy.getVerboseStreamMonitor();
            }
        }
        return antStreamMonitor;
    }

    public void setAntProcess(AntProcess antProcess) {
        this.fProcess = antProcess;
    }

    private AntProcess getAntProcess() {
        if (this.fProcess == null) {
            this.fProcess = this.getAntProcess(this.fProcessID);
        }
        return this.fProcess;
    }

    public void setProcessID(String string) {
        this.fProcessID = string;
    }

    private AntProcess getAntProcess(String string) {
        if (this.fProcess == null && string != null) {
            IProcess[] iProcessArray = DebugPlugin.getDefault().getLaunchManager().getProcesses();
            int n = 0;
            while (n < iProcessArray.length) {
                IProcess iProcess = iProcessArray[n];
                if (iProcess instanceof AntProcess && string.equals(iProcess.getAttribute("antprocessid"))) {
                    this.fProcess = (AntProcess)iProcess;
                    break;
                }
                ++n;
            }
        }
        return this.fProcess;
    }

    public ILaunch getLauncher() {
        return this.launch;
    }

    public void setLauncher(ILaunch iLaunch) {
        this.launch = iLaunch;
    }

    public static ILaunchConfiguration newConfig(String string, String string2, int n) {
        ILaunchManager iLaunchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType iLaunchConfigurationType = iLaunchManager.getLaunchConfigurationType("org.eclipse.cobol.core.build.util.COBOLBuildLaunchDelegate");
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = iLaunchManager.getLaunchConfigurations(iLaunchConfigurationType);
            if (iLaunchConfigurationArray == null || iLaunchConfigurationArray != null && iLaunchConfigurationArray.length == 0) {
                LogViewHelper.createWorkingCopy(iLaunchConfigurationType, string, string2, n);
                return LogViewHelper.newConfig(string, string2, n);
            }
            int n2 = 0;
            while (n2 < iLaunchConfigurationArray.length) {
                if (iLaunchConfigurationArray[n2].getLocation().lastSegment().equalsIgnoreCase(String.valueOf(string) + ".launch")) {
                    return iLaunchConfigurationArray[n2];
                }
                ++n2;
            }
            LogViewHelper.createWorkingCopy(iLaunchConfigurationType, string, string2, n);
            return LogViewHelper.newConfig(string, string2, n);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static void createWorkingCopy(ILaunchConfigurationType iLaunchConfigurationType, String string, String string2, int n) {
        try {
            ILaunchConfigurationWorkingCopy iLaunchConfigurationWorkingCopy = iLaunchConfigurationType.newInstance(null, string);
            iLaunchConfigurationWorkingCopy.setAttribute("project", string2);
            iLaunchConfigurationWorkingCopy.setAttribute("buildtype", n);
            iLaunchConfigurationWorkingCopy.doSave();
        }
        catch (CoreException coreException) {
            CorePlugin.logError((Exception)((Object)coreException));
        }
    }
}

