/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build.util;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import org.apache.regexp.RE;
import org.apache.regexp.REDebugCompiler;
import org.apache.regexp.RESyntaxException;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.ProjectBuildToolsInteraction;
import org.eclipse.cobol.core.build.ant.AntScriptGenerator;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.FileEditorMapping;

public class CommonBuildUtil {
    public static final String JAPANESE_ENCODING_STRING = "SJIS";
    public static final QualifiedName BEANFILE_KEY = new QualifiedName("org.eclipse.cobol.core.build.util.ResourceChangeListener", "isBeanFile");

    public static String[] splitFullName(String string) {
        String[] stringArray = null;
        if (string != null) {
            Path path = new Path(string);
            String string2 = path.toOSString();
            int n = -1;
            try {
                n = string2.lastIndexOf(File.separator);
                stringArray = new String[2];
                if (n > 0) {
                    stringArray[0] = string2.substring(0, n);
                    stringArray[1] = string2.substring(n + 1);
                } else if (n == 0) {
                    stringArray[0] = ".";
                    stringArray[1] = string2.substring(n + 1);
                } else if (n == -1) {
                    stringArray[0] = ".";
                    stringArray[1] = string2;
                }
            }
            catch (NullPointerException nullPointerException) {
                CorePlugin.logError(nullPointerException);
            }
            catch (Exception exception) {
                CorePlugin.logError(exception);
            }
        }
        return stringArray;
    }

    public static String[] splitFullNameForPreCompiler(String string) {
        int n = -1;
        String[] stringArray = null;
        n = -1;
        try {
            if (string != null && string.length() != 0) {
                int n2 = string.lastIndexOf("}");
                int n3 = string.length();
                n = string.lastIndexOf("\\");
                if (n == -1) {
                    n = string.lastIndexOf("/");
                }
                if (n == -1) {
                    while (n3 != -1 && n2 != -1) {
                        n = string.lastIndexOf("\\", n3);
                        if (n == -1) {
                            n = string.lastIndexOf("/", n3);
                        }
                        if (n > n2 && n < n3) break;
                        n = -1;
                        n3 = string.lastIndexOf("${", n2);
                        n2 = string.lastIndexOf("}", n3);
                    }
                    if (n == -1 && (n = string.lastIndexOf("\\", n3)) == -1) {
                        n = string.lastIndexOf("/", n3);
                    }
                }
            }
            stringArray = new String[2];
            if (n > 0) {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + 1);
            } else if (n == 0) {
                stringArray[0] = ".";
                stringArray[1] = string.substring(n + 1);
            } else if (n == -1) {
                stringArray[0] = ".";
                stringArray[1] = string;
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CorePlugin.logError(exception);
        }
        return stringArray;
    }

    public static String processQuote(String string) {
        String string2 = "";
        StringBuffer stringBuffer = null;
        stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        try {
            if (string != null) {
                n2 = string.indexOf("\"", n);
                while (n2 >= 0) {
                    stringBuffer.append(String.valueOf(string.substring(n, n2)) + "&quot;");
                    n = n2 + 1;
                    n2 = string.indexOf("\"", n);
                }
                stringBuffer.append(string.substring(n));
                if (stringBuffer.length() != 0) {
                    string2 = stringBuffer.toString();
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CorePlugin.logError(exception);
        }
        return string2;
    }

    public static boolean isBuildtoolInProject(IProject iProject, String string) {
        IProjectDescription iProjectDescription = null;
        if (string != null) {
            block10: {
                try {
                    if (iProject != null && iProject.isAccessible()) {
                        iProjectDescription = iProject.getDescription();
                        break block10;
                    }
                    return false;
                }
                catch (CoreException coreException) {
                    CorePlugin.logError((Exception)((Object)coreException));
                    return false;
                }
            }
            Map map = null;
            if (iProjectDescription != null) {
                ICommand[] iCommandArray = iProjectDescription.getBuildSpec();
                int n = iCommandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    if (iCommandArray[n2].getBuilderName().equals("org.eclipse.cobol.core.COBOLBuilder")) {
                        map = iCommandArray[n2].getArguments();
                        break;
                    }
                    ++n2;
                }
                if (map != null) {
                    n2 = map.size();
                    String string2 = null;
                    int n3 = 1;
                    while (n3 <= n2) {
                        if (map != null && (string2 = (String)map.get(String.valueOf(n3))) != null && string2.equals(string)) {
                            return true;
                        }
                        ++n3;
                    }
                }
            }
        }
        return false;
    }

    public static void generateAntScriptForAllProjects() {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(null);
        try {
            progressMonitorDialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                    IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    AntScriptGenerator antScriptGenerator = null;
                    IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
                    boolean bl = iWorkspaceDescription.isAutoBuilding();
                    if (bl) {
                        iWorkspaceDescription.setAutoBuilding(false);
                        try {
                            ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
                        }
                        catch (CoreException coreException) {
                            CorePlugin.logError((Exception)((Object)coreException));
                        }
                    }
                    int n = 0;
                    while (n < iProjectArray.length) {
                        if (CommonBuildUtil.isValidProject(iProjectArray[n])) {
                            antScriptGenerator = new AntScriptGenerator(iProjectArray[n]);
                            antScriptGenerator.run();
                        }
                        ++n;
                    }
                    if (bl) {
                        iWorkspaceDescription.setAutoBuilding(true);
                        try {
                            ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
                        }
                        catch (CoreException coreException) {
                            CorePlugin.logError((Exception)((Object)coreException));
                        }
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            CorePlugin.logError(interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            CorePlugin.logError(invocationTargetException);
        }
    }

    public static boolean isValidProject(IProject iProject) {
        try {
            return iProject != null && iProject.isAccessible() && iProject.hasNature("org.eclipse.cobol.core.COBOLNature");
        }
        catch (CoreException coreException) {
            CorePlugin.logError((Exception)((Object)coreException));
            return false;
        }
    }

    public static ArrayList parseMessage(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            REDebugCompiler rEDebugCompiler = new REDebugCompiler();
            RE rE = new RE();
            rE.setProgram(rEDebugCompiler.compile(string));
            boolean bl = rE.match(string2);
            if (bl) {
                int n = rE.getParenCount();
                int n2 = 0;
                while (n2 < n) {
                    arrayList.add(rE.getParen(n2));
                    ++n2;
                }
            }
        }
        catch (RESyntaxException rESyntaxException) {
            CorePlugin.logError((Exception)((Object)rESyntaxException));
        }
        return arrayList;
    }

    public static String getTargetApplicationType(IProject iProject) {
        Map map;
        String string = null;
        ICommand iCommand = null;
        try {
            iCommand = ProjectBuildToolsInteraction.provideBuilderCommand(iProject);
        }
        catch (CoreException coreException) {
            CorePlugin.logError((Exception)((Object)coreException));
        }
        if (iCommand != null && (map = iCommand.getArguments()) != null) {
            string = (String)map.get("originaltargetapplicationtype");
        }
        return string;
    }

    public static ArrayList getBuildTools(IProject iProject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ICommand iCommand = null;
        try {
            if (iProject.isAccessible()) {
                iCommand = ProjectBuildToolsInteraction.provideBuilderCommand(iProject);
            }
        }
        catch (CoreException coreException) {
            CorePlugin.logError((Exception)((Object)coreException));
        }
        if (iCommand != null) {
            Map map = iCommand.getArguments();
            map.remove("originaltargetapplicationtype");
            int n = map.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)map.get(String.valueOf(n2 + 1));
                if (string != null) {
                    arrayList.add(string);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public static String getPathWrtWorkspaceLocationMacro(IProject iProject, String string) {
        String string2 = null;
        String string3 = null;
        if (iProject != null && string != null) {
            IPath iPath;
            IWorkspaceRoot iWorkspaceRoot;
            IWorkspace iWorkspace = iProject.getWorkspace();
            if (iWorkspace != null && (iWorkspaceRoot = iWorkspace.getRoot()) != null && (iPath = iWorkspaceRoot.getLocation()) != null) {
                string2 = iPath.toOSString();
            }
            string3 = string2 != null && string.startsWith(string2) && string.length() > string2.length() ? "${workspace_location}" + File.separator + string.substring(string2.length() + 1) : string;
        }
        return string3;
    }

    public static int getLogConsolePriorityFromMarkerSeverity(int n) {
        switch (n) {
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 2;
    }

    public static String getPathRelativeToProject(IProject iProject, String string) {
        String string2 = null;
        if (iProject != null && string != null) {
            String string3 = null;
            IPath iPath = iProject.getLocation();
            if (iPath != null) {
                string3 = iPath.toOSString();
            }
            string2 = string3 != null && string.startsWith(string3) && string.length() > string3.length() ? string.substring(string3.length() + 1) : string;
        }
        return string2;
    }

    public static String charToCode(String string) {
        if (string != null) {
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] == '&') {
                    stringBuffer.append("&amp;");
                } else if (cArray[n] == '>') {
                    stringBuffer.append("&lt;");
                } else if (cArray[n] == '<') {
                    stringBuffer.append("&gt;");
                } else if (cArray[n] == '\"') {
                    stringBuffer.append("&quot;");
                } else if (cArray[n] == '\'') {
                    stringBuffer.append("&apos;");
                } else {
                    stringBuffer.append(cArray[n]);
                }
                ++n;
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static boolean validateForSpecialCharacters(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        return string.indexOf("/") == -1 && string.indexOf("\\") == -1 && string.indexOf(":") == -1 && string.indexOf(",") == -1 && string.indexOf(";") == -1 && string.indexOf("*") == -1 && string.indexOf("?") == -1 && string.indexOf("\"") == -1 && string.indexOf("<") == -1 && string.indexOf(">") == -1 && string.indexOf("|") == -1;
    }

    public static void setAutoBuildStatus(boolean bl) {
        IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
        iWorkspaceDescription.setAutoBuilding(bl);
        try {
            ResourcesPlugin.getWorkspace().setDescription(iWorkspaceDescription);
        }
        catch (CoreException coreException) {
            CorePlugin.logError((Exception)((Object)coreException));
        }
    }

    public static boolean getAutoBuildStatus() {
        IWorkspaceDescription iWorkspaceDescription = ResourcesPlugin.getWorkspace().getDescription();
        boolean bl = iWorkspaceDescription.isAutoBuilding();
        if (bl) {
            CommonBuildUtil.setAutoBuildStatus(false);
        }
        return iWorkspaceDescription.isAutoBuilding();
    }

    /*
     * Exception decompiling
     */
    public static synchronized String readFromINIFile(String var0, String var1_1, String var2_2) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static synchronized boolean writeToINIFile(String string, String string2, String string3, String string4) throws IOException {
        Object object;
        File file;
        String string5;
        boolean bl;
        block21: {
            String string6 = "";
            String string7 = "";
            bl = false;
            string5 = string4.substring(0, string4.lastIndexOf(File.separator)).concat(File.separator).concat("AA.tmp");
            BufferedWriter bufferedWriter = null;
            BufferedReader bufferedReader = null;
            try {
                try {
                    file = new File(string5);
                    if (file.exists()) {
                        file.delete();
                    }
                    if (!(object = new Path(string4)).toFile().exists()) {
                        object.toFile().createNewFile();
                    }
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string4), JAPANESE_ENCODING_STRING));
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string5), JAPANESE_ENCODING_STRING));
                    if (bufferedReader != null) {
                        string6 = bufferedReader.readLine();
                    }
                    while (string6 != null) {
                        string6 = string6.trim();
                        bufferedWriter.write(string6.concat("\r\n"));
                        if (string6.length() > 0 && string6.charAt(0) == '[' && string6.charAt(string6.length() - 1) == ']') {
                            if (string6.substring(1, string6.length() - 1).equalsIgnoreCase(string)) {
                                while ((string6 = bufferedReader.readLine()) != null) {
                                    if ((string6 = string6.trim()).length() > 0 && string6.trim().charAt(0) == '[') break;
                                    if (string6.length() <= 0 || string6.trim().charAt(0) == '[') continue;
                                    int n = (string6 = string6.trim()).indexOf(61);
                                    if (n > 0) {
                                        string7 = string6.substring(0, n);
                                    }
                                    if (string7.equalsIgnoreCase(string2)) {
                                        string7 = String.valueOf(string7) + "=" + string3;
                                        bufferedWriter.write(string7.concat("\r\n"));
                                        bl = true;
                                        continue;
                                    }
                                    bufferedWriter.write(string6.concat("\r\n"));
                                }
                                if (bl) continue;
                                string7 = String.valueOf(string2) + "=" + string3;
                                bufferedWriter.write(string7.concat("\r\n"));
                                bl = true;
                                continue;
                            }
                            string6 = bufferedReader.readLine();
                            continue;
                        }
                        string6 = bufferedReader.readLine();
                    }
                    if (!bl) {
                        bufferedWriter.write("".concat("\r\n"));
                        bufferedWriter.write("[" + string + "]".concat("\r\n"));
                        string7 = String.valueOf(string2) + "=" + string3;
                        bufferedWriter.write(string7.concat("\r\n"));
                        bufferedWriter.write("".concat("\r\n"));
                    }
                }
                catch (IOException iOException) {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                throw throwable;
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        file = new File(string4);
        object = new File(string5);
        file.delete();
        bl = ((File)object).renameTo(new File(string4));
        return bl;
    }

    public static void updateINIFile(String string, String string2, String string3, Hashtable hashtable) {
        try {
            if (hashtable == null) {
                return;
            }
            Enumeration enumeration = hashtable.keys();
            if (enumeration == null) {
                return;
            }
            CommonBuildUtil.deleteEntriesUnderSection(string, string3);
            String string4 = "" + hashtable.size();
            if (string2 != null && string2.length() > 0) {
                CommonBuildUtil.writeToINIFile(string, string2, string4, string3);
            }
            String string5 = "";
            String string6 = "";
            while (enumeration.hasMoreElements()) {
                string5 = (String)enumeration.nextElement();
                string6 = (String)hashtable.get(string5);
                CommonBuildUtil.writeToINIFile(string, string5, string6, string3);
            }
        }
        catch (IOException iOException) {}
    }

    public static boolean deleteEntriesUnderSection(String string, String string2) throws IOException {
        File file;
        String string3;
        boolean bl;
        block16: {
            bl = false;
            string3 = string2.substring(0, string2.lastIndexOf(File.separator)).concat(File.separator).concat("AA.tmp");
            BufferedReader bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            try {
                try {
                    file = new File(string3);
                    if (file.exists()) {
                        file.delete();
                    }
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), JAPANESE_ENCODING_STRING));
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string3), JAPANESE_ENCODING_STRING));
                    String string4 = bufferedReader.readLine();
                    block4: while (string4 != null) {
                        if ((string4 = string4.trim()).length() > 0 && string4.charAt(0) == '[' && string4.charAt(string4.length() - 1) == ']') {
                            if (string4.substring(1, string4.length() - 1).equalsIgnoreCase(string)) {
                                while ((string4 = bufferedReader.readLine()) != null) {
                                    if ((string4 = string4.trim()).length() > 0 && string4.trim().charAt(0) == '[') continue block4;
                                }
                                continue;
                            }
                            bufferedWriter.write(string4.concat("\r\n"));
                            string4 = bufferedReader.readLine();
                            continue;
                        }
                        bufferedWriter.write(string4.concat("\r\n"));
                        string4 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                throw throwable;
            }
            if (bufferedWriter != null) {
                bufferedWriter.close();
            }
            if (bufferedReader != null) {
                bufferedReader.close();
            }
        }
        file = new File(string2);
        File file2 = new File(string3);
        file.delete();
        bl = file2.renameTo(new File(string2));
        return bl;
    }

    public static ArrayList getCobolEditorFiles() {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        IFileEditorMapping[] iFileEditorMappingArray = WorkbenchPlugin.getDefault().getEditorRegistry().getFileEditorMappings();
        int n = 0;
        while (n < iFileEditorMappingArray.length) {
            FileEditorMapping fileEditorMapping = (FileEditorMapping)iFileEditorMappingArray[n];
            fileEditorMapping = (FileEditorMapping)fileEditorMapping.clone();
            IEditorDescriptor[] iEditorDescriptorArray = fileEditorMapping.getEditors();
            int n2 = 0;
            while (iEditorDescriptorArray != null && n2 < iEditorDescriptorArray.length) {
                if ("org.eclipse.cobol.ui.editor.COBOLEditor".equalsIgnoreCase(iEditorDescriptorArray[n2].getId())) {
                    arrayList.add(fileEditorMapping.getExtension());
                }
                ++n2;
            }
            ++n;
        }
        return arrayList;
    }

    public static boolean isSourceFileSupported(IProject iProject, String string) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = CommonBuildUtil.getCobolEditorFiles();
        ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
        String string2 = null;
        if (iCOBOLContributor != null) {
            string2 = iCOBOLContributor.getBuildToolNameForCompileFileAction();
        }
        Hashtable<String, ArrayList> hashtable = new Hashtable<String, ArrayList>();
        if (iProject != null) {
            arrayList = CommonBuildUtil.getBuildTools(iProject);
        }
        if (string2 != null && string2.length() > 0) {
            hashtable.put(new String(string2), arrayList2);
        }
        if (arrayList != null) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                Object var9_9 = null;
                Object v = hashtable.get(arrayList.get(n2).toString());
                var9_9 = v;
                if (v != null && var9_9 instanceof ArrayList) {
                    ArrayList arrayList3 = var9_9;
                    int n3 = 0;
                    while (n3 < arrayList3.size()) {
                        String string3 = (String)arrayList3.get(n3);
                        if (string.toLowerCase().endsWith(string3)) {
                            return true;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public static String renderProcessLabel(String string) {
        String string2 = Messages.getString((String)"COBOLBuildProcess.{0}_({1})_1");
        String string3 = DateFormat.getDateTimeInstance(1, 2).format(new Date(System.currentTimeMillis()));
        return MessageFormat.format(string2, string, string3);
    }
}

