/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build.ant;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.ICommonConstants;
import org.eclipse.cobol.core.build.CommonBuildOptions;
import org.eclipse.cobol.core.build.ProjectBuildToolsInteraction;
import org.eclipse.cobol.core.build.model.IBuildTool;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.cobol.core.build.util.ant.AntScriptGeneratorHelper;
import org.eclipse.cobol.core.registry.internal.IBuildToolDescriptor;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class AntScriptGenerator {
    private IProject fProject = null;
    private ArrayList falAddedBuildToolIds = null;
    private StringBuffer fsBuildAntScript = null;
    private StringBuffer fsCleanAntScript = null;
    private StringBuffer fsPropertyAntScript = null;
    private StringBuffer fsInitPropertyScript = null;
    private ArrayList falTargetNamesToBuild = null;
    private ArrayList falTargetNamesToReBuild = null;
    private ArrayList falTargetNamesToClean = null;
    private boolean fIsAntScriptCollected = false;

    public AntScriptGenerator(IProject iProject) {
        this.fProject = iProject;
        this.resetBuffers();
    }

    private void resetBuffers() {
        this.fsBuildAntScript = new StringBuffer();
        this.fsCleanAntScript = new StringBuffer();
        this.fsPropertyAntScript = new StringBuffer();
        this.fsInitPropertyScript = new StringBuffer();
        this.falTargetNamesToBuild = new ArrayList();
        this.falTargetNamesToReBuild = new ArrayList();
        this.falTargetNamesToClean = new ArrayList();
        this.falAddedBuildToolIds = new ArrayList();
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block32: {
            block31: {
                block29: {
                    block28: {
                        var1_1 = false;
                        if (!CommonBuildUtil.isValidProject(this.fProject)) break block32;
                        var2_2 = (Workspace)ResourcesPlugin.getWorkspace();
                        var3_3 = new StringBuffer();
                        var2_2.prepareOperation((ISchedulingRule)this.fProject, null);
                        var2_2.beginOperation(false);
                        var4_4 = this.fProject.getFile(CommonBuildOptions.getAntScriptFileName());
                        if (!var4_4.getLocation().toFile().exists()) ** GOTO lbl57
                        if (!var4_4.isReadOnly()) break block28;
                        try {
                            var2_2.endOperation((ISchedulingRule)this.fProject, false, null);
                        }
                        catch (CoreException var10_8) {
                            CorePlugin.logError((Exception)var10_8);
                        }
                        return;
                    }
                    var5_13 = new StringBuffer();
                    if (!var4_4.isSynchronized(0)) {
                        var4_4.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    if (this.fProject.getFile(CommonBuildOptions.getAntScriptFileName()).getLocation().toFile().exists()) break block29;
                    try {
                        var2_2.endOperation((ISchedulingRule)this.fProject, false, null);
                    }
                    catch (CoreException var10_9) {
                        CorePlugin.logError((Exception)var10_9);
                    }
                    return;
                }
                try {
                    try {
                        block30: {
                            var6_14 = this.fProject.getFile(CommonBuildOptions.getAntScriptFileName()).getContents();
                            var7_17 = new BufferedReader(new InputStreamReader((InputStream)var6_14));
                            var8_18 = 0;
                            while ((var8_18 = var7_17.read()) != -1) {
                                var5_13.append((char)var8_18);
                            }
                            this.collectAntScript();
                            this.fIsAntScriptCollected = true;
                            var3_3 = this.arrangeAntScript("UTF-8");
                            var7_17.close();
                            var6_14.close();
                            {
                                catch (CoreException var6_15) {
                                    CorePlugin.logError((Exception)var6_15);
                                    break block30;
                                }
                                catch (IOException var6_16) {
                                    CorePlugin.logError(var6_16);
                                }
                            }
                        }
                        var6_14 = var3_3.toString();
                        var7_17 = var5_13.toString();
                        var1_1 = !var7_17.equals(var6_14);
                        break block31;
lbl57:
                        // 1 sources

                        var1_1 = true;
                    }
                    catch (Exception var4_5) {
                        CorePlugin.logError(var4_5);
                        try {
                            var2_2.endOperation((ISchedulingRule)this.fProject, false, null);
                        }
                        catch (CoreException var10_10) {
                            CorePlugin.logError((Exception)var10_10);
                        }
                    }
                }
                catch (Throwable var9_19) {
                    try {
                        var2_2.endOperation((ISchedulingRule)this.fProject, false, null);
                    }
                    catch (CoreException var10_11) {
                        CorePlugin.logError((Exception)var10_11);
                    }
                    throw var9_19;
                }
            }
            try {
                var2_2.endOperation((ISchedulingRule)this.fProject, false, null);
            }
            catch (CoreException var10_12) {
                CorePlugin.logError((Exception)var10_12);
            }
            try {
                if (!var1_1) break block32;
                try {
                    var2_2.prepareOperation((ISchedulingRule)this.fProject, null);
                    var2_2.beginOperation(false);
                    this.internalRun("UTF-8", var3_3);
                }
                finally {
                    var5_13 = this.fProject.getFile(CommonBuildOptions.getAntScriptFileName());
                    if (!var5_13.isSynchronized(1)) {
                        var5_13.refreshLocal(1, null);
                    }
                    var2_2.endOperation((ISchedulingRule)this.fProject, false, null);
                }
            }
            catch (CoreException var4_7) {
                CorePlugin.logError((Exception)var4_7);
            }
        }
        this.dispose();
    }

    private StringBuffer reformatScript(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer(n);
        int n2 = 0;
        boolean bl = true;
        boolean bl2 = false;
        char c = '\u0000';
        boolean bl3 = false;
        int n3 = 0;
        while (n3 < n) {
            char c2 = stringBuffer.charAt(n3);
            if (bl2) {
                stringBuffer2.append(c2);
            } else if (c2 == '>') {
                if (c != '/' && c != '?' && !bl3) {
                    ++n2;
                }
                bl3 = false;
                stringBuffer2.append(String.valueOf(c2) + ICommonConstants.EOL);
                bl = true;
            } else if (c2 != '<') {
                if (c == '<') {
                    if (c2 == '/') {
                        --n2;
                        bl3 = true;
                    }
                    int n4 = 0;
                    while (n4 < n2) {
                        stringBuffer2.append("    ");
                        ++n4;
                    }
                    stringBuffer2.append(c);
                    stringBuffer2.append(c2);
                    bl = false;
                } else if (bl) {
                    if (c2 != ' ' && c2 != '\n' && c2 != '\r' && c2 != '\t') {
                        stringBuffer2.append(c2);
                    }
                } else if (c != ' ' || c2 != ' ') {
                    stringBuffer2.append(c2);
                }
            }
            if (c2 == '\"') {
                bl2 = !bl2;
            }
            c = c2;
            ++n3;
        }
        return stringBuffer2;
    }

    private void internalRun(String string, StringBuffer stringBuffer) {
        FileOutputStream fileOutputStream = null;
        try {
            if (!this.fIsAntScriptCollected) {
                this.collectAntScript();
                this.fIsAntScriptCollected = true;
                stringBuffer = this.arrangeAntScript(string);
            }
            if (this.fProject == null || this.fProject != null && !this.fProject.exists() || this.fProject != null && !this.fProject.getLocation().toFile().exists()) {
                return;
            }
            fileOutputStream = new FileOutputStream(new File(String.valueOf(this.fProject.getLocation().toOSString()) + '/' + CommonBuildOptions.getAntScriptFileName()));
            fileOutputStream.write(stringBuffer.toString().getBytes(string));
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            CorePlugin.logError(iOException);
        }
    }

    private StringBuffer arrangeAntScript(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(this.provideHeader(string)) + System.getProperty("line.separator"));
        stringBuffer.append(String.valueOf(this.provideInitPropertyScript()) + System.getProperty("line.separator"));
        stringBuffer.append(String.valueOf(this.fsPropertyAntScript.toString()) + System.getProperty("line.separator"));
        stringBuffer.append(String.valueOf(this.fsBuildAntScript.toString()) + System.getProperty("line.separator"));
        stringBuffer.append(String.valueOf(this.fsCleanAntScript.toString()) + System.getProperty("line.separator"));
        stringBuffer.append(String.valueOf(this.provideIncrementalBuildInvoker()) + System.getProperty("line.separator"));
        stringBuffer.append(String.valueOf(this.provideCleanInvoker()) + System.getProperty("line.separator"));
        stringBuffer.append(String.valueOf(AntScriptGenerator.provideFooter()) + System.getProperty("line.separator"));
        stringBuffer = this.reformatScript(stringBuffer);
        return stringBuffer;
    }

    private void collectAntScript() {
        this.resetBuffers();
        ArrayList arrayList = ProjectBuildToolsInteraction.getBuildDescriptors(this.fProject);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            IBuildToolDescriptor iBuildToolDescriptor = (IBuildToolDescriptor)arrayList.get(n2);
            String string = iBuildToolDescriptor.getId();
            String string2 = string.replaceFirst("_buildtool", "");
            IBuildTool iBuildTool = null;
            try {
                iBuildTool = iBuildToolDescriptor.createBuildTool();
                if (iBuildTool == null) {
                    return;
                }
                iBuildTool.setProject(this.fProject);
            }
            catch (CoreException coreException) {
                CorePlugin.logError((Exception)((Object)coreException));
            }
            String string3 = null;
            String string4 = null;
            String string5 = null;
            String string6 = null;
            if (!this.falAddedBuildToolIds.contains(string)) {
                this.falAddedBuildToolIds.add(string);
                string3 = iBuildTool.getBuildAntScript(String.valueOf(string2) + "-");
                string4 = iBuildTool.getCleanAntScript(String.valueOf(string2) + "-");
                string5 = iBuildTool.getPropertyAntScript(String.valueOf(string2) + "-");
                string6 = iBuildTool.getInitProperties(String.valueOf(string2) + "-");
            }
            String string7 = iBuildTool.getTargetNameToBuild(String.valueOf(string2) + "-");
            String string8 = iBuildTool.getTargetNameToReBuild(String.valueOf(string2) + "-");
            String string9 = iBuildTool.getTargetNameToClean(String.valueOf(string2) + "-");
            if (string3 != null && string3.length() != 0) {
                this.fsBuildAntScript.append(string3);
                this.fsBuildAntScript.append(ICommonConstants.EOL);
            }
            if (string4 != null && string4.length() != 0) {
                this.fsCleanAntScript.append(string4);
                this.fsCleanAntScript.append(ICommonConstants.EOL);
            }
            if (string5 != null && string5.length() != 0) {
                this.fsPropertyAntScript.append(string5);
                this.fsPropertyAntScript.append(ICommonConstants.EOL);
            }
            if (string6 != null && string6.length() != 0) {
                this.fsInitPropertyScript.append(string6);
                this.fsInitPropertyScript.append(ICommonConstants.EOL);
            }
            if (string7 != null && string7.length() != 0) {
                this.falTargetNamesToBuild.add(string7);
            }
            if (string8 != null && string8.length() != 0) {
                this.falTargetNamesToReBuild.add(string8);
            }
            if (string9 != null && string9.length() != 0) {
                this.falTargetNamesToClean.add(string9);
            }
            ++n2;
        }
    }

    private String provideHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string;
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>");
        stringBuffer.append(ICommonConstants.EOL);
        stringBuffer.append(AntScriptGeneratorHelper.generateProjectDeclaration(CommonBuildUtil.charToCode(this.fProject.getName()), "incremental_build", "."));
        stringBuffer.append(ICommonConstants.EOL);
        stringBuffer.append("    <property name=\"foe\" value=\"true\"/>");
        String string3 = "";
        String string4 = "";
        try {
            string3 = this.fProject.getWorkspace().getRoot().getLocation().toOSString();
            string4 = this.fProject.getLocation().toOSString();
        }
        catch (Exception exception) {
            CorePlugin.logError(exception);
        }
        stringBuffer.append(ICommonConstants.EOL);
        stringBuffer.append("    <property name=\"workspace_location\" value=\"" + CommonBuildUtil.charToCode(string3) + "\"/>");
        stringBuffer.append(ICommonConstants.EOL);
        stringBuffer.append("    <property name=\"project_location\" value=\"" + CommonBuildUtil.charToCode(string4) + "\"/>");
        return stringBuffer.toString();
    }

    private static String provideFooter() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(AntScriptGeneratorHelper.generateProjectDeclarationEnd());
        return stringBuffer.toString();
    }

    private String provideIncrementalBuildInvoker() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t<target name=\"incremental_build\"");
        int n = this.falTargetNamesToBuild.size();
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + (String)this.falTargetNamesToBuild.get(n2);
            if (n2 < n - 1) {
                string = String.valueOf(string) + ",";
            }
            ++n2;
        }
        stringBuffer.append(" depends=\"" + string + "\" />");
        return stringBuffer.toString();
    }

    private String provideCleanInvoker() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t<target name=\"clean_build\"");
        int n = this.falTargetNamesToClean.size();
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + (String)this.falTargetNamesToClean.get(n2);
            if (n2 < n - 1) {
                string = String.valueOf(string) + ",";
            }
            ++n2;
        }
        stringBuffer.append(" depends=\"" + string + "\" />");
        return stringBuffer.toString();
    }

    private String provideInitPropertyScript() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ICommonConstants.EOL);
        stringBuffer.append("  <target name=\"");
        stringBuffer.append("init");
        stringBuffer.append("\" >");
        stringBuffer.append(ICommonConstants.EOL);
        stringBuffer.append(this.fsInitPropertyScript.toString());
        stringBuffer.append(" </target>");
        stringBuffer.append(ICommonConstants.EOL);
        return stringBuffer.toString();
    }

    public void dispose() {
        if (this.falAddedBuildToolIds != null) {
            this.falAddedBuildToolIds.clear();
            this.falAddedBuildToolIds = null;
        }
        if (this.falTargetNamesToBuild != null) {
            this.falTargetNamesToBuild.clear();
            this.falTargetNamesToBuild = null;
        }
        if (this.falTargetNamesToClean != null) {
            this.falTargetNamesToClean.clear();
            this.falTargetNamesToClean = null;
        }
        if (this.falTargetNamesToReBuild != null) {
            this.falTargetNamesToReBuild.clear();
            this.falTargetNamesToReBuild = null;
        }
        if (this.fProject != null) {
            this.fProject = null;
        }
        if (this.fsBuildAntScript != null) {
            this.fsBuildAntScript = null;
        }
        if (this.fsCleanAntScript != null) {
            this.fsCleanAntScript = null;
        }
        if (this.fsInitPropertyScript != null) {
            this.fsInitPropertyScript = null;
        }
        if (this.fsPropertyAntScript != null) {
            this.fsPropertyAntScript = null;
        }
        if (this.fsPropertyAntScript != null) {
            this.fsPropertyAntScript = null;
        }
    }
}

