/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.BuildController;
import org.eclipse.cobol.core.build.action.BuildMenubarActionsDelegate;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class CleanProjectContextMenuAction
implements IViewActionDelegate,
IResourceChangeListener {
    private static IAction fCleanContextMenuAction = null;
    private ArrayList fSelectedProjects = null;
    private IViewPart fActivePart = null;
    Object[] fSelectedItems = null;
    private static int fiResourceNumber = 0;

    public CleanProjectContextMenuAction() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        CorePlugin.getDefault();
    }

    private void initializeLists() {
        if (this.fSelectedProjects == null) {
            this.fSelectedProjects = new ArrayList();
        }
    }

    public void init(IViewPart iViewPart) {
        this.initializeLists();
    }

    public void run(IAction iAction) {
        this.initializeLists();
        if (fCleanContextMenuAction == null) {
            fCleanContextMenuAction = iAction;
        }
        this.refreshAction();
        if (fCleanContextMenuAction.isEnabled()) {
            try {
                fiResourceNumber = 0;
                IRunnableWithProgress iRunnableWithProgress = null;
                iRunnableWithProgress = new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        IProject[] iProjectArray = new IProject[CleanProjectContextMenuAction.this.fSelectedProjects.size()];
                        iProjectArray = CleanProjectContextMenuAction.this.fSelectedProjects.toArray(iProjectArray);
                        int n = 0;
                        while (n < iProjectArray.length) {
                            if (iProjectArray[n] != null) {
                                fiResourceNumber = fiResourceNumber + 1;
                                BuildController buildController = new BuildController(iProjectArray[n], iProgressMonitor);
                                buildController.clean();
                                try {
                                    iProjectArray[n].refreshLocal(0, iProgressMonitor);
                                }
                                catch (CoreException coreException) {
                                    CorePlugin.logError((Exception)((Object)coreException));
                                }
                            }
                            ++n;
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(null).run(true, true, iRunnableWithProgress);
                }
                catch (InvocationTargetException invocationTargetException) {
                    CorePlugin.logError(invocationTargetException);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                fiResourceNumber = 0;
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        this.initializeLists();
        if (fCleanContextMenuAction == null) {
            fCleanContextMenuAction = iAction;
        }
        if (this.fSelectedProjects == null) {
            this.fSelectedProjects = new ArrayList();
        }
        this.refreshAction();
    }

    private void refreshAction() {
        try {
            IWorkbenchWindow iWorkbenchWindow = WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPart iWorkbenchPart = iWorkbenchWindow.getPartService().getActivePart();
            this.fSelectedProjects.clear();
            if (iWorkbenchPart instanceof IViewPart) {
                this.fActivePart = (IViewPart)iWorkbenchPart;
                ISelection iSelection = iWorkbenchWindow.getSelectionService().getSelection();
                if (iSelection == null || !(iSelection instanceof IStructuredSelection)) {
                    if (fCleanContextMenuAction != null) {
                        fCleanContextMenuAction.setEnabled(false);
                    }
                    return;
                }
                Object[] objectArray = ((IStructuredSelection)iSelection).toArray();
                this.fSelectedItems = objectArray;
                if (iWorkbenchPart instanceof ResourceNavigator) {
                    int n = 0;
                    while (n < objectArray.length) {
                        IProject iProject = ((IResource)objectArray[n]).getProject();
                        if (CommonBuildUtil.isValidProject(iProject) && !this.fSelectedProjects.contains(iProject)) {
                            this.fSelectedProjects.add(iProject);
                        }
                        ++n;
                    }
                }
                if (this.fSelectedProjects.size() == 0) {
                    fCleanContextMenuAction.setEnabled(false);
                } else {
                    fCleanContextMenuAction.setEnabled(true);
                }
                return;
            }
            fCleanContextMenuAction.setEnabled(false);
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CorePlugin.logError(exception);
        }
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        try {
            if (this.fActivePart != null && this.fActivePart instanceof ResourceNavigator) {
                if (this.fSelectedItems != null) {
                    int n = 0;
                    while (this.fSelectedItems != null && n < this.fSelectedItems.length) {
                        IProject iProject;
                        if (this.fSelectedItems[n] != null && this.fSelectedItems[n] instanceof IResource && CommonBuildUtil.isValidProject(iProject = ((IResource)this.fSelectedItems[n]).getProject())) {
                            fCleanContextMenuAction.setEnabled(true);
                            BuildMenubarActionsDelegate.enableCleanAction(true);
                            return;
                        }
                        ++n;
                    }
                }
                fCleanContextMenuAction.setEnabled(false);
                BuildMenubarActionsDelegate.enableCleanAction(false);
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError(nullPointerException);
        }
        catch (Exception exception) {
            CorePlugin.logError(exception);
        }
        fCleanContextMenuAction.setEnabled(false);
    }

    public static void enableCleanAction(boolean bl) {
        if (fCleanContextMenuAction != null) {
            fCleanContextMenuAction.setEnabled(bl);
        }
    }

    public static int getResourceNumber() {
        return fiResourceNumber;
    }
}

