/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.BuildController;
import org.eclipse.cobol.core.build.util.CommonBuildUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.views.navigator.ResourceNavigator;

public class BuildMenubarActionsDelegate
implements IWorkbenchWindowActionDelegate {
    private static IAction fCleanAction = null;
    private ArrayList fSelectedProjects = null;
    private static int fiResourceNumber = 0;

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.fSelectedProjects = new ArrayList();
    }

    public void run(IAction iAction) {
        if (fCleanAction == null) {
            fCleanAction = iAction;
        }
        this.refreshAction();
        if (fCleanAction.isEnabled()) {
            try {
                fiResourceNumber = 0;
                IRunnableWithProgress iRunnableWithProgress = null;
                iRunnableWithProgress = new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) {
                        IProject[] iProjectArray = new IProject[BuildMenubarActionsDelegate.this.fSelectedProjects.size()];
                        iProjectArray = BuildMenubarActionsDelegate.this.fSelectedProjects.toArray(iProjectArray);
                        int n = 0;
                        while (n < iProjectArray.length) {
                            if (iProjectArray[n] != null) {
                                fiResourceNumber = fiResourceNumber + 1;
                                BuildController buildController = new BuildController(iProjectArray[n], iProgressMonitor);
                                buildController.clean();
                                try {
                                    iProjectArray[n].refreshLocal(0, iProgressMonitor);
                                }
                                catch (CoreException coreException) {
                                    CorePlugin.logError((Exception)((Object)coreException));
                                }
                            }
                            ++n;
                        }
                    }
                };
                try {
                    new ProgressMonitorDialog(null).run(true, true, iRunnableWithProgress);
                }
                catch (InvocationTargetException invocationTargetException) {
                    CorePlugin.logError(invocationTargetException);
                }
                catch (InterruptedException interruptedException) {}
            }
            finally {
                fiResourceNumber = 0;
            }
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        if (fCleanAction == null) {
            fCleanAction = iAction;
        }
        this.refreshAction();
    }

    public static void enableCleanAction(boolean bl) {
        if (fCleanAction != null) {
            fCleanAction.setEnabled(bl);
        }
    }

    private void refreshAction() {
        IWorkbenchPart iWorkbenchPart = WorkbenchPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
        this.fSelectedProjects.clear();
        if (iWorkbenchPart instanceof IViewPart) {
            Object[] objectArray;
            ISelection iSelection = CorePlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
            if (iSelection == null) {
                if (fCleanAction != null) {
                    fCleanAction.setEnabled(false);
                }
                return;
            }
            try {
                objectArray = ((IStructuredSelection)iSelection).toArray();
            }
            catch (ClassCastException classCastException) {
                if (fCleanAction != null) {
                    fCleanAction.setEnabled(false);
                }
                return;
            }
            if (objectArray == null && fCleanAction != null) {
                fCleanAction.setEnabled(false);
                return;
            }
            if (iWorkbenchPart instanceof ResourceNavigator) {
                int n = 0;
                while (n < objectArray.length) {
                    IProject iProject;
                    if (objectArray[n] instanceof IResource && CommonBuildUtil.isValidProject(iProject = ((IResource)objectArray[n]).getProject()) && !this.fSelectedProjects.contains(iProject)) {
                        this.fSelectedProjects.add(iProject);
                    }
                    ++n;
                }
            } else if (objectArray != null && objectArray.length > 0) {
                int n = 0;
                while (n < objectArray.length) {
                    IProject iProject;
                    Object object;
                    if (objectArray[n] instanceof IAdaptable && (object = ((IAdaptable)objectArray[n]).getAdapter(IProject.class)) != null && object instanceof IProject && CommonBuildUtil.isValidProject(iProject = (IProject)object) && !this.fSelectedProjects.contains(iProject)) {
                        this.fSelectedProjects.add(iProject);
                    }
                    ++n;
                }
            }
            if (this.fSelectedProjects.size() == 0) {
                fCleanAction.setEnabled(false);
            } else {
                fCleanAction.setEnabled(true);
            }
            return;
        }
        fCleanAction.setEnabled(false);
    }

    public static int getResourceNumber() {
        return fiResourceNumber;
    }
}

