/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.internal.core.IAntCoreConstants;
import org.eclipse.ant.internal.core.InternalCoreAntMessages;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ClassLoaderUtil
implements IAntCoreConstants {
    protected List defaultURLs;
    protected URL[] customURLs;
    protected List pluginClassLoaders;
    public static final String PT_EXTRA_CLASSPATH = "extraClasspathEntries";
    public static final String LIBRARY = "library";

    public ClassLoaderUtil() {
        this.initializePluginClassLoaders();
        this.defaultURLs = new ArrayList(20);
        Map map = this.extractExtensions();
        this.computeDefaultExtraClasspathEntries(map);
        this.restoreCustomObjects();
    }

    protected void restoreCustomObjects() {
        this.customURLs = this.getDefaultCustomURLs();
    }

    public URL[] getDefaultCustomURLs() {
        ArrayList arrayList = new ArrayList(10);
        IPluginDescriptor iPluginDescriptor = Platform.getPlugin((String)"org.apache.ant").getDescriptor();
        this.addLibraries(iPluginDescriptor, arrayList);
        this.addToolsJar(arrayList);
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    protected void computeDefaultExtraClasspathEntries(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            IConfigurationElement iConfigurationElement = (IConfigurationElement)entry.getValue();
            IPluginDescriptor iPluginDescriptor = iConfigurationElement.getDeclaringExtension().getDeclaringPluginDescriptor();
            try {
                URL uRL = Platform.asLocalURL((URL)new URL(iPluginDescriptor.getInstallURL(), string));
                this.defaultURLs.add(uRL);
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.AntCorePreferences_Malformed_URL__1, (Throwable)exception);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
                continue;
            }
            this.addPluginClassLoader(iPluginDescriptor.getPluginClassLoader());
        }
    }

    protected void addToolsJar(List list) {
        File file;
        Path path = new Path(System.getProperty("java.home"));
        if (path.lastSegment().equalsIgnoreCase("jre")) {
            path = path.removeLastSegments(1);
        }
        if (!(file = (path = path.append("lib").append("tools.jar")).toFile()).exists()) {
            return;
        }
        try {
            list.add(new URL("file:" + file.getAbsolutePath()));
            if (InternalPlatform.DEBUG) {
                System.out.println("tools.jar location :" + file.getAbsolutePath());
            }
        }
        catch (MalformedURLException malformedURLException) {
            Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.AntCorePreferences_Malformed_URL__1, (Throwable)malformedURLException);
            AntCorePlugin.getPlugin().getLog().log((IStatus)status);
        }
    }

    protected void addLibraries(IPluginDescriptor iPluginDescriptor, List list) {
        URL uRL = iPluginDescriptor.getInstallURL();
        ILibrary[] iLibraryArray = iPluginDescriptor.getRuntimeLibraries();
        int n = 0;
        while (n < iLibraryArray.length) {
            try {
                URL uRL2 = new URL(uRL, iLibraryArray[n].getPath().toString());
                list.add(Platform.asLocalURL((URL)uRL2));
                if (InternalPlatform.DEBUG) {
                    System.out.println("Library relative location :" + uRL2.toString());
                }
            }
            catch (Exception exception) {
                Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.AntCorePreferences_Malformed_URL__1, (Throwable)exception);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            ++n;
        }
    }

    protected void addPluginClassLoader(ClassLoader classLoader) {
        if (!this.pluginClassLoaders.contains(classLoader)) {
            this.pluginClassLoaders.add(classLoader);
        }
    }

    public URL[] getURLs() {
        ArrayList<URL> arrayList = new ArrayList<URL>(10);
        if (this.defaultURLs != null) {
            arrayList.addAll(this.defaultURLs);
        }
        if (this.customURLs != null) {
            arrayList.addAll(Arrays.asList(this.customURLs));
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public ClassLoader[] getPluginClassLoaders() {
        return this.pluginClassLoaders.toArray(new ClassLoader[this.pluginClassLoaders.size()]);
    }

    protected void initializePluginClassLoaders() {
        this.pluginClassLoaders = new ArrayList(20);
        this.pluginClassLoaders.add(Platform.getPlugin((String)"org.eclipse.ant.core").getDescriptor().getPluginClassLoader());
    }

    public URL[] getCustomURLs() {
        return this.customURLs;
    }

    public void setCustomURLs(URL[] uRLArray) {
        this.customURLs = uRLArray;
    }

    public static String[] getArrayFromString(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.equals("")) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] getArrayFromString(String string) {
        return ClassLoaderUtil.getArrayFromString(string, ",");
    }

    private Map extractExtensions() {
        String string = PT_EXTRA_CLASSPATH;
        String string2 = LIBRARY;
        IExtensionPoint iExtensionPoint = AntCorePlugin.getPlugin().getDescriptor().getExtensionPoint(string);
        if (iExtensionPoint == null) {
            return null;
        }
        IConfigurationElement[] iConfigurationElementArray = iExtensionPoint.getConfigurationElements();
        HashMap<String, IConfigurationElement> hashMap = new HashMap<String, IConfigurationElement>(iConfigurationElementArray.length);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            String string3 = iConfigurationElementArray[n].getAttribute(string2);
            hashMap.put(string3, iConfigurationElementArray[n]);
            ++n;
        }
        return hashMap;
    }
}

