/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build;

import java.util.Map;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.BuildController;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class BuildHandler
extends IncrementalProjectBuilder {
    private IProject fCurrentProject = null;
    private static boolean bPreRequisiteBuildJustStarted = false;
    private static boolean bPreRequisiteBuildPathRunning = false;
    private static boolean bBuildRunning = false;

    protected IProject[] build(int n, Map map, IProgressMonitor iProgressMonitor) throws CoreException {
        this.fCurrentProject = this.getProject();
        if (iProgressMonitor != null) {
            bBuildRunning = true;
            try {
                if (n == 6 || n == 10) {
                    CorePlugin.getDefault().setAutoBuildRunning(false);
                    this.invokeBuild(this.fCurrentProject, n, iProgressMonitor);
                } else if (n == 9) {
                    CorePlugin.getDefault().setAutoBuildRunning(true);
                    this.invokeBuild(this.fCurrentProject, n, iProgressMonitor);
                    CorePlugin.getDefault().setAutoBuildRunning(false);
                }
            }
            finally {
                bPreRequisiteBuildPathRunning = false;
                bBuildRunning = false;
            }
        }
        IProject[] iProjectArray = this.getRequiredProjects();
        return iProjectArray;
    }

    private IProject[] getRequiredProjects() {
        try {
            return this.fCurrentProject.getReferencedProjects();
        }
        catch (CoreException coreException) {
            return new IProject[0];
        }
    }

    private void invokeBuild(IProject iProject, int n, IProgressMonitor iProgressMonitor) throws CoreException {
        BuildController buildController = new BuildController(iProject, iProgressMonitor);
        if (n == 6) {
            buildController.reBuild();
        } else if (n == 10) {
            buildController.incrementalBuild();
        } else if (n == 9) {
            buildController.incrementalBuild();
        }
    }

    public static boolean isPreRequisiteBuildJustStarted() {
        return bPreRequisiteBuildJustStarted;
    }

    public static void setPreRequisiteBuildJustStarted(boolean bl) {
        bPreRequisiteBuildJustStarted = bl;
    }

    public static boolean isPreRequisiteBuildPathRunning() {
        return bPreRequisiteBuildPathRunning;
    }

    public static void setPreRequisiteBuildPathRunning(boolean bl) {
        bPreRequisiteBuildPathRunning = bl;
    }

    public static boolean isBuildRunning() {
        return bBuildRunning;
    }
}

