/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core.build;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.build.BuildHandler;
import org.eclipse.cobol.core.build.CommonBuildOptions;
import org.eclipse.cobol.core.build.IAntRunner;
import org.eclipse.cobol.core.build.action.BuildMenubarActionsDelegate;
import org.eclipse.cobol.core.build.action.CleanProjectContextMenuAction;
import org.eclipse.cobol.core.build.action.CompileFileAction;
import org.eclipse.cobol.core.build.ant.AntScriptGenerator;
import org.eclipse.cobol.core.build.util.LogViewHelper;
import org.eclipse.cobol.core.build.util.TaskViewhelper;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class BuildController {
    private IProject fProject = null;
    private IProgressMonitor fMonitor = null;
    private String BUILD_LOGGER = "org.eclipse.cobol.build.ant.CobolBuildLogger";
    private StringBuffer fsArguments = null;
    private static final String FAIL_ON_ERROR = "-Dfoe=false";
    private LogViewHelper logView = LogViewHelper.getDefault();
    private int kind = 0;

    public BuildController(IProject iProject, IProgressMonitor iProgressMonitor) {
        this.fProject = iProject;
        this.fMonitor = iProgressMonitor;
        this.fsArguments = new StringBuffer();
        if (!CommonBuildOptions.isBuildStoppedOnError()) {
            this.fsArguments.append(FAIL_ON_ERROR);
        }
        String string = "";
        String string2 = "";
        try {
            string = this.fProject.getWorkspace().getRoot().getLocation().toOSString();
            string2 = this.fProject.getLocation().toOSString();
        }
        catch (Exception exception) {
            CorePlugin.logError(exception);
        }
        this.fsArguments.append(" ");
        this.fsArguments.append("-Dproject_location=\"" + string2 + "\"");
        this.fsArguments.append(" ");
        this.fsArguments.append("-Dworkspace_location=\"" + string + "\"");
        this.fsArguments.append(" ");
    }

    public void incrementalBuild() throws CoreException {
        this.kind = 10;
        String[] stringArray = new String[]{"incremental_build"};
        this.buildExecuter(stringArray);
    }

    public void reBuild() throws CoreException {
        this.kind = 6;
        String[] stringArray = new String[]{"clean_build", "incremental_build"};
        this.buildExecuter(stringArray);
    }

    public void clean() {
        try {
            String[] stringArray = new String[]{"clean_build"};
            this.buildExecuter(stringArray);
        }
        catch (CoreException coreException) {}
    }

    public void compileCobolSourceFile(IFile iFile) {
        String string = null;
        if (iFile != null && iFile.exists()) {
            string = iFile.getLocation().toOSString();
        }
        try {
            String[] stringArray;
            ICOBOLContributor iCOBOLContributor = CorePlugin.getDefault().getDefaultCOBOLContributor();
            String string2 = null;
            if (iCOBOLContributor != null) {
                string2 = iCOBOLContributor.getBuildToolNameForCompileFileAction();
            }
            String string3 = "";
            if (string2 != null) {
                stringArray = string2.replaceFirst("_buildtool", "");
                string3 = String.valueOf(stringArray) + "-" + "FileCompile";
            }
            stringArray = new String[]{string3};
            this.fsArguments.append(" ");
            QualifiedName qualifiedName = null;
            String string4 = "";
            try {
                qualifiedName = new QualifiedName("org.eclipse.cobol.ui.views.dependency", "MAIN_FILE");
                string4 = this.fProject.getPersistentProperty(qualifiedName);
            }
            catch (CoreException coreException) {
                CorePlugin.logError((Exception)((Object)coreException));
            }
            if (string4 != null && string4.length() > 0) {
                if (string4.indexOf("/") > -1) {
                    string4 = string4.substring(string4.lastIndexOf("/") + 1, string4.length());
                }
            } else {
                string4 = "";
            }
            if (string4.equals(string.substring(string.lastIndexOf(File.separator) + 1, string.length()))) {
                this.fsArguments.append("-Dcobol-MainFileOption=\"-M\"");
            } else {
                this.fsArguments.append("-Dcobol-MainFileOption=\" \"");
            }
            this.fsArguments.append("-Dcobol-SourceFile=\"" + string + "\"");
            this.buildExecuter(stringArray);
        }
        catch (CoreException coreException) {}
    }

    public void buildExecuter(String[] stringArray) throws CoreException {
        block10: {
            TaskViewhelper.removeAllProblemMarkers((IResource)this.fProject);
            if (LogViewHelper.getDefault().getLauncher() == null || LogViewHelper.getDefault().getLauncher() != null && LogViewHelper.getDefault().getLauncher().isTerminated()) {
                LogViewHelper.getDefault().initConsoleView(this.fProject.getName(), this.kind);
            }
            try {
                if (BuildHandler.isBuildRunning()) {
                    this.internalbuildExecuter(stringArray);
                    break block10;
                }
                Workspace workspace = (Workspace)ResourcesPlugin.getWorkspace();
                try {
                    try {
                        workspace.prepareOperation((ISchedulingRule)this.fProject, this.fMonitor);
                        workspace.beginOperation(true);
                        this.internalbuildExecuter(stringArray);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        workspace.getWorkManager().operationCanceled();
                        throw operationCanceledException;
                    }
                }
                finally {
                    workspace.endOperation((ISchedulingRule)this.fProject, false, this.fMonitor);
                }
            }
            finally {
                LogViewHelper.getDefault().getLauncher().getProcesses()[0].terminate();
                LogViewHelper.getDefault().getLauncher().terminate();
                TaskViewhelper.getDefault().flush();
            }
        }
    }

    private void internalbuildExecuter(String[] stringArray) throws OperationCanceledException {
        boolean bl = false;
        try {
            try {
                Object object;
                String string = null;
                this.fProject.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                bl = BuildController.isConsoleToBeCleared();
                if (bl && this.logView != null) {
                    this.logView.clearConsole();
                }
                this.printBuildStartMessage();
                if (BuildHandler.isBuildRunning()) {
                    this.fMonitor.subTask(Messages.getString((String)"BuildController.PreparingForBuildMsg"));
                } else {
                    this.fMonitor.subTask(Messages.getString((String)"BuildController.PreparingForOperationMsg"));
                }
                if (BuildHandler.isBuildRunning()) {
                    this.fMonitor.subTask(Messages.getString((String)"BuildController.BuildStartedMsg"));
                } else {
                    this.fMonitor.subTask(Messages.getString((String)"BuildController.OperationStartedMsg"));
                }
                IFile iFile = this.fProject.getFile(CommonBuildOptions.getAntScriptFileName());
                if (!iFile.exists()) {
                    object = new AntScriptGenerator(this.fProject);
                    ((AntScriptGenerator)object).run();
                }
                string = String.valueOf(this.fProject.getLocation().toOSString()) + '/' + CommonBuildOptions.getAntScriptFileName();
                object = IAntRunner.getDefault();
                ((IAntRunner)((Object)object)).init();
                object.addBuildLogger(this.BUILD_LOGGER);
                CorePlugin.getDefault().setProgressMonitor(this.fMonitor);
                CorePlugin.getDefault().setCurrentProject(this.fProject);
                object.setBuildFileLocation(string);
                object.setArguments(this.fsArguments.toString());
                if (stringArray != null) {
                    object.setExecutionTargets(stringArray);
                }
                ((IAntRunner)((Object)object)).run(this.fMonitor);
            }
            catch (CoreException coreException) {
                boolean bl2;
                if (CommonBuildOptions.isBuildStoppedOnError() && !(bl2 = CorePlugin.getDefault().isAutoBuildRunning())) {
                    throw new OperationCanceledException();
                }
                try {
                    this.fProject.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                    this.printBuildEndMessage();
                    this.fMonitor.subTask(Messages.getString((String)"BuildController.Refreshing_message"));
                }
                catch (CoreException coreException2) {
                    CorePlugin.logError((Exception)((Object)coreException2));
                }
            }
        }
        finally {
            try {
                this.fProject.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
                this.printBuildEndMessage();
                this.fMonitor.subTask(Messages.getString((String)"BuildController.Refreshing_message"));
            }
            catch (CoreException coreException) {
                CorePlugin.logError((Exception)((Object)coreException));
            }
        }
    }

    public void printBuildStartMessage() {
        if (this.logView != null) {
            this.logView.createNewOutputStructureElement(this.fProject.getName());
            String string = this.getDateFormat();
            if (BuildHandler.isBuildRunning()) {
                this.logView.logMessageInLogConsole(Messages.getFormattedString((String)"BuildLogger.Build_started_at_3", (Object)new String[]{this.fProject.getName(), string}), 2, 2);
            } else {
                this.logView.logMessageInLogConsole(string, 2, 2);
            }
            this.logView.flush();
        }
    }

    public static boolean isConsoleToBeCleared() {
        boolean bl = false;
        if (!BuildHandler.isBuildRunning()) {
            int n = BuildMenubarActionsDelegate.getResourceNumber();
            if (n == 0) {
                int n2 = CleanProjectContextMenuAction.getResourceNumber();
                if (n2 == 0) {
                    int n3 = CompileFileAction.getResourceNumber();
                    if (n3 == 0) {
                        bl = true;
                    } else if (n3 == 1) {
                        bl = true;
                    }
                } else if (n2 == 1) {
                    bl = true;
                }
            } else if (n == 1) {
                bl = true;
            }
        }
        return bl;
    }

    private void printBuildEndMessage() {
        if (this.logView != null) {
            String string = this.getDateFormat();
            if (BuildHandler.isBuildRunning()) {
                this.logView.logMessageInLogConsole(Messages.getFormattedString((String)"BuildLogger.Build_finished_at_6", (Object)new String[]{this.fProject.getName(), string}), 2, 2);
                this.logView.logMessageInLogConsole("--------------------------------------------------", 2, 2);
            } else {
                this.logView.logMessageInLogConsole(string, 2, 2);
            }
            this.logView.flush();
            this.logView.finishCurrentOutputStructureElement();
            this.logView.refreshConsoleTree();
            if (!BuildHandler.isBuildRunning()) {
                this.logView.logMessageInLogConsole("--------------------------------------------------", 2, 2);
                this.logView.flush();
            }
        }
    }

    public String getDateFormat() {
        return DateFormat.getDateTimeInstance(1, 2).format(new Date(System.currentTimeMillis()));
    }
}

