/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.core;

import com.unisys.os2200.i18nSupport.Messages;
import java.net.URL;
import java.util.Locale;
import org.eclipse.cobol.core.common.ICOBOLContributor;
import org.eclipse.cobol.core.registry.internal.IBuildToolRegistry;
import org.eclipse.cobol.core.registry.internal.ICOBOLContributorDescriptor;
import org.eclipse.cobol.core.registry.internal.ICOBOLContributorRegistry;
import org.eclipse.cobol.core.registry.internal.ITargetApplicationTypeRegistry;
import org.eclipse.cobol.core.registry.internal.core.BuildToolRegistry;
import org.eclipse.cobol.core.registry.internal.core.BuildToolRegistryReader;
import org.eclipse.cobol.core.registry.internal.core.COBOLContributorRegistry;
import org.eclipse.cobol.core.registry.internal.core.COBOLContributorRegistryReader;
import org.eclipse.cobol.core.registry.internal.core.TargetApplicationTypeRegistry;
import org.eclipse.cobol.core.registry.internal.core.TargetApplicationTypeRegistryReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cobol.core";
    public static final String PL_BUILD_TOOL = "buildtool";
    public static final String PL_TARGET_APPLICATION_TYPE = "targetapplicationtype";
    private static CorePlugin plugin;
    public static final int INTERNAL_ERROR = 20;
    private static String CoreLocale;
    private static final String LANGUAGE_CODE = "en";
    private static final String COUNTRY_CODE = "US";
    private BuildToolRegistry fBuildToolRegistry;
    private TargetApplicationTypeRegistry fTargetApplicationTypeRegistry;
    private IProject fCurrentProject;
    private IProgressMonitor fCurrentMonitor;
    private boolean bAutoBuildRunning = false;
    private ICOBOLContributorRegistry fCOBOLContributorRegistry;

    static {
        CoreLocale = "en_US";
    }

    public CorePlugin(IPluginDescriptor iPluginDescriptor) {
        super(iPluginDescriptor);
        plugin = this;
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getPluginId() {
        return CorePlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public IWorkbenchPage getActivePage() {
        return CorePlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow iWorkbenchWindow = CorePlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow == null) {
            return null;
        }
        return iWorkbenchWindow.getShell();
    }

    public static void log(Throwable throwable) {
        CorePlugin.log((IStatus)new Status(4, CorePlugin.getPluginId(), 4, "Error", throwable));
    }

    public static void log(String string) {
        if (string != null && string.length() > 0) {
            try {
                CorePlugin.getDefault().getLog().log(StatusUtil.newStatus((int)4, (String)string, null));
            }
            catch (RuntimeException runtimeException) {
                CorePlugin.log(runtimeException);
            }
        }
    }

    public static void log(String string, IStatus iStatus) {
        try {
            if (string != null) {
                CorePlugin.getDefault().getLog().log(StatusUtil.newStatus((int)4, (String)string, null));
            }
            CorePlugin.getDefault().getLog().log(iStatus);
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.log(nullPointerException);
        }
    }

    public static void log(IStatus iStatus) {
        try {
            CorePlugin.getDefault().getLog().log(iStatus);
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.log(nullPointerException);
        }
    }

    public static void logError(Exception exception) {
        try {
            Exception exception2 = exception;
            CorePlugin.log((IStatus)new Status(4, CorePlugin.getDefault().getDescriptor().getUniqueIdentifier(), 0, "error", (Throwable)exception2));
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.log(nullPointerException);
        }
    }

    public static void logError(String string, Exception exception) {
        try {
            Exception exception2 = exception;
            CorePlugin.log((IStatus)new Status(4, CorePlugin.getDefault().getDescriptor().getUniqueIdentifier(), 20, string, (Throwable)exception2));
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.log(nullPointerException);
        }
    }

    public String getLocale() {
        CoreLocale = Platform.getNL();
        return CoreLocale;
    }

    public Locale getOSLocale() {
        Locale locale = Locale.getDefault();
        if (locale == null) {
            return new Locale(LANGUAGE_CODE, COUNTRY_CODE);
        }
        return locale;
    }

    public IBuildToolRegistry getBuildToolsRegistry() {
        try {
            if (this.fBuildToolRegistry == null) {
                this.fBuildToolRegistry = new BuildToolRegistry();
                try {
                    BuildToolRegistryReader buildToolRegistryReader = new BuildToolRegistryReader();
                    buildToolRegistryReader.readBuildTools(Platform.getExtensionRegistry(), this.fBuildToolRegistry);
                }
                catch (CoreException coreException) {
                    CorePlugin.log(Messages.getString((String)"CorePlugin.Not_able_to_read_build_tool_from_registry_3"), coreException.getStatus());
                }
            }
            return this.fBuildToolRegistry;
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.printException(nullPointerException);
            return null;
        }
    }

    public ITargetApplicationTypeRegistry getTargetApplicationTypeRegistry() {
        if (this.fTargetApplicationTypeRegistry == null) {
            this.fTargetApplicationTypeRegistry = new TargetApplicationTypeRegistry();
            try {
                TargetApplicationTypeRegistryReader targetApplicationTypeRegistryReader = new TargetApplicationTypeRegistryReader();
                targetApplicationTypeRegistryReader.readTargetApplicationTypes(Platform.getExtensionRegistry(), this.fTargetApplicationTypeRegistry);
            }
            catch (CoreException coreException) {
                CorePlugin.log(Messages.getString((String)"CorePlugin.Not_able_to_read_build_tool_from_registry_4"), coreException.getStatus());
            }
        }
        return this.fTargetApplicationTypeRegistry;
    }

    public void setCurrentProject(IProject iProject) {
        this.fCurrentProject = iProject;
    }

    public IProject getCurrentProject() {
        return this.fCurrentProject;
    }

    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.fCurrentMonitor = iProgressMonitor;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.fCurrentMonitor;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (plugin == null) {
            return null;
        }
        IWorkbench iWorkbench = plugin.getWorkbench();
        if (iWorkbench == null) {
            return null;
        }
        return iWorkbench.getActiveWorkbenchWindow();
    }

    private static void printException(Exception exception) {
        System.out.println(exception.getMessage());
    }

    public boolean isAutoBuildRunning() {
        return this.bAutoBuildRunning;
    }

    public void setAutoBuildRunning(boolean bl) {
        this.bAutoBuildRunning = bl;
    }

    public ICOBOLContributor getDefaultCOBOLContributor() {
        String string = CorePlugin.getDefault().getPreferenceStore().getString("COBOLContributor");
        if (string == null || string != null && string.length() == 0) {
            string = CorePlugin.getDefault().getPreferenceStore().getDefaultString("COBOLContributor");
        }
        ICOBOLContributorRegistry iCOBOLContributorRegistry = CorePlugin.getDefault().getCOBOLContributorRegistry();
        ICOBOLContributorDescriptor[] iCOBOLContributorDescriptorArray = iCOBOLContributorRegistry.getCOBOLContributors();
        int n = 0;
        while (string != null && iCOBOLContributorDescriptorArray != null && n < iCOBOLContributorDescriptorArray.length) {
            if (string.equalsIgnoreCase(iCOBOLContributorDescriptorArray[n].getProviderID())) {
                return iCOBOLContributorDescriptorArray[n].getCOBOLContributor();
            }
            ++n;
        }
        if (string != null && string.length() == 0 && iCOBOLContributorDescriptorArray != null && iCOBOLContributorDescriptorArray.length > 0) {
            return iCOBOLContributorDescriptorArray[0].getCOBOLContributor();
        }
        return null;
    }

    public ICOBOLContributorRegistry getCOBOLContributorRegistry() {
        try {
            if (this.fCOBOLContributorRegistry == null) {
                this.fCOBOLContributorRegistry = new COBOLContributorRegistry();
                try {
                    COBOLContributorRegistryReader cOBOLContributorRegistryReader = new COBOLContributorRegistryReader();
                    cOBOLContributorRegistryReader.readCOBOLContributors(Platform.getExtensionRegistry(), this.fCOBOLContributorRegistry);
                }
                catch (CoreException coreException) {
                    CorePlugin.log(coreException);
                }
            }
            return this.fCOBOLContributorRegistry;
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.printException(nullPointerException);
            return null;
        }
    }

    public static String getPluginLocation() {
        String string = null;
        try {
            string = Platform.resolve((URL)CorePlugin.getDefault().getDescriptor().getInstallURL()).getPath();
            if (string.startsWith("/") && Platform.getOS().equals("win32")) {
                string = string.substring(1);
                string = string.replace('/', '\\');
            }
        }
        catch (Exception exception) {}
        return string;
    }
}

