/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.actions.range;

import org.eclipse.gef.commands.Command;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jst.pagedesigner.actions.range.ParagraphStyleAction;
import org.eclipse.jst.pagedesigner.commands.range.Paragraph;
import org.eclipse.jst.pagedesigner.commands.range.ParagraphFinder;
import org.eclipse.jst.pagedesigner.commands.range.ParagraphUnapplyStyleCommand;
import org.eclipse.jst.pagedesigner.dom.DOMRange;
import org.eclipse.jst.pagedesigner.dom.EditModelQuery;
import org.eclipse.jst.pagedesigner.dom.IDOMPosition;
import org.w3c.dom.Node;

public class NoneParagraphStyleAction
extends ParagraphStyleAction {
    private String[] _applyingTags;

    public NoneParagraphStyleAction(String text, String[] tags, ImageDescriptor image, int style) {
        super(text, "", image, style);
        this._applyingTags = tags;
    }

    public NoneParagraphStyleAction(String text, Node node, ImageDescriptor image, int style) {
        super(text, node, image, style);
    }

    protected boolean isApplied(DOMRange range) {
        if (range != null) {
            boolean ordered = range.isOrdered();
            IDOMPosition start = ordered ? range.getStartPosition() : range.getEndPosition();
            IDOMPosition end = ordered ? range.getEndPosition() : range.getStartPosition();
            Node common = null;
            if (EditModelQuery.isSame(range)) {
                ParagraphFinder finder = new ParagraphFinder(start);
                Paragraph p = finder.getParagraph(start);
                common = p.getLowestContainer();
            } else {
                common = EditModelQuery.getInstance().getCommonAncestor(start, end);
            }
            return !EditModelQuery.hasAncestor(common, this._applyingTags, true);
        }
        return false;
    }

    protected Command getCommand() {
        ParagraphUnapplyStyleCommand command = new ParagraphUnapplyStyleCommand(this.getViewer(), this._applyingTags, null, null);
        return command;
    }
}

