/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core.characterset;

import com.unisys.tde.core.characterset.Messages;
import com.unisys.tde.core.characterset.OS2200CharSetPlugin;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SevenBitTranslate {
    private static final String SEVENBIT = "sevenbit";
    private static final String UNICODE = "unicode";
    private static final String NAME = "name";
    public static final String TABLEFILE = "SevenBitTable.xml";
    public static final String CODESETTAG = "codeset";
    static Hashtable<String, Hashtable<String, String>> CodeSetToList = new Hashtable();
    static Hashtable<String, Hashtable<String, String>> CodeSetFromList = new Hashtable();
    static Vector<String> CodeList = new Vector();

    static {
        try {
            OS2200CharSetPlugin.logger.debug((Object)"");
            File tbleFile = OS2200CharSetPlugin.getFilePath(TABLEFILE);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(tbleFile);
            doc.getDocumentElement().normalize();
            NodeList nl = doc.getElementsByTagName(CODESETTAG);
            int i = 0;
            while (i < nl.getLength()) {
                Node ni = nl.item(i);
                if (ni instanceof Element) {
                    Element elC = (Element)ni;
                    String nm = elC.getAttribute(NAME);
                    OS2200CharSetPlugin.logger.debug((Object)("adding " + nm));
                    NodeList nC = ni.getChildNodes();
                    if (nC.getLength() > 0) {
                        Hashtable<String, String> CodeSetTo = new Hashtable<String, String>();
                        Hashtable<String, String> CodeSetFrom = new Hashtable<String, String>();
                        CodeList.add(nm);
                        int j = 0;
                        while (j < nC.getLength()) {
                            Node nj = nC.item(j);
                            if (nj instanceof Element) {
                                Element elCharacter = (Element)nj;
                                String unicode = elCharacter.getAttribute(UNICODE);
                                String sevenbit = elCharacter.getAttribute(SEVENBIT);
                                CodeSetTo.put(unicode, sevenbit);
                                CodeSetFrom.put(sevenbit, unicode);
                            }
                            ++j;
                        }
                        CodeSetToList.put(nm, CodeSetTo);
                        CodeSetFromList.put(nm, CodeSetFrom);
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            OS2200CharSetPlugin.logger.error((Object)Messages.getString("SevenBitTranslate.5", e.getLocalizedMessage()));
            OS2200CharSetPlugin.logger.info((Object)"parser configuration error reading 7bit codeset table \n", (Throwable)e);
        }
        catch (SAXException e) {
            OS2200CharSetPlugin.logger.error((Object)Messages.getString("SevenBitTranslate.5", e.getLocalizedMessage()));
            OS2200CharSetPlugin.logger.info((Object)"SAX error reading 7bit codeset table \n", (Throwable)e);
        }
        catch (IOException e) {
            OS2200CharSetPlugin.logger.error((Object)Messages.getString("SevenBitTranslate.5", e.getLocalizedMessage()));
            OS2200CharSetPlugin.logger.info((Object)"IO error reading 7bit codeset table \n", (Throwable)e);
        }
        catch (Throwable e) {
            OS2200CharSetPlugin.logger.error((Object)Messages.getString("SevenBitTranslate.5", e.getLocalizedMessage()));
            OS2200CharSetPlugin.logger.info((Object)"IO error reading 7bit codeset table \n", e);
        }
    }

    public static boolean sevenBitUnicodetoUnisysTrans(String inFile, String outFile, String codeName) {
        OS2200CharSetPlugin.logger.debug((Object)"");
        boolean stat = true;
        try {
            File fl = new File(inFile);
            int lng = (int)fl.length();
            byte[] bfIn = new byte[lng];
            FileInputStream rdFile = new FileInputStream(inFile);
            int lngt = ((InputStream)rdFile).read(bfIn);
            if (bfIn[0] == -2) {
                System.arraycopy(bfIn, 2, bfIn, 0, lngt -= 2);
            }
            Hashtable<String, String> codeto = CodeSetToList.get(codeName);
            byte[] bfOut = SevenBitTranslate.sevenBitTransfromUnicode(bfIn, lngt, codeto);
            ((InputStream)rdFile).close();
            FileOutputStream wrFile = new FileOutputStream(outFile);
            ((OutputStream)wrFile).write(bfOut);
            ((OutputStream)wrFile).close();
        }
        catch (IOException ioe) {
            OS2200CharSetPlugin.logger.error((Object)"CharacterConvert.1", (Throwable)ioe);
            return false;
        }
        return stat;
    }

    public static boolean sevenBitUnisystoUnicodeTrans(String inFile, String outFile, String codeName) {
        OS2200CharSetPlugin.logger.debug((Object)"");
        boolean stat = true;
        try {
            File fl = new File(inFile);
            int lng = (int)fl.length();
            byte[] bfIn = new byte[lng];
            FileInputStream rdFile = new FileInputStream(inFile);
            int lngt = ((InputStream)rdFile).read(bfIn);
            Hashtable<String, String> codeto = CodeSetFromList.get(codeName);
            byte[] bfOut = SevenBitTranslate.sevenBitTranstoUnicode(bfIn, lngt, codeto);
            ((InputStream)rdFile).close();
            FileOutputStream wrFile = new FileOutputStream(outFile);
            ((OutputStream)wrFile).write(bfOut);
            ((OutputStream)wrFile).close();
        }
        catch (IOException ioe) {
            OS2200CharSetPlugin.logger.error((Object)"CharacterConvert.1", (Throwable)ioe);
            return false;
        }
        return stat;
    }

    public static byte[] sevenBitTranstoUnicode(byte[] bfIn, int lngIn, Hashtable<String, String> dict) {
        OS2200CharSetPlugin.logger.debug((Object)"");
        String okBI = "PP";
        try {
            byte[] oBuf = new byte[2 * lngIn];
            int i = 0;
            while (i < lngIn) {
                byte b = bfIn[i];
                String lkBI = "0" + Integer.toHexString(b);
                lkBI = lkBI.substring(lkBI.length() - 2).toUpperCase();
                okBI = dict.get(lkBI);
                oBuf[i * 2] = 0;
                if (okBI != null) {
                    int io = Integer.parseInt(okBI, 16);
                    oBuf[i * 2 + 1] = (byte)io;
                } else {
                    oBuf[i * 2 + 1] = b;
                }
                ++i;
            }
            return oBuf;
        }
        catch (NumberFormatException e) {
            OS2200CharSetPlugin.logger.info((Object)("seven bit trans bad number " + okBI));
            return bfIn;
        }
    }

    public static byte[] sevenBitTranstoUnicode(byte[] bfIn, int lngIn, String codeName) {
        Hashtable<String, String> codeto = CodeSetFromList.get(codeName);
        return SevenBitTranslate.sevenBitTranstoUnicode(bfIn, lngIn, codeto);
    }

    public static byte[] sevenBitTransfromUnicode(byte[] bfIn, int lngIn, Hashtable<String, String> dict) {
        OS2200CharSetPlugin.logger.debug((Object)"");
        String okBI = "PP";
        try {
            byte[] oBuf = new byte[lngIn / 2];
            int i = 0;
            while (i < lngIn / 2) {
                byte b = bfIn[i * 2 + 1];
                String lkBI = "0" + Integer.toHexString(b);
                okBI = dict.get(lkBI = lkBI.substring(lkBI.length() - 2).toUpperCase());
                if (okBI != null) {
                    int io = Integer.parseInt(okBI, 16);
                    oBuf[i] = (byte)io;
                } else {
                    oBuf[i] = b;
                }
                ++i;
            }
            return oBuf;
        }
        catch (NumberFormatException e) {
            OS2200CharSetPlugin.logger.info((Object)("seven bit trans bad number " + okBI));
            return bfIn;
        }
    }

    public static byte[] sevenBitTransfromUnicode(byte[] bfIn, int lngIn, String codeName) {
        Hashtable<String, String> codeto = CodeSetToList.get(codeName);
        return SevenBitTranslate.sevenBitTransfromUnicode(bfIn, lngIn, codeto);
    }

    public static Collection<String> codeSetList() {
        return CodeSetToList.keySet();
    }
}

