/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core.characterset;

import com.unisys.tde.core.characterset.OS2200CharSetPlugin;
import com.unisys.tde.core.characterset.SevenBitTranslate;
import com.unisys.tde.core.characterset.UniToLetsJ;
import com.unisys.tde.core.characterset.UnicodeTable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharacterConversion {
    public static String JAPANESE = "Japanese(LetsJ)";
    public static final String NoCharConversion = "<NONE>";

    public static ArrayList<String> ListCharSets() {
        OS2200CharSetPlugin.logger.debug((Object)"");
        ArrayList<String> outArray = new ArrayList<String>();
        outArray.add(NoCharConversion);
        outArray.add(JAPANESE);
        outArray.addAll(SevenBitTranslate.codeSetList());
        return outArray;
    }

    public static String[] ListCharSetsArray() {
        OS2200CharSetPlugin.logger.debug((Object)"");
        ArrayList<String> nArray = CharacterConversion.ListCharSets();
        String[] oStringArray = new String[nArray.size()];
        oStringArray = nArray.toArray(oStringArray);
        return oStringArray;
    }

    public static int FindCharSetinArray(String charSetName) {
        ArrayList<String> nArray = CharacterConversion.ListCharSets();
        int chrSetIndex = nArray.indexOf(charSetName);
        if (chrSetIndex < 0) {
            chrSetIndex = 0;
        }
        return chrSetIndex;
    }

    public static boolean ConvertToUnisys(String inFile, String outFile, String csName) {
        OS2200CharSetPlugin.logger.debug((Object)"");
        if (csName.equals(JAPANESE)) {
            return UniToLetsJ.transUnitoLetsJFiles(inFile, outFile);
        }
        return SevenBitTranslate.sevenBitUnicodetoUnisysTrans(inFile, outFile, csName);
    }

    public static String ConvertBufferToUnisys(String inBuffer, String csName) {
        OS2200CharSetPlugin.logger.debug((Object)"");
        try {
            byte[] btIn = inBuffer.getBytes("UTF-16");
            int lngt = btIn.length;
            byte fst = btIn[0];
            if (fst == -2) {
                System.arraycopy(btIn, 2, btIn, 0, lngt -= 2);
            }
            if (csName.equals(JAPANESE)) {
                byte[] oByte = UniToLetsJ.transUniToLetsJ(btIn, lngt);
                String outString = new String(oByte, "Cp1252");
                CharacterConversion.checkOutBytes(outString, oByte, btIn, inBuffer);
                return outString;
            }
            if (SevenBitTranslate.CodeList.contains(csName)) {
                byte[] oByte = SevenBitTranslate.sevenBitTransfromUnicode(btIn, lngt, csName);
                return new String(oByte);
            }
            return inBuffer;
        }
        catch (UnsupportedEncodingException e) {
            OS2200CharSetPlugin.logger.info((Object)"Error translating String", (Throwable)e);
            e.printStackTrace();
            return inBuffer;
        }
    }

    public static byte[] ConvertBufferToUnisysNoSring(String inBuffer, String csName) {
        OS2200CharSetPlugin.logger.debug((Object)"");
        try {
            byte[] btIn = inBuffer.getBytes("UTF-16");
            int lngt = btIn.length;
            byte fst = btIn[0];
            if (fst == -2) {
                System.arraycopy(btIn, 2, btIn, 0, lngt -= 2);
            }
            if (csName.equals(JAPANESE)) {
                byte[] oByte = UniToLetsJ.transUniToLetsJ(btIn, lngt);
                String outString = new String(oByte, "Cp1252");
                CharacterConversion.checkOutBytes(outString, oByte, btIn, inBuffer);
                return oByte;
            }
            if (SevenBitTranslate.CodeList.contains(csName)) {
                byte[] oByte = SevenBitTranslate.sevenBitTransfromUnicode(btIn, lngt, csName);
                return oByte;
            }
            return inBuffer.getBytes();
        }
        catch (UnsupportedEncodingException e) {
            OS2200CharSetPlugin.logger.info((Object)"Error translating String", (Throwable)e);
            e.printStackTrace();
            return inBuffer.getBytes();
        }
    }

    private static void checkOutBytes(String doneString, byte[] tBytes, byte[] oBytes, String oString) {
        byte[] dBytes = doneString.getBytes();
        int ib = 0;
        while (ib < dBytes.length) {
            if (dBytes[ib] == 63) {
                OS2200CharSetPlugin.logger.debug((Object)"077 found,  translated bytes");
                String tDisp = "";
                int ibt = 0;
                while (ibt < tBytes.length) {
                    tDisp = String.valueOf(tDisp) + Integer.toString(tBytes[ibt], 16) + " ";
                    if (ibt % 10 == 9) {
                        OS2200CharSetPlugin.logger.debug((Object)tDisp);
                        tDisp = "";
                    }
                    ++ibt;
                }
                OS2200CharSetPlugin.logger.debug((Object)tDisp);
                OS2200CharSetPlugin.logger.debug((Object)"origianl bytes ");
                tDisp = "";
                int obt = 0;
                while (obt < oBytes.length) {
                    tDisp = String.valueOf(tDisp) + Integer.toString(oBytes[obt], 16) + " ";
                    if (obt % 10 == 9) {
                        OS2200CharSetPlugin.logger.debug((Object)tDisp);
                        tDisp = "";
                    }
                    ++obt;
                }
                OS2200CharSetPlugin.logger.debug((Object)"first string to Bytes");
                tDisp = "";
                ibt = 0;
                while (ibt < dBytes.length) {
                    tDisp = String.valueOf(tDisp) + Integer.toString(dBytes[ibt], 16) + " ";
                    if (ibt % 10 == 9) {
                        OS2200CharSetPlugin.logger.debug((Object)tDisp);
                        tDisp = "";
                    }
                    ++ibt;
                }
                OS2200CharSetPlugin.logger.debug((Object)tDisp);
                OS2200CharSetPlugin.logger.debug((Object)("Original String: '" + oString + "'"));
                break;
            }
            ++ib;
        }
    }

    public static boolean ConvertToUnicode(String inFile, String outFile, String csName) {
        OS2200CharSetPlugin.logger.debug((Object)"");
        if (csName.equals(JAPANESE)) {
            return UnicodeTable.Lets2UniFiles(inFile, outFile);
        }
        return SevenBitTranslate.sevenBitUnisystoUnicodeTrans(inFile, outFile, csName);
    }

    public static byte[] ConvertBufferToUnicode(byte[] inByte, int bufLen, String csName) {
        OS2200CharSetPlugin.logger.debug((Object)"");
        int lngt = bufLen;
        if (csName.equals(JAPANESE)) {
            byte[] oByte = UnicodeTable.Lets2Uni(inByte, lngt);
            return oByte;
        }
        if (SevenBitTranslate.CodeList.contains(csName)) {
            byte[] oByte = SevenBitTranslate.sevenBitTranstoUnicode(inByte, lngt, csName);
            return oByte;
        }
        return CharacterConversion.NoOptoUnicode(inByte, bufLen);
    }

    public static byte[] NoOptoUnicode(byte[] bfIn, int bufLen) {
        OS2200CharSetPlugin.logger.debug((Object)"");
        try {
            int lngIn = bufLen;
            byte[] oBuf = new byte[2 * lngIn];
            int i = 0;
            while (i < lngIn) {
                byte b;
                oBuf[i * 2 + 1] = b = bfIn[i];
                ++i;
            }
            return oBuf;
        }
        catch (NumberFormatException e) {
            OS2200CharSetPlugin.logger.info((Object)"error in null translate ", (Throwable)e);
            return bfIn;
        }
    }
}

