/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.common.util;

import com.unisys.common.util.CommonUtilLogger;
import com.unisys.common.util.RegistryUtil;
import org.apache.log4j.Logger;

public class OSTypeFactory {
    private static final String OS_X86 = "x86";
    private static final String OS_X64 = "64";
    private static final String WIN32_X86_REGISTRY32 = "com.unisys.win32.x86.util.Registry32Util";
    private static final String WIN32_X64_REGISTRY64 = "com.unisys.win32.x64.util.Registry64Util";

    public static RegistryUtil createInstance(String os) throws Exception, IllegalAccessException {
        Logger logger;
        RegistryUtil reg;
        block10: {
            Class<?> osClassUtil = null;
            reg = null;
            logger = CommonUtilLogger.getLogger();
            if (os.equalsIgnoreCase(OS_X86)) {
                try {
                    osClassUtil = Class.forName(WIN32_X86_REGISTRY32);
                    reg = (RegistryUtil)osClassUtil.newInstance();
                    if (logger != null) {
                        logger.debug((Object)("Returned class....." + reg));
                    }
                    break block10;
                }
                catch (ClassNotFoundException ce) {
                    if (logger != null) {
                        logger.error((Object)("Class Not Found 32 bit:" + ce.getMessage()));
                    }
                    break block10;
                }
            }
            if (os.contains(OS_X64)) {
                try {
                    osClassUtil = Class.forName(WIN32_X64_REGISTRY64);
                    reg = (RegistryUtil)osClassUtil.newInstance();
                    if (logger != null) {
                        logger.debug((Object)("Returned class....." + reg));
                    }
                }
                catch (ClassNotFoundException ce) {
                    if (logger == null) break block10;
                    logger.error((Object)("Class Not Found 64 bit:" + ce.getMessage()));
                }
            }
        }
        if (logger != null) {
            logger.info((Object)"Returned createinstance successfully");
        }
        return reg;
    }
}

