/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IEnumeration;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.internal.qt.core.ASTUtil;
import org.eclipse.cdt.internal.qt.core.QtMethodReference;
import org.eclipse.cdt.qt.core.QtKeywords;

public class QtFunctionCall {
    private QtFunctionCall() {
    }

    public static Collection<QtMethodReference> getReferences(IASTFunctionCallExpression call) {
        ICPPFunction function = ASTUtil.resolveFunctionBinding(ICPPFunction.class, call);
        if (function == null) {
            return null;
        }
        if (QtKeywords.is_QObject_connect((IBinding)function)) {
            return QtFunctionCall.getReferencesInConnect(function, call);
        }
        if (QtKeywords.is_QObject_disconnect((IBinding)function)) {
            return QtFunctionCall.getReferencesInDisconnect(function, call);
        }
        return null;
    }

    private static Collection<QtMethodReference> getReferencesInConnect(ICPPFunction function, IASTFunctionCallExpression call) {
        if (function == null) {
            return null;
        }
        ICPPParameter[] params = function.getParameters();
        if (params.length < 4) {
            return null;
        }
        IASTInitializerClause[] args = call.getArguments();
        IType type3 = ASTUtil.getBaseType(params[3].getType());
        if (QtKeywords.isQMetaMethod(type3)) {
            return null;
        }
        QtMethodReference signal = null;
        QtMethodReference member = null;
        if (type3 instanceof IBasicType && ((IBasicType)type3).getKind() == IBasicType.Kind.eChar) {
            signal = QtMethodReference.parse((IASTNode)call, ASTUtil.getBaseType(QtFunctionCall.safeArgsAt((IASTNode[])args, 0)), QtFunctionCall.safeArgsAt((IASTNode[])args, 1));
            member = QtMethodReference.parse((IASTNode)call, ASTUtil.getBaseType(QtFunctionCall.safeArgsAt((IASTNode[])args, 2)), QtFunctionCall.safeArgsAt((IASTNode[])args, 3));
        } else if (type3 instanceof IEnumeration) {
            signal = QtMethodReference.parse((IASTNode)call, ASTUtil.getBaseType(QtFunctionCall.safeArgsAt((IASTNode[])args, 0)), QtFunctionCall.safeArgsAt((IASTNode[])args, 1));
            member = QtMethodReference.parse((IASTNode)call, (IType)ASTUtil.getReceiverType(call), QtFunctionCall.safeArgsAt((IASTNode[])args, 2));
        }
        return QtFunctionCall.mergeNonNull(signal, member);
    }

    private static Collection<QtMethodReference> getReferencesInDisconnect(ICPPFunction function, IASTFunctionCallExpression call) {
        if (function == null) {
            return null;
        }
        ICPPParameter[] params = function.getParameters();
        if (params.length < 2) {
            return null;
        }
        IASTInitializerClause[] args = call.getArguments();
        IType type1 = ASTUtil.getBaseType(params[1].getType());
        if (QtKeywords.isQMetaMethod(type1)) {
            return Collections.emptyList();
        }
        QtMethodReference signal = null;
        QtMethodReference member = null;
        if (type1 instanceof IBasicType && ((IBasicType)type1).getKind() == IBasicType.Kind.eChar) {
            switch (params.length) {
                case 4: {
                    signal = QtMethodReference.parse((IASTNode)call, ASTUtil.getBaseType(QtFunctionCall.safeArgsAt((IASTNode[])args, 0)), QtFunctionCall.safeArgsAt((IASTNode[])args, 1));
                    member = QtMethodReference.parse((IASTNode)call, ASTUtil.getBaseType(QtFunctionCall.safeArgsAt((IASTNode[])args, 2)), QtFunctionCall.safeArgsAt((IASTNode[])args, 3));
                    break;
                }
                case 2: {
                    member = QtMethodReference.parse((IASTNode)call, ASTUtil.getBaseType(QtFunctionCall.safeArgsAt((IASTNode[])args, 0)), QtFunctionCall.safeArgsAt((IASTNode[])args, 1));
                }
            }
        } else if (QtKeywords.isQObject(type1)) {
            ICPPClassType recvr = ASTUtil.getReceiverType(call);
            signal = QtMethodReference.parse((IASTNode)call, (IType)recvr, QtFunctionCall.safeArgsAt((IASTNode[])args, 0));
            member = QtMethodReference.parse((IASTNode)call, ASTUtil.getBaseType(QtFunctionCall.safeArgsAt((IASTNode[])args, 1)), QtFunctionCall.safeArgsAt((IASTNode[])args, 2));
        }
        return QtFunctionCall.mergeNonNull(signal, member);
    }

    private static IASTNode safeArgsAt(IASTNode[] args, int index) {
        return args.length > index ? args[index] : null;
    }

    private static <T> Collection<T> mergeNonNull(T ... withNulls) {
        Object firstNonNull = null;
        ArrayList<T> list = null;
        T[] TArray = withNulls;
        int n = withNulls.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t != null) {
                if (list != null) {
                    list.add(t);
                } else if (firstNonNull == null) {
                    firstNonNull = t;
                } else {
                    list = new ArrayList<T>(withNulls.length);
                    list.add(firstNonNull);
                    list.add(t);
                }
            }
            ++n2;
        }
        if (list != null) {
            return list;
        }
        if (firstNonNull != null) {
            return Collections.singletonList(firstNonNull);
        }
        return null;
    }
}

