/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.eclipselink.ui.JptJpaEclipseLinkUiMessages;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.dialogs.EclipseLinkAddVirtualAttributeDialog;
import org.eclipse.jpt.jpa.eclipselink.ui.internal.entity.data.model.EclipseLinkDynamicEntityField;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseLinkDynamicEntityFieldTableSection
extends Composite {
    private IDataModel model;
    private Table mTableWidget = null;
    private TableViewer mTableViewer = null;
    private final int NAME_COLUMN = 0;
    private final int MAPPING_TYPE_COLUMN = 1;
    private final int ATTRIBUTE_TYPE_COLUMN = 2;
    private final int TARGET_TYPE_COLUMN = 3;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private String propertyName;

    public EclipseLinkDynamicEntityFieldTableSection(Composite parent, IDataModel model, String propertyName) {
        super(parent, 0);
        this.model = model;
        this.propertyName = propertyName;
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 4;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        this.mTableWidget = new Table((Composite)this, 67584);
        this.mTableWidget.setHeaderVisible(true);
        this.mTableWidget.setLinesVisible(true);
        GridData data = new GridData(1808);
        data.verticalSpan = 2;
        this.mTableWidget.setLayoutData((Object)data);
        TableColumn nameColumn = new TableColumn(this.mTableWidget, 0);
        nameColumn.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_NAME_COLUMN_LABEL);
        TableColumn mappingTypeColumn = new TableColumn(this.mTableWidget, 0);
        mappingTypeColumn.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_MAPPING_TYPE_COLUMN_LABEL);
        TableColumn attrTypeColumn = new TableColumn(this.mTableWidget, 0);
        attrTypeColumn.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_ATTRIBUTE_TYPE_COLUMN_LABEL);
        TableColumn targetTypeColumn = new TableColumn(this.mTableWidget, 0);
        targetTypeColumn.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_TARGET_TYPE_COLUMN_LABEL);
        this.mTableViewer = new TableViewer(this.mTableWidget);
        this.mTableViewer.setContentProvider((IContentProvider)new EntityRowContentProvider());
        this.mTableViewer.setLabelProvider((IBaseLabelProvider)new EntityRowLabelProvider());
        this.mTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EclipseLinkDynamicEntityFieldTableSection.this.handleEditButtonSelected();
                EclipseLinkDynamicEntityFieldTableSection.this.updatePrimaryKeyFieldProperty();
            }
        });
        Composite buttonComposition = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonComposition.setLayout((Layout)layout);
        buttonComposition.setLayoutData((Object)new GridData(1042));
        this.addButton = new Button(buttonComposition, 8);
        this.addButton.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_ADD_BUTTON_LABEL);
        this.addButton.setLayoutData((Object)new GridData(258));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EclipseLinkDynamicEntityFieldTableSection.this.handleAddButtonSelected();
                EclipseLinkDynamicEntityFieldTableSection.this.updatePrimaryKeyFieldProperty();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton = new Button(buttonComposition, 8);
        this.editButton.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_EDIT_BUTTON_LABEL);
        this.editButton.setLayoutData((Object)new GridData(258));
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EclipseLinkDynamicEntityFieldTableSection.this.handleEditButtonSelected();
                EclipseLinkDynamicEntityFieldTableSection.this.updatePrimaryKeyFieldProperty();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.editButton.setEnabled(false);
        this.removeButton = new Button(buttonComposition, 8);
        this.removeButton.setText(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_REMOVE_BUTTON_LABEL);
        this.removeButton.setLayoutData((Object)new GridData(258));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                EclipseLinkDynamicEntityFieldTableSection.this.handleRemoveButtonSelected();
                EclipseLinkDynamicEntityFieldTableSection.this.updatePrimaryKeyFieldProperty();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton.setEnabled(false);
        this.mTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (EclipseLinkDynamicEntityFieldTableSection.this.editButton != null) {
                    boolean enabled = ((IStructuredSelection)selection).size() == 1;
                    EclipseLinkDynamicEntityFieldTableSection.this.editButton.setEnabled(enabled);
                }
                EclipseLinkDynamicEntityFieldTableSection.this.removeButton.setEnabled(!selection.isEmpty());
            }
        });
        this.addControlListener((ControlListener)new ColumnControlListener(buttonComposition));
    }

    private void handleAddButtonSelected() {
        AddFieldDialog dialog = new AddFieldDialog(this.getShell(), this.getJpaProject());
        int result = dialog.open();
        if (result == 1) {
            return;
        }
        EclipseLinkDynamicEntityField entityField = dialog.getEntityField();
        this.addEntityField(entityField);
    }

    private void addEntityField(EclipseLinkDynamicEntityField field) {
        if (field == null) {
            return;
        }
        ArrayList<EclipseLinkDynamicEntityField> valueList = (ArrayList<EclipseLinkDynamicEntityField>)this.mTableViewer.getInput();
        if (valueList == null) {
            valueList = new ArrayList<EclipseLinkDynamicEntityField>();
        }
        valueList.add(field);
        this.setInput(valueList);
    }

    private void handleEditButtonSelected() {
        ISelection s = this.mTableViewer.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)s;
        if (selection.size() != 1) {
            return;
        }
        Object selectedObj = selection.getFirstElement();
        EclipseLinkDynamicEntityField fieldForEdit = (EclipseLinkDynamicEntityField)selectedObj;
        int index = this.mTableWidget.getSelectionIndex();
        EditFieldDialog dialog = new EditFieldDialog(this.getShell(), this.getJpaProject(), fieldForEdit);
        dialog.open();
        EclipseLinkDynamicEntityField entityField = dialog.getEntityField();
        if (entityField != null) {
            this.editEntityField(index, entityField);
        }
    }

    private void editEntityField(int index, EclipseLinkDynamicEntityField field) {
        if (field == null) {
            return;
        }
        ArrayList<EclipseLinkDynamicEntityField> valueList = (ArrayList<EclipseLinkDynamicEntityField>)this.mTableViewer.getInput();
        if (valueList == null) {
            valueList = new ArrayList<EclipseLinkDynamicEntityField>();
        }
        if (index == -1) {
            valueList.add(field);
        } else {
            valueList.set(index, field);
        }
        this.setInput(valueList);
    }

    private void handleRemoveButtonSelected() {
        ISelection selection = this.mTableViewer.getSelection();
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return;
        }
        List selectedObject = ((IStructuredSelection)selection).toList();
        this.removeEntityField(selectedObject);
    }

    private void removeEntityField(Collection<EclipseLinkDynamicEntityField> fields) {
        ArrayList valueList = (ArrayList)this.mTableViewer.getInput();
        valueList.removeAll(fields);
        this.setInput(valueList);
    }

    private void setInput(List<EclipseLinkDynamicEntityField> input) {
        this.mTableViewer.setInput(input);
        ArrayList<EclipseLinkDynamicEntityField> newInput = new ArrayList<EclipseLinkDynamicEntityField>();
        newInput.addAll(input);
        this.model.setProperty(this.propertyName, newInput);
    }

    public TableViewer getTableViewer() {
        return this.mTableViewer;
    }

    private void updatePrimaryKeyFieldProperty() {
        ArrayList<EclipseLinkDynamicEntityField> pkFields = new ArrayList<EclipseLinkDynamicEntityField>();
        TableItem[] children = this.mTableViewer.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            EclipseLinkDynamicEntityField field = (EclipseLinkDynamicEntityField)item.getData();
            if (field.getMappingType().getKey().equals("id")) {
                field.setKey(true);
                pkFields.add(field);
            }
            ++i;
        }
        this.model.setProperty("IEntityDataModelProperties.PK_FIELDS", pkFields);
    }

    protected JpaProject getJpaProject() {
        return (JpaProject)this.getIProject().getAdapter(JpaProject.class);
    }

    protected IProject getIProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        return ProjectUtilities.getProject((String)projectName);
    }

    private class AddFieldDialog
    extends EclipseLinkAddVirtualAttributeDialog {
        protected EclipseLinkDynamicEntityField entityField;
        protected final JpaProject jpaProject;

        public AddFieldDialog(Shell shell, JpaProject jpaProject) {
            super(shell, null);
            this.jpaProject = jpaProject;
            this.setTitle(JptJpaEclipseLinkUiMessages.DYNAMIC_ENTITY_FIELDS_WIZARD_PAGE_ADD_DYNAMIC_ENTITY_FIELD_DIALOG_TITLE);
        }

        public Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            return composite;
        }

        protected void okPressed() {
            EclipseLinkDynamicEntityField field = new EclipseLinkDynamicEntityField();
            field.setName(this.nameText.getText());
            field.setMappingType(this.getMappingUiDefinition(this.mappingCombo));
            String mappingKey = field.getMappingType().getKey();
            if (this.getAttributeMappingDefinition(mappingKey).isSingleRelationshipMapping()) {
                field.setFqnAttributeType("");
            } else {
                field.setFqnAttributeType(this.attributeTypeText.getText());
            }
            if (!this.getAttributeMappingDefinition(mappingKey).isSingleRelationshipMapping() && !this.getAttributeMappingDefinition(mappingKey).isCollectionMapping()) {
                field.setFqnTargetType("");
            } else {
                field.setFqnTargetType(this.targetTypeText.getText());
            }
            this.entityField = field;
            this.setReturnCode(0);
            this.close();
        }

        private MappingUiDefinition getMappingUiDefinition(ComboViewer mappingType) {
            StructuredSelection selection = (StructuredSelection)mappingType.getSelection();
            return selection.isEmpty() ? null : (MappingUiDefinition)selection.getFirstElement();
        }

        public EclipseLinkDynamicEntityField getEntityField() {
            return this.entityField;
        }

        protected JpaProject getJpaProject() {
            return this.jpaProject;
        }

        protected JptResourceType getJptResourceType() {
            String xmlName = EclipseLinkDynamicEntityFieldTableSection.this.model.getStringProperty("IEntityDataModelProperties.XML_NAME");
            return this.getOrmXmlResource(xmlName).getResourceType();
        }

        protected JptXmlResource getOrmXmlResource(String xmlName) {
            return this.jpaProject == null ? null : this.jpaProject.getMappingFileXmlResource((IPath)new Path(xmlName));
        }
    }

    private final class ColumnControlListener
    extends ControlAdapter {
        private final Composite buttonComposition;

        private ColumnControlListener(Composite buttonComposition) {
            this.buttonComposition = buttonComposition;
        }

        public void controlResized(ControlEvent e) {
            Table table = EclipseLinkDynamicEntityFieldTableSection.this.mTableViewer.getTable();
            Rectangle area = table.getParent().getClientArea();
            Point preferredSize = table.computeSize(-1, -1);
            TableColumn[] columns = table.getColumns();
            Point buttonArea = this.buttonComposition.computeSize(-1, -1);
            int width = area.width - 3 * table.getBorderWidth();
            if (preferredSize.y > area.height + table.getHeaderHeight()) {
                Point vBarSize = table.getVerticalBar().getSize();
                width -= vBarSize.x;
            }
            Point oldSize = table.getSize();
            int consumeWidth = 0;
            int i = 0;
            while (i < columns.length) {
                if (oldSize.x > area.width) {
                    consumeWidth = this.setColumntWidth(width, columns, consumeWidth, i);
                    table.setSize(area.width - buttonArea.x, area.height);
                } else {
                    consumeWidth = this.setColumntWidth(width, columns, consumeWidth, i);
                    table.setSize(area.width - buttonArea.x, area.height);
                }
                ++i;
            }
        }

        private int setColumntWidth(int width, TableColumn[] columns, int consumeWidth, int i) {
            columns[i].setWidth(width / (columns.length + 1));
            return consumeWidth += columns[i].getWidth();
        }
    }

    private class EditFieldDialog
    extends AddFieldDialog {
        public EditFieldDialog(Shell shell, JpaProject jpaProject, EclipseLinkDynamicEntityField field) {
            super(shell, jpaProject);
            this.entityField = field;
        }

        public Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            this.nameText.setText(this.entityField.getName());
            this.mappingCombo.setSelection((ISelection)new StructuredSelection((Object)this.entityField.getMappingType()));
            this.attributeTypeText.setText(this.entityField.getFqnAttributeType());
            this.targetTypeText.setText(this.entityField.getFqnTargetType());
            return composite;
        }
    }

    protected class EntityRowContentProvider
    implements IStructuredContentProvider {
        protected EntityRowContentProvider() {
        }

        public boolean isDeleted(Object element) {
            return false;
        }

        public Object[] getElements(Object element) {
            return element instanceof List ? ((List)element).toArray() : ObjectTools.EMPTY_OBJECT_ARRAY;
        }

        public void inputChanged(Viewer aViewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    protected class EntityRowLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected EntityRowLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            EclipseLinkDynamicEntityField entity = (EclipseLinkDynamicEntityField)element;
            if (columnIndex == 0) {
                return entity.getName();
            }
            if (columnIndex == 1) {
                return entity.getMappingType().getLabel();
            }
            if (columnIndex == 2) {
                return entity.getFqnAttributeType();
            }
            if (columnIndex == 3) {
                return entity.getFqnTargetType();
            }
            return "";
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String[] array = (String[])element;
            if (array.length > 0) {
                return array[0];
            }
            return super.getText(element);
        }
    }
}

