/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.tde.core.characterset;

import com.unisys.logging.core.PluginLogManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OS2200CharSetPlugin
extends AbstractUIPlugin {
    public static Logger logger;
    public static final String PLUGIN_ID = "com.unisys.tde.core.characterset";
    public static final String[] langTypes;
    public static String JAPANESE;
    public static final String NoCharConversion = "<NONE>";
    private static OS2200CharSetPlugin plugin;
    private static final String LOG_PROPERTIES_FILE = "logger.properties";
    private PluginLogManager logManager;
    private static List<String> codeList;

    static {
        langTypes = new String[]{"German", "United_Kingdom", "Danish", "Dutch", "Finnish", "Flemish", "French", "French_Belgium", "French_Canadian", "German", "Italian", "Norwegian", "Spanish", "Swedish", "French_Swiss", "German_Swiss"};
        JAPANESE = "Japanese(LetsJ)";
        codeList = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.logManager = new PluginLogManager((Plugin)this);
        this.logManager.configure(LOG_PROPERTIES_FILE);
        logger = this.logManager.getLogger("com.unisys.os2200");
        logger.info((Object)"started OS2200CorePlugin");
        try {
            Thread loadCharSet = new Thread("Load Unisys Charset"){

                @Override
                public void run() {
                    OS2200CharSetPlugin.this.loadCharSetLib();
                }
            };
            loadCharSet.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static OS2200CharSetPlugin getDefault() {
        return plugin;
    }

    public static URL pluginURLPath(String fileToFind) {
        URL ourPath;
        try {
            URL rsPlatPath;
            URL platpath = FileLocator.find((Bundle)plugin.getBundle(), (IPath)new Path(fileToFind), null);
            ourPath = rsPlatPath = FileLocator.resolve((URL)platpath);
        }
        catch (Exception io) {
            System.out.println("error resolving " + io.getMessage());
            ourPath = null;
        }
        return ourPath;
    }

    public static File getFilePath(String fileToFind) {
        URL fPath = OS2200CharSetPlugin.pluginURLPath(fileToFind);
        if (fPath != null) {
            return new File(fPath.getPath());
        }
        return null;
    }

    public static InputStream opnStream(String flName) throws IOException {
        InputStream opstr = FileLocator.openStream((Bundle)plugin.getBundle(), (IPath)new Path(flName), (boolean)false);
        return opstr;
    }

    public void loadCharSetLib() {
        logger.debug((Object)"");
        try {
            URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> sysclass = URLClassLoader.class;
            Class[] parameters = new Class[]{URL.class};
            String libPath = this.getPluginDirectoryPathforCharConv(PLUGIN_ID);
            if (libPath != null) {
                URL url = new URL("file:" + File.separator + libPath + "unisys-charsets.jar");
                Method method = sysclass.getDeclaredMethod("addURL", parameters);
                method.setAccessible(true);
                method.invoke((Object)sysloader, url);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public String getPluginDirectoryPathforCharConv(String PLUGIN_ID) {
        logger.debug((Object)"");
        Path pluginDirectoryPath = null;
        try {
            Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
            URL baseURL = Platform.resolve((URL)bundle.getEntry("/"));
            pluginDirectoryPath = new Path(baseURL.getFile());
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
        return pluginDirectoryPath.toOSString();
    }

    public static Collection<String> codeSetList() {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(langTypes));
        return list;
    }

    public static ArrayList<String> ListCharSets() {
        ArrayList<String> outArray = new ArrayList<String>();
        outArray.add(NoCharConversion);
        outArray.add(JAPANESE);
        outArray.addAll(OS2200CharSetPlugin.codeSetList());
        return outArray;
    }

    public static String[] ListCharSetsArray() {
        ArrayList<String> nArray = OS2200CharSetPlugin.ListCharSets();
        String[] oStringArray = new String[nArray.size()];
        oStringArray = nArray.toArray(oStringArray);
        return oStringArray;
    }

    public static int FindCharSetinArray(String charSetName) {
        ArrayList<String> nArray = OS2200CharSetPlugin.ListCharSets();
        int chrSetIndex = nArray.indexOf(charSetName);
        if (chrSetIndex < 0) {
            chrSetIndex = 0;
        }
        return chrSetIndex;
    }

    public static byte[] ConvertBufferToUnicode(byte[] inByte, int bufLen, String csName) {
        logger.debug((Object)"");
        int lngt = bufLen;
        codeList = new ArrayList<String>(OS2200CharSetPlugin.codeSetList());
        if (csName.equals(JAPANESE)) {
            byte[] oByte = null;
            try {
                String convertedString = new String(inByte, 0, bufLen, "LETSJ");
                oByte = convertedString.getBytes("LETSJ");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return oByte;
        }
        byte[] oByte = null;
        try {
            String convertedString = new String(inByte, 0, bufLen);
            oByte = convertedString.getBytes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return oByte;
    }

    public static byte[] sevenBitTranstoUnicode(byte[] bfIn, int lngIn, Hashtable<String, String> dict) {
        logger.debug((Object)"");
        String okBI = "PP";
        try {
            byte[] oBuf = new byte[2 * lngIn];
            int i = 0;
            while (i < lngIn) {
                byte b = bfIn[i];
                String lkBI = "0" + Integer.toHexString(b);
                lkBI = lkBI.substring(lkBI.length() - 2).toUpperCase();
                okBI = dict.get(lkBI);
                oBuf[i * 2] = 0;
                if (okBI != null) {
                    int io = Integer.parseInt(okBI, 16);
                    oBuf[i * 2 + 1] = (byte)io;
                } else {
                    oBuf[i * 2 + 1] = b;
                }
                ++i;
            }
            return oBuf;
        }
        catch (NumberFormatException e) {
            logger.info((Object)("seven bit trans bad number " + okBI));
            return bfIn;
        }
    }

    public static byte[] NoOptoUnicode(byte[] bfIn, int bufLen) {
        logger.debug((Object)"");
        try {
            int lngIn = bufLen;
            byte[] oBuf = new byte[2 * lngIn];
            int i = 0;
            while (i < lngIn) {
                byte b = bfIn[i];
                oBuf[i * 2] = 0;
                oBuf[i * 2 + 1] = b;
                ++i;
            }
            return oBuf;
        }
        catch (NumberFormatException e) {
            logger.info((Object)"error in null translate ", (Throwable)e);
            return bfIn;
        }
    }
}

