/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.win32.x64.util;

import com.unisys.common.util.RegistryUtil;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.FILETIME;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public class Registry64Util
extends RegistryUtil {
    private static final int KEY_READ = 131097;
    private static final int REG_SZ = 1;
    private static final int ERROR_SUCCESS = 0;
    private static final int MAX_PATH = 260;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int MAX_KEY_LENGTH = 255;

    public void corecallJavaToNative(TransferData transferData, int byteCount, char[] chars) {
        long newPtr = OS.GlobalAlloc((int)64, (int)byteCount);
        OS.MoveMemory((long)newPtr, (char[])chars, (int)byteCount);
        transferData.stgmedium.unionField = newPtr;
    }

    public Object callNativeToJava(STGMEDIUM stgmedium) {
        long hMem = stgmedium.unionField;
        try {
            String string;
            int size = OS.GlobalSize((long)hMem) / 2 * 2;
            if (size == 0) {
                return null;
            }
            char[] chars = new char[size / 2];
            long ptr = OS.GlobalLock((long)hMem);
            if (ptr == 0L) {
                return null;
            }
            try {
                OS.MoveMemory((char[])chars, (long)ptr, (int)size);
                int length = chars.length;
                int i = 0;
                while (i < chars.length) {
                    if (chars[i] == '\u0000') {
                        length = i;
                        break;
                    }
                    ++i;
                }
                string = new String(chars, 0, length);
            }
            catch (Throwable throwable) {
                OS.GlobalUnlock((long)hMem);
                throw throwable;
            }
            OS.GlobalUnlock((long)hMem);
            return string;
        }
        finally {
            OS.GlobalFree((long)hMem);
        }
    }

    public String getRegString(int hKey, String subKey, String valueName) {
        TCHAR lpSubKey = new TCHAR(0, subKey, true);
        long[] phkResult = new long[1];
        int stat = OS.RegOpenKeyEx((long)hKey, (TCHAR)lpSubKey, (int)0, (int)131097, (long[])phkResult);
        if (stat != 0) {
            return null;
        }
        TCHAR lpValueName = new TCHAR(0, valueName, true);
        int[] lpType = new int[]{1};
        TCHAR lpData = new TCHAR(0, 260);
        int[] lpcbData = new int[]{260};
        stat = OS.RegQueryValueEx((long)phkResult[0], (TCHAR)lpValueName, (long)0L, (int[])lpType, (TCHAR)lpData, (int[])lpcbData);
        OS.RegCloseKey((long)phkResult[0]);
        if (stat != 0) {
            return null;
        }
        return lpData.toString(0, lpcbData[0] - 1).trim();
    }

    public String[] getSubKeys(String primaryKey) {
        TCHAR lpSubKey = new TCHAR(0, primaryKey, true);
        long[] phkResult = new long[1];
        int stat = OS.RegOpenKeyEx((long)-2147483646L, (TCHAR)lpSubKey, (int)0, (int)131097, (long[])phkResult);
        if (stat != 0) {
            return null;
        }
        return this.iterateKey(phkResult[0]);
    }

    private String[] iterateKey(long hKey) {
        String[] subKeys = null;
        TCHAR achKey = new TCHAR(0, 255);
        FILETIME ftLastWriteTime = new FILETIME();
        int resint = 0;
        int[] resintarray = null;
        TCHAR restchar = null;
        int[] cchClassName = new int[]{0};
        int[] cSubKeys = new int[]{0};
        int[] cbMaxSubKey = new int[]{0};
        int[] cchMaxClass = new int[]{0};
        int[] cValues = new int[]{0};
        int[] cchMaxValue = new int[]{0};
        int[] cbMaxValueData = new int[]{0};
        int[] cbSecurityDescriptor = new int[]{0};
        int[] cbName = new int[]{255};
        int retCode = OS.RegQueryInfoKey((long)hKey, (long)resint, resintarray, (long)resint, (int[])cSubKeys, (int[])cbMaxSubKey, (int[])cchMaxClass, (int[])cValues, (int[])cchMaxValue, (int[])cbMaxValueData, (int[])cbSecurityDescriptor, (long)resint);
        if (cSubKeys[0] != 0) {
            subKeys = new String[cSubKeys[0]];
            resintarray = null;
            restchar = null;
            int i = 0;
            while (i < cSubKeys[0]) {
                cbName[0] = 255;
                retCode = OS.RegEnumKeyEx((long)hKey, (int)i, (TCHAR)achKey, (int[])cbName, resintarray, restchar, resintarray, (FILETIME)ftLastWriteTime);
                subKeys[i] = retCode == 0 ? achKey.toString(0, cbName[0]) : "<Missing Entry>";
                ++i;
            }
        }
        return subKeys;
    }

    public boolean isValidSubKey(int hKey, String subKey) {
        TCHAR lpSubKey = new TCHAR(0, subKey, true);
        long[] phkResult = new long[1];
        return OS.RegOpenKeyEx((long)hKey, (TCHAR)lpSubKey, (int)0, (int)131097, (long[])phkResult) == 0;
    }
}

