/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cobol.build.ant;

import com.unisys.os2200.i18nSupport.Messages;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.Target;
import org.eclipse.cobol.core.CorePlugin;
import org.eclipse.cobol.core.ICommonConstants;
import org.eclipse.cobol.core.build.BuildHandler;
import org.eclipse.cobol.core.build.ProjectBuildToolsInteraction;
import org.eclipse.cobol.core.build.model.IBuildTool;
import org.eclipse.cobol.core.build.util.LogViewHelper;
import org.eclipse.cobol.core.build.util.TaskViewhelper;
import org.eclipse.cobol.core.registry.internal.IBuildToolDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.swt.widgets.Display;

public class CobolBuildLogger
implements BuildLogger {
    private IProject fProject = null;
    private IProgressMonitor fMonitor = null;
    private int fPriorityFilter = 2;
    private Hashtable fhBuildListeners = null;
    private BuildListener currentListener = null;
    private boolean fIsMessageLogged = false;
    private LogViewHelper logView = null;
    private ArrayList alLoggedMessages = null;
    private StringBuffer fsExceptionMessages = null;
    private boolean fbMarkersRemoved = false;
    boolean buildCancelled = false;

    public CobolBuildLogger() {
        if (CorePlugin.getDefault() != null) {
            this.fMonitor = CorePlugin.getDefault().getProgressMonitor();
            this.fProject = CorePlugin.getDefault().getCurrentProject();
        }
        this.fIsMessageLogged = false;
        this.alLoggedMessages = new ArrayList();
        this.fsExceptionMessages = new StringBuffer();
        this.logView = LogViewHelper.getDefault();
        this.collectBuildListener();
    }

    private void collectBuildListener() {
        this.fhBuildListeners = new Hashtable();
        ArrayList arrayList = ProjectBuildToolsInteraction.getBuildDescriptors((IProject)this.fProject);
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            try {
                IBuildToolDescriptor iBuildToolDescriptor = (IBuildToolDescriptor)arrayList.get(n2);
                String string = iBuildToolDescriptor.getId();
                BuildListener buildListener = null;
                try {
                    IBuildTool iBuildTool = iBuildToolDescriptor.createBuildTool();
                    iBuildTool.setProject(this.fProject);
                    String string2 = iBuildTool.getBuildListenerClassName();
                    try {
                        buildListener = (BuildListener)Class.forName(string2).newInstance();
                    }
                    catch (InstantiationException instantiationException) {
                        CorePlugin.logError((Exception)instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        CorePlugin.logError((Exception)illegalAccessException);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        CorePlugin.logError((Exception)classNotFoundException);
                    }
                }
                catch (CoreException coreException) {
                    CorePlugin.logError((Exception)((Object)coreException));
                }
                this.fhBuildListeners.put(string.replaceFirst("_buildtool", ""), buildListener);
            }
            catch (Exception exception) {
                CorePlugin.logError((Exception)exception);
            }
            ++n2;
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
        if (this.logView != null) {
            this.logView.setErrorMessageDisplayed(false);
        }
        this.fbMarkersRemoved = true;
        if (this.fMonitor != null && BuildHandler.isBuildRunning()) {
            this.fMonitor.subTask(Messages.getString((String)"BuildLogger.Build_Started_2"));
        }
        Enumeration enumeration = this.fhBuildListeners.elements();
        while (enumeration.hasMoreElements()) {
            BuildListener buildListener = (BuildListener)enumeration.nextElement();
            try {
                buildListener.buildStarted(buildEvent);
            }
            catch (Exception exception) {
                CorePlugin.logError((Exception)exception);
            }
        }
    }

    public void buildFinished(BuildEvent buildEvent) {
        Object object;
        Enumeration enumeration = this.fhBuildListeners.elements();
        while (enumeration.hasMoreElements()) {
            object = (BuildListener)enumeration.nextElement();
            try {
                object.buildFinished(buildEvent);
            }
            catch (Exception exception) {
                CorePlugin.logError((Exception)exception);
            }
        }
        object = null;
        if (this.fsExceptionMessages != null) {
            object = this.fsExceptionMessages.toString();
        }
        if (object != null) {
            object.length();
        }
        boolean bl = false;
        if (this.logView != null) {
            bl = this.logView.isErrorMessageDisplayed();
        }
        Throwable throwable = buildEvent.getException();
        if (!this.buildCancelled && !bl && BuildHandler.isBuildRunning()) {
            if (this.logView != null) {
                this.logView.logMessageInLogConsole(Messages.getString((String)"BuildLogger.Build_Successful_4"), 2, this.fPriorityFilter);
            }
        } else if (this.buildCancelled) {
            buildEvent.setException((Throwable)new OperationCanceledException());
            throwable = buildEvent.getException();
        }
        boolean bl2 = false;
        if (throwable != null) {
            String string = throwable.getMessage();
            String string2 = null;
            if (string != null && !string.equals("java.lang.reflect.InvocationTargetException")) {
                string2 = throwable.toString();
            }
            if (throwable instanceof OperationCanceledException) {
                if (this.logView != null && string != null) {
                    this.logView.logMessageInLogConsole(string, 2, this.fPriorityFilter);
                }
            } else if (throwable instanceof BuildCanceledException) {
                if (this.logView != null && string2 != null) {
                    this.logView.logMessageInLogConsole(string2, 2, this.fPriorityFilter);
                }
            } else {
                bl2 = true;
                if (this.logView != null && string2 != null) {
                    this.logView.logMessageInLogConsole(string2, 0, this.fPriorityFilter);
                }
            }
        }
        if ((bl || bl2) && BuildHandler.isBuildRunning()) {
            if (this.logView != null) {
                this.logView.logMessageInLogConsole(Messages.getString((String)"BuildLogger.Build_Failed_5"), 0, this.fPriorityFilter);
            }
            if (this.fbMarkersRemoved) {
                TaskViewhelper.getDefault().addProblemMarker("org.eclipse.cobol.core.problem", (IResource)this.fProject, Messages.getString((String)"BuildLogger.BuildFailed"), 2, 2, null, null, null);
                this.fbMarkersRemoved = false;
            }
        }
        this.logView.flush();
    }

    public void messageLogged(BuildEvent buildEvent) {
        String string;
        if (this.logView.toConsolePriority(buildEvent.getPriority()) <= 2 && (string = buildEvent.getMessage()) != null && string.length() > 0) {
            if (string.trim().startsWith("at ") && string.trim().endsWith(")")) {
                this.fsExceptionMessages.append(string);
                this.fsExceptionMessages.append(ICommonConstants.EOL);
            } else if (this.currentListener != null) {
                try {
                    this.currentListener.messageLogged(buildEvent);
                }
                catch (Exception exception) {
                    CorePlugin.logError((Exception)exception);
                }
            }
        }
    }

    public void targetStarted(BuildEvent buildEvent) {
        BuildListener buildListener;
        this.currentListener = buildListener = this.provideBuildListener(buildEvent);
        if (buildListener != null) {
            try {
                buildListener.targetStarted(buildEvent);
            }
            catch (Exception exception) {
                CorePlugin.logError((Exception)exception);
            }
        }
    }

    public void targetFinished(BuildEvent buildEvent) {
        BuildListener buildListener;
        if (this.fMonitor != null) {
            this.fMonitor.worked(1);
        }
        this.currentListener = buildListener = this.provideBuildListener(buildEvent);
        if (buildListener != null) {
            try {
                buildListener.targetFinished(buildEvent);
            }
            catch (Exception exception) {
                CorePlugin.logError((Exception)exception);
            }
        }
        if (this.logView != null) {
            this.logView.flush();
        }
    }

    public void taskStarted(BuildEvent buildEvent) {
        BuildListener buildListener;
        this.checkCanceled();
        Target target = buildEvent.getTarget();
        String string = target.getDescription();
        if (string != null && this.fMonitor != null) {
            this.fMonitor.subTask(string);
        }
        String string2 = String.valueOf(target.getName()) + string;
        if (string != null && string.length() > 0 && !this.alLoggedMessages.contains(string2) && this.logView != null) {
            this.logView.logMessageInLogConsole(string, 2, this.fPriorityFilter);
            this.alLoggedMessages.add(string2);
        }
        this.currentListener = buildListener = this.provideBuildListener(buildEvent);
        if (buildListener != null) {
            try {
                buildListener.taskStarted(buildEvent);
            }
            catch (Exception exception) {
                CorePlugin.logError((Exception)exception);
            }
        }
    }

    public void taskFinished(BuildEvent buildEvent) {
        BuildListener buildListener;
        this.checkCanceled();
        this.currentListener = buildListener = this.provideBuildListener(buildEvent);
        if (buildListener != null) {
            try {
                buildListener.taskFinished(buildEvent);
            }
            catch (Exception exception) {
                CorePlugin.logError((Exception)exception);
            }
        }
    }

    private void checkCanceled() {
        if (CorePlugin.getDefault().isAutoBuildRunning()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CobolBuildLogger.this.isCanceled();
                }
            });
        } else {
            this.isCanceled();
        }
    }

    public void isCanceled() throws BuildCanceledException {
        if (this.fMonitor != null && this.fMonitor.isCanceled()) {
            this.buildCancelled = true;
            throw new BuildCanceledException(Messages.getString((String)"BuildLogger.BuildCanceled"));
        }
    }

    private BuildListener provideBuildListener(BuildEvent buildEvent) {
        BuildListener buildListener = null;
        try {
            int n;
            if (buildEvent != null && buildEvent.getTarget() != null && buildEvent.getTarget().getName() != null && (n = buildEvent.getTarget().getName().indexOf("-")) >= 0) {
                String string = buildEvent.getTarget().getName().substring(0, n).trim();
                buildListener = (BuildListener)this.fhBuildListeners.get(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            CorePlugin.logError((Exception)nullPointerException);
        }
        catch (Exception exception) {
            CorePlugin.logError((Exception)exception);
        }
        return buildListener;
    }

    public void setEmacsMode(boolean bl) {
    }

    public void setErrorPrintStream(PrintStream printStream) {
    }

    public void setMessageOutputLevel(int n) {
        this.fPriorityFilter = this.logView.toConsolePriority(n);
    }

    public void setOutputPrintStream(PrintStream printStream) {
    }

    class BuildCanceledException
    extends BuildException {
        private static final long serialVersionUID = 1L;

        public BuildCanceledException() {
        }

        public BuildCanceledException(String string) {
            super(string);
        }
    }
}

