/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URI;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.epp.internal.mpc.core.util.TextUtil;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.wizards.DiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.util.WorkbenchUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareSolutionLink {
    private final CatalogItem catalogItem;
    private final Button control;

    public ShareSolutionLink(Composite parent, CatalogItem item) {
        this.catalogItem = item;
        this.control = ShareSolutionLink.createShareLink(parent);
        Menu popupMenu = this.createMenu((Control)this.control);
        ShareSolutionLink.attachMenu((Control)this.control, popupMenu);
    }

    public Control getControl() {
        return this.control;
    }

    private static Button createShareLink(Composite parent) {
        Button share = new Button(parent, 8);
        DiscoveryItem.setWidgetId((Widget)share, "share");
        share.setImage(MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("ITEM_ICON_SHARE"));
        share.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = Messages.ShareSolutionLink_Share;
            }
        });
        return share;
    }

    private Menu createMenu(Control control) {
        Menu popupMenu = new Menu(control);
        this.createTweetMenu(popupMenu);
        if (this.isMailSupported()) {
            this.createMailMenu(popupMenu);
        }
        return popupMenu;
    }

    private void createTweetMenu(Menu popupMenu) {
        MenuItem twitterItem = new MenuItem(popupMenu, 8);
        twitterItem.setText(Messages.ShareSolutionLink_Twitter);
        twitterItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String tweet = NLS.bind((String)Messages.ShareSolutionLink_tweet, (Object[])new Object[]{ShareSolutionLink.this.catalogItem.getName(), ShareSolutionLink.this.getUrl()});
                WorkbenchUtil.openUrl((String)("http://twitter.com/?status=" + tweet), (int)128);
            }
        });
    }

    private void createMailMenu(Menu popupMenu) {
        MenuItem mailItem = new MenuItem(popupMenu, 8);
        mailItem.setText(Messages.ShareSolutionLink_EMail);
        mailItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ShareSolutionLink.this.openNewMail();
            }
        });
    }

    protected void openNewMail() {
        String subject = NLS.bind((String)Messages.ShareSolutionLink_mailSubject, (Object[])new Object[]{this.catalogItem.getName()});
        String body = this.computeMessage();
        String recipient = Messages.ShareSolutionLink_recipient;
        String mailToString = "mailto:" + recipient + "?subject=" + subject + "&body=" + body;
        try {
            URI uri = URIUtil.fromString((String)mailToString);
            this.openMail(uri);
        }
        catch (Exception e) {
            boolean copyToClipboard = MessageDialog.openQuestion((Shell)WorkbenchUtil.getShell(), (String)Messages.ShareSolutionLink_share, (String)Messages.ShareSolutionLink_failed_to_open_manually_share);
            if (copyToClipboard) {
                Clipboard clipboard = new Clipboard(this.control.getDisplay());
                TextTransfer textTransfer = TextTransfer.getInstance();
                Transfer[] transfers = new Transfer[]{textTransfer};
                Object[] data = new Object[]{body};
                clipboard.setContents(data, transfers);
                clipboard.dispose();
            }
            MarketplaceClientUi.error(e);
        }
    }

    private String computeMessage() {
        String description = this.catalogItem.getDescription() == null ? "" : this.catalogItem.getDescription();
        description = TextUtil.stripHtmlMarkup((String)this.catalogItem.getDescription()).trim();
        return String.valueOf(this.catalogItem.getName()) + "\n" + this.getUrl() + "\n\n" + description;
    }

    private String getUrl() {
        return ((INode)this.catalogItem.getData()).getUrl();
    }

    private void openMail(URI uri) throws Exception {
        Class<?> desktopClazz = this.getDesktopClazz();
        Method getDesktopMethod = desktopClazz.getMethod("getDesktop", new Class[0]);
        Object desktop = getDesktopMethod.invoke(null, new Object[0]);
        Method mailMethod = desktopClazz.getMethod("mail", URI.class);
        mailMethod.invoke(desktop, uri);
    }

    private boolean isMailSupported() {
        Class<?> actionEnum;
        Object desktop;
        boolean isDesktopSupported;
        block5: {
            try {
                Class<?> desktopClazz = this.getDesktopClazz();
                Method isDesktopSupportedMethod = desktopClazz.getMethod("isDesktopSupported", new Class[0]);
                isDesktopSupported = (Boolean)isDesktopSupportedMethod.invoke(null, new Object[0]);
                Method getDesktopMethod = desktopClazz.getMethod("getDesktop", new Class[0]);
                desktop = getDesktopMethod.invoke(null, new Object[0]);
                Class<?>[] classes = desktopClazz.getClasses();
                actionEnum = null;
                Class<?>[] classArray = classes;
                int n = classes.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> innerClass = classArray[n2];
                    if (innerClass.getName().equals("java.awt.Desktop$Action")) {
                        actionEnum = innerClass;
                    }
                    ++n2;
                }
                if (actionEnum != null) break block5;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        Method isSupportedMethod = desktop.getClass().getMethod("isSupported", actionEnum);
        Field mailEnumOption = actionEnum.getDeclaredField("MAIL");
        boolean isMailSupported = (Boolean)isSupportedMethod.invoke(desktop, mailEnumOption.get(null));
        return isDesktopSupported && isMailSupported;
    }

    private Class<?> getDesktopClazz() throws ClassNotFoundException {
        Class<?> desktopClazz = this.getClass().getClassLoader().loadClass("java.awt.Desktop");
        return desktopClazz;
    }

    private static void attachMenu(Control shareControl, final Menu popupMenu) {
        shareControl.setMenu(popupMenu);
        shareControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                popupMenu.setVisible(true);
            }
        });
    }

    public void setShowText(boolean showText) {
        if (showText) {
            this.control.setText(Messages.DiscoveryItem_Share);
        } else {
            this.control.setText("");
        }
    }
}

