/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectUtils {
    public static boolean compareParameterList(Class<?>[] classArray, Object[] objectArray) {
        int n = classArray != null ? classArray.length : 0;
        int n2 = objectArray != null ? objectArray.length : 0;
        boolean bl = true;
        if (n == n2) {
            for (int i = 0; i < n2; ++i) {
                if (objectArray[i] instanceof Integer) {
                    if (ReflectUtils.isIntType(classArray[i])) continue;
                    bl = false;
                } else if (objectArray[i] instanceof Byte) {
                    if (ReflectUtils.isByteType(classArray[i])) continue;
                    bl = false;
                } else if (objectArray[i] instanceof Short) {
                    if (ReflectUtils.isShortType(classArray[i])) continue;
                    bl = false;
                } else if (objectArray[i] instanceof Character) {
                    if (ReflectUtils.isCharType(classArray[i])) continue;
                    bl = false;
                } else if (objectArray[i] instanceof Long) {
                    if (ReflectUtils.isLongType(classArray[i])) continue;
                    bl = false;
                } else if (objectArray[i] instanceof Float) {
                    if (ReflectUtils.isFloatType(classArray[i])) continue;
                    bl = false;
                } else if (objectArray[i] instanceof Double) {
                    if (ReflectUtils.isDoubleType(classArray[i])) continue;
                    bl = false;
                } else if (objectArray[i] instanceof Boolean) {
                    if (ReflectUtils.isBooleanType(classArray[i])) continue;
                    bl = false;
                } else {
                    if (classArray[i].isAssignableFrom(objectArray[i].getClass())) continue;
                    bl = false;
                }
                break;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static boolean isByteType(Class<?> clazz) {
        return clazz.isAssignableFrom(Byte.TYPE) || clazz.isAssignableFrom(Byte.class);
    }

    private static boolean isIntType(Class<?> clazz) {
        return clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(Integer.class);
    }

    private static boolean isLongType(Class<?> clazz) {
        return clazz.isAssignableFrom(Long.TYPE) || clazz.isAssignableFrom(Long.class);
    }

    private static boolean isShortType(Class<?> clazz) {
        return clazz.isAssignableFrom(Short.TYPE) || clazz.isAssignableFrom(Short.class);
    }

    private static boolean isDoubleType(Class<?> clazz) {
        return clazz.isAssignableFrom(Double.TYPE) || clazz.isAssignableFrom(Double.class);
    }

    private static boolean isFloatType(Class<?> clazz) {
        return clazz.isAssignableFrom(Float.TYPE) || clazz.isAssignableFrom(Float.class);
    }

    private static boolean isBooleanType(Class<?> clazz) {
        return clazz.isAssignableFrom(Boolean.TYPE) || clazz.isAssignableFrom(Boolean.class);
    }

    private static boolean isCharType(Class<?> clazz) {
        return clazz.isAssignableFrom(Character.TYPE) || clazz.isAssignableFrom(Character.class);
    }
}

