/*
 * Decompiled with CFR 0.152.
 */
package com.unisys.comm.data;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class FormattedBuffer {
    private static final int BYTE_TRUE = 1;
    private static final int BYTE_FALSE = 0;
    public static final int BYTES_PER_UNICODE_CHAR = 2;
    private static final int DESCRIPTOR_LEN = 5;
    public static final int BYTE_TYPE = 1;
    public static final int SHORT_TYPE = 2;
    public static final int INT_TYPE = 3;
    public static final int LONG_TYPE = 4;
    public static final int BOOLEAN_TYPE = 5;
    public static final int ASCII_STRING_TYPE = 6;
    public static final int STRING_TYPE = 7;
    public static final int BYTE_ARRAY_TYPE = 8;
    public static final int UNICODE_STRING_TYPE = 9;
    public static final int BIG_DECIMAL_TYPE = 10;
    public static final int BIG_INTEGER_TYPE = 11;
    public static final int FLOAT_TYPE = 12;
    public static final int DOUBLE_TYPE = 13;
    public static final int LIST_TYPE = 14;
    public static final int MAP_TYPE = 15;
    public static final int VOID_TYPE = 16;
    public static final int NULL_TYPE = 17;
    public static final int FLOAT_S_TYPE = 18;
    public static final int DOUBLE_S_TYPE = 19;
    public static final int REPEATER_TYPE = 32;
    public static final int GROUP_TYPE = 64;
    public static final int ODO_ITEM_TYPE = 65;
    public static final int OBJECT_TYPE = 70;
    public static final int FIELD_TYPE = 71;
    public static final int BAD_ITEM_VALUE_INDICATOR = 100;
    public static final int BYTE_LEN = 1;
    public static final int SHORT_LEN = 2;
    public static final int INT_LEN = 4;
    public static final int LONG_LEN = 8;
    public static final int BOOLEAN_LEN = 1;
    public static final int DOUBLE_LEN = 8;
    public static final int FLOAT_LEN = 4;
    public static final int BIG_DECIMAL_LEN = 12;
    public static final int BIG_INTEGER_LEN = 9;
    public static final int DEFAULT_REALLOCATION_SIZE = 8192;
    private byte[] formattedBuffer;
    private int offset = 0;
    private int bufferSize;
    private int reallocateSize;

    public FormattedBuffer(int n) {
        this.bufferSize = n;
        this.offset = 0;
        this.formattedBuffer = new byte[this.bufferSize];
        this.reallocateSize = 8192;
    }

    public FormattedBuffer(byte[] byArray, int n, int n2) {
        this.formattedBuffer = byArray;
        this.bufferSize = n;
        this.offset = n2;
        this.reallocateSize = 8192;
    }

    public final byte[] getFormattedBuffer() {
        return this.formattedBuffer;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int n) {
        this.offset = n;
    }

    public final int getReallocateSize() {
        return this.reallocateSize;
    }

    public final void setReallocateSize(int n) {
        this.reallocateSize = n;
    }

    public final String getASCIIStringArg() {
        int n = this.getArgLength();
        String string = this.getASCIIStringData(n, this.offset + 5);
        this.movePastArg();
        return string;
    }

    public final BigDecimal getBigDecimalArg() {
        BigDecimal bigDecimal = this.getBigDecimalData(this.offset + 5);
        this.movePastArg();
        return bigDecimal;
    }

    public final BigInteger getBigIntegerArg() {
        int n = this.getArgLength();
        BigInteger bigInteger = this.getBigIntegerData(n, this.offset + 5);
        this.movePastArg();
        return bigInteger;
    }

    public final boolean getBooleanArg() {
        boolean bl = this.getBooleanData(this.offset + 5);
        this.movePastArg();
        return bl;
    }

    public final byte getByteArg() {
        byte by = this.getByteData(this.offset + 5);
        this.movePastArg();
        return by;
    }

    public final byte[] getByteArrayArg() {
        int n = this.getArgLength();
        byte[] byArray = this.getByteArrayData(n, this.offset + 5);
        this.movePastArg();
        return byArray;
    }

    public final byte[] getByteArrayArg(String string) throws UnsupportedEncodingException {
        int n = this.getArgLength();
        byte[] byArray = this.getByteArrayData(n, string, this.offset + 5);
        this.movePastArg();
        return byArray;
    }

    public final double getDoubleArg() {
        double d = this.getDoubleData(this.offset + 5);
        this.movePastArg();
        return d;
    }

    public final double getDoubleSArg() throws NumberFormatException {
        int n = this.getArgLength();
        String string = this.getASCIIStringData(n, this.offset + 5);
        this.movePastArg();
        return Double.parseDouble(string);
    }

    public final String getFieldArg(String string) throws UnsupportedEncodingException {
        int n = this.getArgLength();
        String string2 = this.getStringData(n, string, this.offset + 5);
        this.movePastArg();
        return string2;
    }

    public final float getFloatArg() {
        float f = this.getFloatData(this.offset + 5);
        this.movePastArg();
        return f;
    }

    public final float getFloatSArg() throws NumberFormatException {
        int n = this.getArgLength();
        String string = this.getASCIIStringData(n, this.offset + 5);
        this.movePastArg();
        return Float.parseFloat(string);
    }

    public final int getGroupArg() {
        int n = this.getIntData(this.offset + 5);
        this.movePastArg();
        return n;
    }

    public final int getIntArg() {
        int n = this.getIntData(this.offset + 5);
        this.movePastArg();
        return n;
    }

    public final int getListArg() {
        int n = this.getIntData(this.offset + 5);
        this.movePastArg();
        return n;
    }

    public final long getLongArg() {
        long l = this.getLongData(this.offset + 5);
        this.movePastArg();
        return l;
    }

    public final int getMapArg() {
        int n = this.getIntData(this.offset + 5);
        this.movePastArg();
        return n;
    }

    public final int getObjectArg() {
        int n = this.getIntData(this.offset + 5);
        this.movePastArg();
        return n;
    }

    public final int getODOItemArg() {
        int n = this.getIntData(this.offset + 5);
        this.movePastArg();
        return n;
    }

    public final int getRepeaterArg() {
        int n = this.getIntData(this.offset + 5);
        this.movePastArg();
        return n;
    }

    public final short getShortArg() {
        short s = this.getShortData(this.offset + 5);
        this.movePastArg();
        return s;
    }

    public final String getStringArg(String string) throws UnsupportedEncodingException {
        int n = this.getArgLength();
        String string2 = this.getStringData(n, string, this.offset + 5);
        this.movePastArg();
        return string2;
    }

    public final String getUnicodeStringArg() {
        int n = this.getArgLength();
        int n2 = n / 2;
        String string = this.getUnicodeStringData(n2, this.offset + 5);
        this.movePastArg();
        return string;
    }

    public final void putBadItemValueArg(byte by) {
        this.putArgDescriptor(by + 100, 0);
    }

    public final void putASCIIStringArg(String string) {
        this.putArgDescriptor(6, string.length());
        int n = this.putASCIIStringData(string, this.offset);
        this.offset += n;
    }

    public final void putBigDecimalArg(BigDecimal bigDecimal) {
        this.putArgDescriptor(10, 12);
        int n = this.putBigDecimalData(bigDecimal, this.offset);
        this.offset += n;
    }

    public final void putBigIntegerArg(BigInteger bigInteger) {
        this.putArgDescriptor(11, 9);
        int n = this.putBigIntegerData(bigInteger, this.offset);
        this.offset += n;
    }

    public final void putBooleanArg(boolean bl) {
        this.putArgDescriptor(5, 1);
        int n = this.putBooleanData(bl, this.offset);
        this.offset += n;
    }

    public final void putByteArg(byte by) {
        this.putArgDescriptor(1, 1);
        int n = this.putByteData(by, this.offset);
        this.offset += n;
    }

    public final void putByteArrayArg(byte[] byArray) {
        this.putArgDescriptor(8, byArray.length);
        int n = this.putByteArrayData(byArray, this.offset);
        this.offset += n;
    }

    public final void putByteArrayArg(byte[] byArray, String string) throws UnsupportedEncodingException {
        this.putArgDescriptor(8, byArray.length);
        int n = this.putByteArrayData(byArray, byArray.length, string, this.offset);
        this.offset += n;
    }

    public final void putDoubleArg(double d) {
        this.putArgDescriptor(13, 8);
        int n = this.putDoubleData(d, this.offset);
        this.offset += n;
    }

    public final void putDoubleSArg(double d) {
        String string = Double.toString(d);
        this.putArgDescriptor(19, string.length());
        int n = this.putASCIIStringData(string, this.offset);
        this.offset += n;
    }

    public final void putFieldArg(String string, String string2) throws UnsupportedEncodingException {
        this.putArgDescriptor(71, string.length());
        int n = this.putStringData(string, string2, this.offset);
        this.offset += n;
    }

    public final void putFloatArg(float f) {
        this.putArgDescriptor(12, 4);
        int n = this.putFloatData(f, this.offset);
        this.offset += n;
    }

    public final void putFloatSArg(float f) {
        String string = Float.toString(f);
        this.putArgDescriptor(18, string.length());
        int n = this.putASCIIStringData(string, this.offset);
        this.offset += n;
    }

    public final void putGroupArg(int n) {
        this.putArgDescriptor(64, 4);
        int n2 = this.putIntData(n, this.offset);
        this.offset += n2;
    }

    public final void putIntArg(int n) {
        this.putArgDescriptor(3, 4);
        int n2 = this.putIntData(n, this.offset);
        this.offset += n2;
    }

    public final void putListArg(int n) {
        this.putArgDescriptor(14, 4);
        int n2 = this.putIntData(n, this.offset);
        this.offset += n2;
    }

    public final void putLongArg(long l) {
        this.putArgDescriptor(4, 8);
        int n = this.putLongData(l, this.offset);
        this.offset += n;
    }

    public final void putMapArg(int n) {
        this.putArgDescriptor(15, 4);
        int n2 = this.putIntData(n, this.offset);
        this.offset += n2;
    }

    public final void putNullArg() {
        this.putArgDescriptor(17, 0);
    }

    public final void putShortArg(short s) {
        this.putArgDescriptor(2, 2);
        int n = this.putShortData(s, this.offset);
        this.offset += n;
    }

    public final void putObjectArg(int n) {
        this.putArgDescriptor(70, 4);
        int n2 = this.putIntData(n, this.offset);
        this.offset += n2;
    }

    public final void putODOItemArg(int n) {
        this.putArgDescriptor(65, 4);
        int n2 = this.putIntData(n, this.offset);
        this.offset += n2;
    }

    public final void putRepeaterArg(int n) {
        this.putArgDescriptor(32, 4);
        int n2 = this.putIntData(n, this.offset);
        this.offset += n2;
    }

    public final void putStringArg(String string, String string2) throws UnsupportedEncodingException {
        this.putArgDescriptor(7, string.length());
        int n = this.putStringData(string, string2, this.offset);
        this.offset += n;
    }

    public final void putStringBytesArg(byte[] byArray) {
        this.putArgDescriptor(7, byArray.length);
        int n = this.putByteArrayData(byArray, this.offset);
        this.offset += n;
    }

    public final void putUnicodeStringArg(String string) {
        int n = string.length();
        int n2 = n * 2;
        this.putArgDescriptor(9, n2);
        int n3 = this.putUnicodeStringData(string, this.offset);
        this.offset += n3;
    }

    public final void putVoidArg() {
        this.putArgDescriptor(16, 0);
    }

    public final String getASCIIStringData(int n) {
        String string = this.getASCIIStringData(n, this.offset);
        this.offset += n;
        return string;
    }

    protected final String getASCIIStringData(int n, int n2) {
        String string = null;
        try {
            string = new String(this.formattedBuffer, n2, n, "ISO8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    public final BigDecimal getBigDecimalData() {
        BigDecimal bigDecimal = this.getBigDecimalData(this.offset);
        this.offset += 12;
        return bigDecimal;
    }

    protected final BigDecimal getBigDecimalData(int n) {
        Long l = this.getLongData(n);
        int n2 = this.getIntData(n + 8);
        BigDecimal bigDecimal = new BigDecimal(new BigInteger(l.toString()), n2);
        return bigDecimal;
    }

    public final BigInteger getBigIntegerData(int n) {
        BigInteger bigInteger = this.getBigIntegerData(n, this.offset);
        this.offset += 9;
        return bigInteger;
    }

    protected final BigInteger getBigIntegerData(int n, int n2) {
        byte[] byArray = this.getByteArrayData(n, n2);
        BigInteger bigInteger = new BigInteger(byArray);
        return bigInteger;
    }

    public final boolean getBooleanData() {
        boolean bl = this.getBooleanData(this.offset);
        ++this.offset;
        return bl;
    }

    protected final boolean getBooleanData(int n) {
        boolean bl = true;
        if (this.formattedBuffer[n] == 0) {
            bl = false;
        }
        return bl;
    }

    public final byte[] getByteArrayData(int n) {
        byte[] byArray = this.getByteArrayData(n, this.offset);
        this.offset += n;
        return byArray;
    }

    protected final byte[] getByteArrayData(int n, int n2) {
        byte[] byArray = new byte[n];
        System.arraycopy(this.formattedBuffer, n2, byArray, 0, n);
        return byArray;
    }

    public final byte[] getByteArrayData(int n, String string) throws UnsupportedEncodingException {
        byte[] byArray = this.getByteArrayData(n, string, this.offset);
        this.offset += n;
        return byArray;
    }

    protected final byte[] getByteArrayData(int n, String string, int n2) throws UnsupportedEncodingException {
        String string2 = new String(this.formattedBuffer, n2, n, string);
        return string2.getBytes();
    }

    public final byte getByteData() {
        byte by = this.getByteData(this.offset);
        ++this.offset;
        return by;
    }

    protected final byte getByteData(int n) {
        return this.formattedBuffer[n];
    }

    protected final char getCharData(int n) {
        int n2 = this.formattedBuffer[n] << 8 & 0xFF00;
        int n3 = this.formattedBuffer[n + 1] & 0xFF;
        return (char)(n2 | n3);
    }

    public final double getDoubleData() {
        double d = this.getDoubleData(this.offset);
        this.offset += 8;
        return d;
    }

    protected final double getDoubleData(int n) {
        long l = this.getLongData(n);
        double d = Double.longBitsToDouble(l);
        return d;
    }

    public final float getFloatData() {
        float f = this.getFloatData(this.offset);
        this.offset += 4;
        return f;
    }

    protected final float getFloatData(int n) {
        int n2 = this.getIntData(n);
        float f = Float.intBitsToFloat(n2);
        return f;
    }

    public final int getIntData() {
        int n = this.getIntData(this.offset);
        this.offset += 4;
        return n;
    }

    protected final int getIntData(int n) {
        int n2 = this.formattedBuffer[n] << 24 & 0xFF000000;
        int n3 = this.formattedBuffer[n + 1] << 16 & 0xFF0000;
        int n4 = this.formattedBuffer[n + 2] << 8 & 0xFF00;
        int n5 = this.formattedBuffer[n + 3] & 0xFF;
        return n2 | n3 | n4 | n5;
    }

    public final long getLongData() {
        long l = this.getLongData(this.offset);
        this.offset += 8;
        return l;
    }

    protected final long getLongData(int n) {
        long l = (long)this.formattedBuffer[n] << 56 & 0xFF00000000000000L;
        long l2 = (long)this.formattedBuffer[n + 1] << 48 & 0xFF000000000000L;
        long l3 = (long)this.formattedBuffer[n + 2] << 40 & 0xFF0000000000L;
        long l4 = (long)this.formattedBuffer[n + 3] << 32 & 0xFF00000000L;
        long l5 = (long)this.formattedBuffer[n + 4] << 24 & 0xFF000000L;
        long l6 = (long)this.formattedBuffer[n + 5] << 16 & 0xFF0000L;
        long l7 = (long)this.formattedBuffer[n + 6] << 8 & 0xFF00L;
        long l8 = (long)this.formattedBuffer[n + 7] & 0xFFL;
        return l | l2 | l3 | l4 | l5 | l6 | l7 | l8;
    }

    public final short getShortData() {
        short s = this.getShortData(this.offset);
        this.offset += 2;
        return s;
    }

    protected final short getShortData(int n) {
        int n2 = this.formattedBuffer[n] << 8 & 0xFF00;
        int n3 = this.formattedBuffer[n + 1] & 0xFF;
        return (short)(n2 | n3);
    }

    public final String getStringData(int n, String string) throws UnsupportedEncodingException {
        String string2 = this.getStringData(n, string, this.offset);
        this.offset += n;
        return string2;
    }

    protected final String getStringData(int n, String string, int n2) throws UnsupportedEncodingException {
        String string2 = new String(this.formattedBuffer, n2, n, string);
        return string2;
    }

    public final String getUnicodeStringData(int n) {
        String string = this.getUnicodeStringData(n, this.offset);
        this.offset += n * 2;
        return string;
    }

    protected final String getUnicodeStringData(int n, int n2) {
        char[] cArray = new char[n];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = this.getCharData(n2 + i * 2);
        }
        return new String(cArray);
    }

    public final void putASCIIStringData(String string) {
        int n = this.putASCIIStringData(string, this.offset);
        this.offset += n;
    }

    protected final int putASCIIStringData(String string, int n) {
        byte[] byArray = null;
        int n2 = 0;
        try {
            byArray = string.getBytes("ISO8859-1");
            n2 = byArray.length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.dynamicBufferExpander(n2);
        System.arraycopy(byArray, 0, this.formattedBuffer, n, n2);
        return n2;
    }

    public final void putBigDecimalData(BigDecimal bigDecimal) {
        int n = this.putBigDecimalData(bigDecimal, this.offset);
        this.offset += n;
    }

    protected final int putBigDecimalData(BigDecimal bigDecimal, int n) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        int n2 = bigDecimal.scale();
        this.dynamicBufferExpander(12);
        this.putLongData(bigInteger.longValue(), n);
        this.putIntData(n2, n + 8);
        return 12;
    }

    public final void putBigIntegerData(BigInteger bigInteger) {
        int n = this.putBigIntegerData(bigInteger, this.offset);
        this.offset += n;
    }

    protected final int putBigIntegerData(BigInteger bigInteger, int n) {
        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] byArray2 = bigInteger.toByteArray();
        int n2 = 9 - byArray2.length;
        System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
        int n3 = this.putByteArrayData(byArray, n);
        return n3;
    }

    public final void putBooleanData(boolean bl) {
        int n = this.putBooleanData(bl, this.offset);
        this.offset += n;
    }

    protected final int putBooleanData(boolean bl, int n) {
        this.dynamicBufferExpander(1);
        this.formattedBuffer[n] = bl ? (byte)1 : 0;
        return 1;
    }

    public final void putByteArrayData(byte[] byArray) {
        int n = this.putByteArrayData(byArray, this.offset);
        this.offset += n;
    }

    protected final int putByteArrayData(byte[] byArray, int n) {
        int n2 = byArray.length;
        this.dynamicBufferExpander(n2);
        System.arraycopy(byArray, 0, this.formattedBuffer, n, n2);
        return n2;
    }

    public final void putByteArrayData(byte[] byArray, String string) throws UnsupportedEncodingException {
        int n = this.putByteArrayData(byArray, byArray.length, string, this.offset);
        this.offset += n;
    }

    public final void putByteArrayData(byte[] byArray, int n, String string) throws UnsupportedEncodingException {
        int n2 = this.putByteArrayData(byArray, n, string, this.offset);
        this.offset += n2;
    }

    protected final int putByteArrayData(byte[] byArray, int n, String string, int n2) throws UnsupportedEncodingException {
        byte[] byArray2 = new String(byArray, 0, n).getBytes(string);
        this.dynamicBufferExpander(n);
        System.arraycopy(byArray2, 0, this.formattedBuffer, n2, n);
        return n;
    }

    public final void putByteData(byte by) {
        int n = this.putByteData(by, this.offset);
        this.offset += n;
    }

    protected final int putByteData(byte by, int n) {
        this.dynamicBufferExpander(1);
        this.formattedBuffer[n] = by;
        return 1;
    }

    public final void putDoubleData(double d) {
        int n = this.putDoubleData(d, this.offset);
        this.offset += n;
    }

    protected final int putDoubleData(double d, int n) {
        long l = Double.doubleToRawLongBits(d);
        int n2 = this.putLongData(l, n);
        return n2;
    }

    public final void putFloatData(float f) {
        int n = this.putFloatData(f, this.offset);
        this.offset += n;
    }

    protected final int putFloatData(float f, int n) {
        int n2 = Float.floatToRawIntBits(f);
        int n3 = this.putIntData(n2, n);
        return n3;
    }

    public final void putIntData(int n) {
        int n2 = this.putIntData(n, this.offset);
        this.offset += n2;
    }

    protected final int putIntData(int n, int n2) {
        this.dynamicBufferExpander(4);
        this.formattedBuffer[n2] = (byte)(n >> 24);
        this.formattedBuffer[n2 + 1] = (byte)(n >> 16);
        this.formattedBuffer[n2 + 2] = (byte)(n >> 8);
        this.formattedBuffer[n2 + 3] = (byte)n;
        return 4;
    }

    public final void putLongData(long l) {
        int n = this.putLongData(l, this.offset);
        this.offset += n;
    }

    protected final int putLongData(long l, int n) {
        this.dynamicBufferExpander(8);
        this.formattedBuffer[n] = (byte)(l >> 56);
        this.formattedBuffer[n + 1] = (byte)(l >> 48);
        this.formattedBuffer[n + 2] = (byte)(l >> 40);
        this.formattedBuffer[n + 3] = (byte)(l >> 32);
        this.formattedBuffer[n + 4] = (byte)(l >> 24);
        this.formattedBuffer[n + 5] = (byte)(l >> 16);
        this.formattedBuffer[n + 6] = (byte)(l >> 8);
        this.formattedBuffer[n + 7] = (byte)l;
        return 8;
    }

    public final void putNULTerminatedASCIIStringData(String string) {
        int n = this.putNULTerminatedASCIIStringData(string, this.offset);
        this.offset += n;
    }

    protected final int putNULTerminatedASCIIStringData(String string, int n) {
        int n2 = this.putASCIIStringData(string, n);
        int n3 = this.putByteData((byte)0, n + n2);
        return n2 + n3;
    }

    public final void putShortData(short s) {
        int n = this.putShortData(s, this.offset);
        this.offset += n;
    }

    protected final int putShortData(short s, int n) {
        this.dynamicBufferExpander(2);
        this.formattedBuffer[n] = (byte)(s >> 8);
        this.formattedBuffer[n + 1] = (byte)s;
        return 2;
    }

    public final void putStringData(String string, String string2) throws UnsupportedEncodingException {
        int n = this.putStringData(string, string2, this.offset);
        this.offset += n;
    }

    protected final int putStringData(String string, String string2, int n) throws UnsupportedEncodingException {
        byte[] byArray = string.getBytes(string2);
        int n2 = byArray.length;
        this.dynamicBufferExpander(n2);
        System.arraycopy(byArray, 0, this.formattedBuffer, n, n2);
        return n2;
    }

    public final void putUnicodeStringData(String string) {
        int n = this.putUnicodeStringData(string, this.offset);
        this.offset += n;
    }

    protected final int putUnicodeStringData(String string, int n) {
        int n2 = string.length();
        int n3 = n2 * 2;
        this.dynamicBufferExpander(n3);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            this.formattedBuffer[n + i * 2] = (byte)(c >> 8);
            this.formattedBuffer[n + i * 2 + 1] = (byte)c;
        }
        return n3;
    }

    public static final int getBigDecimalArgLength() {
        return 17;
    }

    public static final int getBigIntegerArgLength() {
        return 14;
    }

    public static final int getBooleanArgLength() {
        return 6;
    }

    public static final int getByteArgLength() {
        return 6;
    }

    public static final int getByteArrayArgLength(byte[] byArray) {
        return byArray.length + 5;
    }

    public static final int getDoubleArgLength() {
        return 13;
    }

    public static final int getDoubleSArgLength(double d) {
        String string = Double.toString(d);
        return string.length() + 5;
    }

    public static final int getFieldArgLength(String string) {
        return string.length() + 5;
    }

    public static final int getFloatArgLength() {
        return 9;
    }

    public static final int getFloatSArgLength(float f) {
        String string = Float.toString(f);
        return string.length() + 5;
    }

    public static final int getGroupArgLength() {
        return 9;
    }

    public static final int getIntArgLength() {
        return 9;
    }

    public static final int getListArgLength() {
        return 9;
    }

    public static final int getLongArgLength() {
        return 13;
    }

    public static final int getMapArgLength() {
        return 9;
    }

    public static final int getNullArgLength() {
        return 5;
    }

    public static final int getObjectArgLength() {
        return 9;
    }

    public static final int getODOItemArgLength() {
        return 9;
    }

    public static final int getRepeaterArgLength() {
        return 9;
    }

    public static final int getShortArgLength() {
        return 7;
    }

    public static final int getStringArgLength(String string) {
        return string.length() + 5;
    }

    public static final int getVoidArgLength() {
        return 5;
    }

    public final byte getArgType() {
        return this.getByteData(this.offset);
    }

    public final int getArgLength() {
        return this.getIntData(this.offset + 1);
    }

    private final void putArgDescriptor(int n, int n2) {
        this.dynamicBufferExpander(5);
        this.putByteData((byte)n, this.offset);
        this.putIntData(n2, this.offset + 1);
        this.offset += 5;
    }

    protected final int movePastArg() {
        int n = this.getArgLength();
        this.offset += n + 5;
        return 5 + n;
    }

    private final void dynamicBufferExpander(int n) {
        if (this.offset + n > this.bufferSize) {
            int n2 = this.bufferSize + Math.max(this.reallocateSize, n);
            byte[] byArray = new byte[n2];
            System.arraycopy(this.formattedBuffer, 0, byArray, 0, this.offset);
            this.formattedBuffer = byArray;
            this.bufferSize = byArray.length;
        }
    }
}

