/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.builders.BuildErrorReporter;
import org.eclipse.pde.internal.core.project.PDEProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceEntryErrorReporter
extends BuildErrorReporter {
    private static final String DEF_OUTPUT_ENTRY = "output..";
    private HashMap<IPath, SourceFolder> fSourceFolderMap = new HashMap(4);
    private HashMap<IPath, OutputFolder> fOutputFolderMap = new HashMap(4);
    private IBuild fBuild = null;
    Map<String, String> fDefaultLibraryEncodings = new HashMap<String, String>();
    Map<String, List<EncodingEntry>> fCustomEncodings = new HashMap<String, List<EncodingEntry>>();

    public SourceEntryErrorReporter(IFile file, IBuild model) {
        super(file);
        this.fBuild = model;
    }

    public void initialize(ArrayList<?> sourceEntries, ArrayList<?> outputEntries, IClasspathEntry[] cpes, IProject project) {
        IPath path;
        String[] tokens;
        String libName;
        this.fProject = project;
        IPath defaultOutputLocation = null;
        IJavaProject javaProject = JavaCore.create((IProject)this.fProject);
        try {
            defaultOutputLocation = javaProject.getOutputLocation();
        }
        catch (JavaModelException javaModelException) {}
        ArrayList<String> pluginLibraryNames = new ArrayList<String>(1);
        IPluginModelBase pluginModel = PluginRegistry.findModel(this.fProject);
        if (pluginModel != null) {
            IPluginLibrary[] pluginLibraries = pluginModel.getPluginBase().getLibraries();
            int i = 0;
            while (i < pluginLibraries.length) {
                pluginLibraryNames.add(pluginLibraries[i].getName());
                ++i;
            }
        }
        if (!pluginLibraryNames.contains(".")) {
            pluginLibraryNames.add(".");
        }
        int i = 0;
        while (i < cpes.length) {
            IPath outputPath;
            OutputFolder outputFolder;
            if (cpes[i].getEntryKind() == 3) {
                IPath sourcePath = this.getPath(cpes[i]);
                if (sourcePath != null) {
                    SourceFolder sourceFolder;
                    IPath outputLocation = cpes[i].getOutputLocation();
                    if (outputLocation == null) {
                        outputLocation = defaultOutputLocation;
                    }
                    if ((outputFolder = this.fOutputFolderMap.get(outputPath = this.getPath(outputLocation))) == null) {
                        outputFolder = new OutputFolder(outputPath);
                    }
                    if ((sourceFolder = this.fSourceFolderMap.get(sourcePath)) == null) {
                        sourceFolder = new SourceFolder(sourcePath, outputFolder);
                    }
                    outputFolder.addSourceFolder(sourceFolder);
                    this.fOutputFolderMap.put(outputPath, outputFolder);
                    this.fSourceFolderMap.put(sourcePath, sourceFolder);
                }
            } else if (cpes[i].getEntryKind() == 1) {
                IClasspathEntry entry = cpes[i];
                IPackageFragmentRoot[] roots = javaProject.findPackageFragmentRoots(entry);
                outputPath = null;
                if (roots.length == 1 && !roots[0].isArchive()) {
                    outputPath = this.getPath(entry);
                    outputFolder = new OutputFolder(outputPath, true);
                    this.fOutputFolderMap.put(outputPath, outputFolder);
                }
            }
            ++i;
        }
        for (IBuildEntry sourceEntry : sourceEntries) {
            libName = sourceEntry.getName().substring("source.".length());
            if (!pluginLibraryNames.contains(libName)) {
                this.prepareError(sourceEntry.getName(), null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingLibrary, (Object)libName), 8197, this.fSrcLibSeverity, "");
            }
            tokens = sourceEntry.getTokens();
            int i2 = 0;
            while (i2 < tokens.length) {
                path = new Path(tokens[i2]).addTrailingSeparator();
                SourceFolder sourceFolder = this.fSourceFolderMap.get(path);
                if (sourceFolder == null) {
                    sourceFolder = new SourceFolder(path, null);
                    this.fSourceFolderMap.put(path, sourceFolder);
                }
                sourceFolder.setToken(tokens[i2]);
                sourceFolder.addLib(libName);
                ++i2;
            }
        }
        for (IBuildEntry outputEntry : outputEntries) {
            libName = outputEntry.getName().substring("output.".length());
            if (!pluginLibraryNames.contains(libName)) {
                this.prepareError(outputEntry.getName(), null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingLibrary, (Object)libName), 8197, this.fOututLibSeverity, "");
            }
            tokens = outputEntry.getTokens();
            int i3 = 0;
            while (i3 < tokens.length) {
                OutputFolder outputFolder;
                path = new Path(tokens[i3]).addTrailingSeparator();
                if (path.segmentCount() == 1 && path.segment(0).equals(".")) {
                    path = Path.ROOT;
                }
                if ((outputFolder = this.fOutputFolderMap.get(path)) == null) {
                    outputFolder = new OutputFolder(path);
                    this.fOutputFolderMap.put(path, outputFolder);
                }
                outputFolder.setToken(tokens[i3]);
                outputFolder.addLib(libName);
                ++i3;
            }
        }
    }

    private IPath getPath(Object entry) {
        IPath path = null;
        if (entry instanceof IClasspathEntry) {
            IClasspathEntry cpes = (IClasspathEntry)entry;
            path = cpes.getPath();
        } else if (entry instanceof IPath) {
            path = (IPath)entry;
        }
        if (path.matchingFirstSegments(this.fProject.getFullPath()) > 0) {
            path = path.removeFirstSegments(1);
        }
        if (path != null) {
            return path.addTrailingSeparator();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void validate() {
        String message;
        String message2;
        for (IPath outputPath : this.fOutputFolderMap.keySet()) {
            OutputFolder outputFolder = this.fOutputFolderMap.get(outputPath);
            ArrayList<SourceFolder> sourceFolders = outputFolder.getSourceFolders();
            ArrayList<String> outputFolderLibs = new ArrayList<String>(outputFolder.getLibs());
            if (sourceFolders.size() == 0) {
                IPluginModelBase iPluginModelBase;
                if (!outputFolder.isLibrary()) {
                    for (String libName : outputFolderLibs) {
                        String message3;
                        IResource folderEntry = this.fProject.findMember(outputPath);
                        if (folderEntry == null || !folderEntry.exists() || !(folderEntry instanceof IContainer)) {
                            String message32 = NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)outputPath.toString());
                        } else {
                            message3 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_InvalidOutputFolder, (Object)outputPath.toString());
                        }
                        this.prepareError("output." + libName, outputFolder.getToken(), message3, 8197, this.fOututLibSeverity, "");
                    }
                    continue;
                }
                if (outputFolderLibs.size() != 0 || (iPluginModelBase = PluginRegistry.findModel(this.fProject)) == null) continue;
                IPluginLibrary[] libs = iPluginModelBase.getPluginBase().getLibraries();
                String message22 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingOutputLibForClassFolder, (Object)outputPath.toString());
                if (libs.length > 0) {
                    this.prepareError("output.", null, message22, -1, this.fOututLibSeverity, "");
                    continue;
                }
                this.prepareError(DEF_OUTPUT_ENTRY, outputPath.toString(), message22, 8195, this.fOututLibSeverity, "");
                continue;
            }
            Object var6_11 = null;
            int i = 0;
            while (i < sourceFolders.size()) {
                SourceFolder sourceFolder = sourceFolders.get(i);
                ArrayList<String> srcFolderLibs = sourceFolder.getLibs();
                outputFolderLibs.removeAll(srcFolderLibs);
                switch (srcFolderLibs.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        void var6_12;
                        if (var6_12 == null) {
                            String string = srcFolderLibs.get(0);
                            break;
                        }
                        if (var6_12.equals(srcFolderLibs.get(0))) break;
                    }
                    default: {
                        String erringSrcFolders = this.join(sourceFolders.toArray(new SourceFolder[sourceFolders.size()]));
                        int j = 0;
                        while (j < sourceFolders.size()) {
                            SourceFolder srcFolder = sourceFolders.get(j);
                            int k = 0;
                            while (k < srcFolder.getLibs().size()) {
                                String libName = srcFolder.getLibs().get(k);
                                message2 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DifferentTargetLibrary, (Object)erringSrcFolders);
                                this.prepareError("source." + libName, srcFolder.getToken(), message2, -1, this.fSrcLibSeverity, "");
                                ++k;
                            }
                            ++j;
                        }
                        break block1;
                    }
                }
                ++i;
            }
            i = 0;
            while (i < outputFolderLibs.size()) {
                message = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_ExtraOutputFolder, (Object)outputFolder.getPath().toString(), (Object)("source." + outputFolderLibs.get(i)));
                this.prepareError("output." + outputFolderLibs.get(i), outputFolder.getToken(), message, 8197, this.fOututLibSeverity, "");
                ++i;
            }
            if (outputFolder.getDupeLibName() == null) continue;
            String message4 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DupeOutputFolder, (Object)outputPath.toString(), (Object)("output." + outputFolder.getDupeLibName()));
            this.prepareError("output." + outputFolder.getDupeLibName(), outputFolder.getToken(), message4, -1, this.fOututLibSeverity, "");
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MissingOutputEntry {
            private List<String> fSrcFolders = new ArrayList<String>(1);
            private List<String> fOutputFolders = new ArrayList<String>(1);

            MissingOutputEntry() {
            }

            public String getOutputList() {
                return this.generateList(this.fOutputFolders);
            }

            public String getSourceList() {
                return this.generateList(this.fSrcFolders);
            }

            private String generateList(List<String> strings) {
                StringBuffer buffer = new StringBuffer();
                Iterator<String> iterator = strings.iterator();
                while (iterator.hasNext()) {
                    String next = iterator.next();
                    buffer.append(next);
                    if (!iterator.hasNext()) continue;
                    buffer.append(',');
                    buffer.append(' ');
                }
                return buffer.toString();
            }

            public void addSrcFolder(String sourcePath) {
                if (!this.fSrcFolders.contains(sourcePath)) {
                    this.fSrcFolders.add(sourcePath);
                }
            }

            public void addOutputFolder(String outputPath) {
                if (!this.fOutputFolders.contains(outputPath)) {
                    this.fOutputFolders.add(outputPath);
                }
            }
        }
        HashMap<String, MissingOutputEntry> missingOutputEntryErrors = new HashMap<String, MissingOutputEntry>(4);
        ArrayList<SourceFolder> toValidate = new ArrayList<SourceFolder>();
        for (IPath sourcePath : this.fSourceFolderMap.keySet()) {
            SourceFolder sourceFolder = this.fSourceFolderMap.get(sourcePath);
            OutputFolder outputFolder = sourceFolder.getOutputLocation();
            if (outputFolder == null) {
                IResource folderEntry = this.fProject.findMember(sourcePath);
                message = folderEntry == null || !folderEntry.exists() || !(folderEntry instanceof IContainer) ? NLS.bind((String)PDECoreMessages.BuildErrorReporter_missingFolder, (Object)sourcePath.toString()) : NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_InvalidSourceFolder, (Object)sourcePath.toString());
                ArrayList<String> srcLibs = sourceFolder.getLibs();
                int i = 0;
                while (i < srcLibs.size()) {
                    String libName = srcLibs.get(i);
                    this.prepareError("source." + libName, sourceFolder.getToken(), message, 8197, this.fSrcLibSeverity, "");
                    ++i;
                }
                continue;
            }
            if (outputFolder.getLibs().size() == 0 && sourceFolder.getLibs().size() == 1) {
                String libName = sourceFolder.getLibs().get(0);
                MissingOutputEntry errorEntry = (MissingOutputEntry)missingOutputEntryErrors.get(libName);
                if (errorEntry == null) {
                    errorEntry = new MissingOutputEntry();
                }
                errorEntry.addSrcFolder(sourcePath.toString());
                errorEntry.addOutputFolder(outputFolder.getToken());
                missingOutputEntryErrors.put(libName, errorEntry);
            }
            if (sourceFolder.getDupeLibName() != null) {
                String message5 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_DupeSourceFolder, (Object)sourcePath.toString(), (Object)("source." + sourceFolder.getDupeLibName()));
                this.prepareError("source." + sourceFolder.getDupeLibName(), sourceFolder.getToken(), message5, -1, this.fSrcLibSeverity, "");
            }
            toValidate.add(sourceFolder);
        }
        for (String libName : missingOutputEntryErrors.keySet()) {
            MissingOutputEntry errorEntry = (MissingOutputEntry)missingOutputEntryErrors.get(libName);
            String string = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_MissingOutputEntry, (Object)errorEntry.getSourceList(), (Object)("output." + libName));
            this.prepareError("output." + libName, errorEntry.getOutputList(), string, 8195, this.fMissingOutputLibSeverity, "");
        }
        if (this.fEncodingSeverity == 0 || this.fEncodingSeverity == 1) {
            String lib;
            for (SourceFolder sourceFolder : toValidate) {
                IPath sourcePath = sourceFolder.getPath();
                IProject iProject = this.fProject;
                if (!sourcePath.isEmpty() && !sourcePath.isRoot()) {
                    IFolder iFolder = iProject.getFolder(sourcePath);
                }
                try {
                    void var6_21;
                    ArrayList<String> list = sourceFolder.getLibs();
                    String[] libs = list.toArray(new String[list.size()]);
                    String encoding = this.getExplicitEncoding((IContainer)var6_21);
                    if (encoding != null) {
                        int i = 0;
                        while (i < libs.length) {
                            this.fDefaultLibraryEncodings.put(libs[i], encoding);
                            ++i;
                        }
                    }
                    var6_21.accept((IResourceVisitor)new Visitor(sourceFolder));
                }
                catch (CoreException e) {
                    PDECore.log(e);
                }
            }
            IBuildEntry[] entries = this.fBuild.getBuildEntries();
            int i = 0;
            while (i < entries.length) {
                IBuildEntry iBuildEntry = entries[i];
                String name = iBuildEntry.getName();
                if (name.startsWith("javacDefaultEncoding.")) {
                    lib = name.substring("javacDefaultEncoding.".length());
                    String[] tokens = iBuildEntry.getTokens();
                    if (tokens.length > 0) {
                        if (tokens.length == 1) {
                            String specified = tokens[0];
                            String expected = this.fDefaultLibraryEncodings.remove(lib);
                            if (expected != null) {
                                if (!specified.equals(expected)) {
                                    this.prepareError(name, specified, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_0, (Object[])new String[]{expected, specified, lib}), -1, this.fEncodingSeverity, "");
                                }
                            } else {
                                this.prepareError(name, null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_1, (Object[])new String[]{specified, lib}), 8197, this.fEncodingSeverity, "");
                            }
                        } else {
                            this.fDefaultLibraryEncodings.remove(lib);
                            this.prepareError(name, null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_2, (Object)lib), -1, this.fEncodingSeverity, "");
                        }
                    }
                } else if (name.startsWith("javacCustomEncodings.")) {
                    IContainer bundleRoot = PDEProject.getBundleRoot(this.fProject);
                    String lib2 = name.substring("javacCustomEncodings.".length());
                    String[] tokens = iBuildEntry.getTokens();
                    if (tokens.length > 0) {
                        ArrayList<EncodingEntry> encodings = new ArrayList<EncodingEntry>();
                        int j = 0;
                        while (j < tokens.length) {
                            String special = tokens[j];
                            int index = special.indexOf(91);
                            if (index >= 0 && special.endsWith("]")) {
                                String path = special.substring(0, index);
                                String encoding = special.substring(index + 1, special.length() - 1);
                                IResource member = bundleRoot.findMember(path);
                                if (member == null) {
                                    String message7 = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_3, (Object[])new String[]{encoding, path});
                                    this.prepareError(name, special, message7, 8197, this.fEncodingSeverity, "");
                                } else {
                                    encodings.add(new EncodingEntry(member, encoding));
                                }
                            } else {
                                message2 = PDECoreMessages.SourceEntryErrorReporter_4;
                                this.prepareError(name, special, message2, -1, this.fEncodingSeverity, "");
                            }
                            ++j;
                        }
                        List<EncodingEntry> workspace = this.fCustomEncodings.remove(lib2);
                        if (workspace == null) {
                            this.prepareError(name, null, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_5, (Object)lib2), 8197, this.fEncodingSeverity, "");
                        } else {
                            HashMap<IResource, String> map = new HashMap<IResource, String>();
                            for (EncodingEntry ee : workspace) {
                                map.put(ee.getResource(), ee.getEncoding());
                            }
                            for (EncodingEntry ee : encodings) {
                                String specified = ee.getEncoding();
                                String expected = (String)map.remove(ee.getResource());
                                if (expected == null) {
                                    this.prepareError(name, ee.getValue(), NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_6, (Object[])new String[]{expected, ee.getResource().getProjectRelativePath().toString()}), 8197, this.fEncodingSeverity, "");
                                    continue;
                                }
                                if (specified.equals(expected)) continue;
                                this.prepareError(name, ee.getValue(), NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_7, (Object[])new String[]{expected, ee.getResource().getProjectRelativePath().toString(), specified}), -1, this.fEncodingSeverity, "");
                            }
                            if (!map.isEmpty()) {
                                for (Map.Entry en : map.entrySet()) {
                                    IResource res = (IResource)en.getKey();
                                    String expected = (String)en.getValue();
                                    EncodingEntry missing = new EncodingEntry(res, expected);
                                    String m = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_8, (Object[])new String[]{expected, res.getProjectRelativePath().toString()});
                                    this.prepareError(name, missing.getValue(), m, 8195, this.fEncodingSeverity, "");
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            for (Map.Entry<String, String> entry : this.fDefaultLibraryEncodings.entrySet()) {
                String lib3 = entry.getKey();
                String expected = entry.getValue();
                this.prepareError("javacDefaultEncoding." + lib3, expected, NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_9, (Object[])new String[]{expected, lib3}), 8195, this.fEncodingSeverity, "");
            }
            for (Map.Entry<String, List<EncodingEntry>> entry : this.fCustomEncodings.entrySet()) {
                lib = entry.getKey();
                List<EncodingEntry> encodings = entry.getValue();
                for (EncodingEntry encoding : encodings) {
                    String m = NLS.bind((String)PDECoreMessages.SourceEntryErrorReporter_10, (Object[])new String[]{encoding.getEncoding(), encoding.getResource().getProjectRelativePath().toString()});
                    this.prepareError("javacCustomEncodings." + lib, encoding.getValue(), m, 8195, this.fEncodingSeverity, "");
                }
            }
        }
    }

    private String getExplicitEncoding(IContainer container) throws CoreException {
        IContainer parent;
        String encoding = container.getDefaultCharset(false);
        if (encoding == null && (parent = container.getParent()) != null) {
            switch (parent.getType()) {
                case 2: {
                    return this.getExplicitEncoding(parent);
                }
                case 4: {
                    return this.getExplicitEncoding(parent);
                }
            }
            return null;
        }
        return encoding;
    }

    private String join(ProjectFolder[] folders) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < folders.length) {
            String text = folders[i].getPath().toString().trim();
            if (text.length() > 0) {
                result.append(text);
                result.append(',');
            }
            ++i;
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    public ArrayList<BuildErrorReporter.BuildProblem> getProblemList() {
        return this.fProblemList;
    }

    class EncodingEntry {
        private String fEncoding;
        private IResource fResource;

        EncodingEntry(IResource resource, String encoding) {
            this.fEncoding = encoding;
            this.fResource = resource;
        }

        public String getEncoding() {
            return this.fEncoding;
        }

        public IResource getResource() {
            return this.fResource;
        }

        public String toString() {
            return this.getValue();
        }

        public boolean equals(Object obj) {
            if (obj instanceof EncodingEntry) {
                EncodingEntry other = (EncodingEntry)obj;
                return other.fEncoding.equals(this.fEncoding) && other.fResource.equals((Object)this.fResource);
            }
            return false;
        }

        public int hashCode() {
            return this.fEncoding.hashCode() + this.fResource.hashCode();
        }

        String getValue() {
            StringBuffer buf = new StringBuffer();
            IContainer root = PDEProject.getBundleRoot(this.fResource.getProject());
            buf.append(this.fResource.getFullPath().makeRelativeTo(root.getFullPath()).makeAbsolute());
            buf.append('[');
            buf.append(this.fEncoding);
            buf.append(']');
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class OutputFolder
    extends ProjectFolder {
        private ArrayList<SourceFolder> fSourceFolders;
        private boolean fIsLibrary;

        public OutputFolder(IPath path) {
            super(path);
            this.fSourceFolders = new ArrayList();
            this.fIsLibrary = false;
        }

        public OutputFolder(IPath path, boolean isLibrary) {
            this(path);
            this.fIsLibrary = isLibrary;
        }

        public void addSourceFolder(SourceFolder sourceFolder) {
            if (!this.fSourceFolders.contains(sourceFolder)) {
                this.fSourceFolders.add(sourceFolder);
            }
        }

        public boolean isLibrary() {
            return this.fIsLibrary;
        }

        public ArrayList<SourceFolder> getSourceFolders() {
            return this.fSourceFolders;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ProjectFolder {
        IPath fPath;
        String fToken;
        ArrayList<String> fLibs = new ArrayList(1);
        String dupeLibName = null;

        public ProjectFolder(IPath path) {
            this.fPath = path;
        }

        public IPath getPath() {
            return this.fPath;
        }

        void setToken(String token) {
            this.fToken = token;
        }

        public String getToken() {
            if (this.fToken == null) {
                return this.fPath.toString();
            }
            return this.fToken;
        }

        public void addLib(String libName) {
            if (this.fLibs.contains(libName)) {
                this.dupeLibName = libName;
            } else {
                this.fLibs.add(libName);
            }
        }

        public ArrayList<String> getLibs() {
            return this.fLibs;
        }

        public String getDupeLibName() {
            return this.dupeLibName;
        }
    }

    class SourceFolder
    extends ProjectFolder {
        OutputFolder fOutputFolder;

        public SourceFolder(IPath path, OutputFolder outputFolder) {
            super(path);
            this.fOutputFolder = outputFolder;
        }

        public OutputFolder getOutputLocation() {
            return this.fOutputFolder;
        }
    }

    class Visitor
    implements IResourceVisitor {
        String[] fLibs = null;

        Visitor(SourceFolder folder) {
            ArrayList<String> list = folder.getLibs();
            this.fLibs = list.toArray(new String[list.size()]);
        }

        public boolean visit(IResource resource) throws CoreException {
            String encoding = null;
            switch (resource.getType()) {
                case 2: {
                    encoding = ((IFolder)resource).getDefaultCharset(false);
                    break;
                }
                case 1: {
                    IFile file = (IFile)resource;
                    if (file.getFileExtension() == null || !file.getFileExtension().equals("java")) break;
                    encoding = file.getCharset(false);
                }
            }
            if (encoding != null) {
                EncodingEntry entry = new EncodingEntry(resource, encoding);
                int i = 0;
                while (i < this.fLibs.length) {
                    String lib = this.fLibs[i];
                    List<EncodingEntry> encodings = SourceEntryErrorReporter.this.fCustomEncodings.get(lib);
                    if (encodings == null) {
                        encodings = new ArrayList<EncodingEntry>();
                        SourceEntryErrorReporter.this.fCustomEncodings.put(lib, encodings);
                    }
                    encodings.add(entry);
                    ++i;
                }
            }
            return true;
        }
    }
}

