/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.zip.CRC32;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.internal.compiler.ISourceElementRequestor;
import org.eclipse.wst.jsdt.internal.compiler.SourceElementParser;
import org.eclipse.wst.jsdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.wst.jsdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.BasicSearchEngine;
import org.eclipse.wst.jsdt.internal.core.search.PatternSearchJob;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AddFolderToIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AddJarFileToIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AddLibraryFileToIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AddLibraryFolderToIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexAllProject;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexBinaryFolder;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexingParser;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.indexing.RemoveFolderFromIndex;
import org.eclipse.wst.jsdt.internal.core.search.indexing.RemoveFromIndex;
import org.eclipse.wst.jsdt.internal.core.search.processing.IJob;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class IndexManager
extends JobManager
implements IIndexConstants {
    public SimpleLookupTable indexLocations = new SimpleLookupTable();
    private SimpleLookupTable indexes = new SimpleLookupTable();
    private boolean needToSave = false;
    private static final CRC32 checksumCalculator = new CRC32();
    private IPath javaPluginLocation = null;
    private SimpleLookupTable indexStates = null;
    private File savedIndexNamesFile = new File(this.getSavedIndexesDirectory(), "savedIndexNames.txt");
    public static Integer SAVED_STATE = new Integer(0);
    public static Integer UPDATING_STATE = new Integer(1);
    public static Integer UNKNOWN_STATE = new Integer(2);
    public static Integer REBUILDING_STATE = new Integer(3);
    private static final String INDEX_FILE_SUFFIX = ".index";

    public synchronized void aboutToUpdateIndex(IPath containerPath, Integer newIndexState) {
        Integer currentIndexState;
        IPath indexLocation = this.computeIndexLocation(containerPath);
        Object state = this.getIndexStates().get(indexLocation);
        Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
        if (currentIndexState.equals(REBUILDING_STATE)) {
            return;
        }
        int compare = newIndexState.compareTo(currentIndexState);
        if (compare > 0) {
            this.updateIndexState(indexLocation, newIndexState);
        } else if (compare < 0 && this.indexes.get(indexLocation) == null) {
            this.rebuildIndex(indexLocation, containerPath);
        }
    }

    public void addBinary(IFile resource, IPath containerPath) {
        if (JavaScriptCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
        IPath indexLocation = this.computeIndexLocation(containerPath);
        this.scheduleDocumentIndexing(document, containerPath, indexLocation, participant);
    }

    public void addSource(IFile resource, IPath containerPath, SourceElementParser parser) {
        if (JavaScriptCore.getPlugin() == null) {
            return;
        }
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        SearchDocument document = participant.getDocument(resource.getFullPath().toString());
        document.parser = parser;
        IPath indexLocation = this.computeIndexLocation(containerPath);
        this.scheduleDocumentIndexing(document, containerPath, indexLocation, participant);
    }

    public void cleanUpIndexes() {
        SimpleSet knownPaths = new SimpleSet();
        IJavaScriptSearchScope scope = BasicSearchEngine.createWorkspaceScope();
        PatternSearchJob job = new PatternSearchJob(null, SearchEngine.getDefaultSearchParticipant(), scope, null);
        Index[] selectedIndexes = job.getIndexes(null);
        int i = 0;
        int l = selectedIndexes.length;
        while (i < l) {
            String path = selectedIndexes[i].getIndexFile().getAbsolutePath();
            knownPaths.add(path);
            ++i;
        }
        if (this.indexStates != null) {
            Object[] keys = this.indexStates.keyTable;
            IPath[] locations = new IPath[this.indexStates.elementSize];
            int count = 0;
            int i2 = 0;
            int l2 = keys.length;
            while (i2 < l2) {
                IPath key = (IPath)keys[i2];
                if (key != null && !knownPaths.includes(key.toOSString())) {
                    locations[count++] = key;
                }
                ++i2;
            }
            if (count > 0) {
                this.removeIndexesState(locations);
            }
        }
        this.deleteIndexFiles(knownPaths);
    }

    public IPath computeIndexLocation(IPath containerPath) {
        IPath indexLocation = (IPath)this.indexLocations.get(containerPath);
        if (indexLocation == null) {
            String pathString = containerPath.toOSString();
            checksumCalculator.reset();
            checksumCalculator.update(pathString.getBytes());
            String fileName = String.valueOf(Long.toString(checksumCalculator.getValue())) + INDEX_FILE_SUFFIX;
            if (VERBOSE) {
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> index name for " + pathString + " is " + fileName);
            }
            indexLocation = (IPath)this.getIndexStates().getKey(this.getJavaPluginWorkingLocation().append(fileName));
            this.indexLocations.put(containerPath, indexLocation);
        }
        return indexLocation;
    }

    public void deleteIndexFiles() {
        this.savedIndexNamesFile.delete();
        this.deleteIndexFiles(null);
    }

    private void deleteIndexFiles(SimpleSet pathsToKeep) {
        File[] indexesFiles = this.getSavedIndexesDirectory().listFiles();
        if (indexesFiles == null) {
            return;
        }
        int i = 0;
        int l = indexesFiles.length;
        while (i < l) {
            String fileName = indexesFiles[i].getAbsolutePath();
            if ((pathsToKeep == null || !pathsToKeep.includes(fileName)) && fileName.regionMatches(true, fileName.length() - INDEX_FILE_SUFFIX.length(), INDEX_FILE_SUFFIX, 0, INDEX_FILE_SUFFIX.length())) {
                if (VERBOSE) {
                    org.eclipse.wst.jsdt.internal.core.util.Util.verbose("Deleting index file " + indexesFiles[i]);
                }
                indexesFiles[i].delete();
            }
            ++i;
        }
    }

    public void ensureIndexExists(IPath indexLocation, IPath containerPath) {
        SimpleLookupTable states = this.getIndexStates();
        Object state = states.get(indexLocation);
        if (state == null) {
            this.updateIndexState(indexLocation, REBUILDING_STATE);
            this.getIndex(containerPath, indexLocation, true, true);
        }
    }

    public SourceElementParser getSourceElementParser(IJavaScriptProject project, ISourceElementRequestor requestor) {
        Map options = project.getOptions(true);
        options.put("org.eclipse.wst.jsdt.core.compiler.taskTags", "");
        IndexingParser parser = new IndexingParser(requestor, new DefaultProblemFactory(Locale.getDefault()), new CompilerOptions(options), true, true, false);
        parser.reportOnlyOneSyntaxError = true;
        parser.javadocParser.checkDocComment = true;
        parser.javadocParser.reportProblems = false;
        return parser;
    }

    public synchronized Index getIndex(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        IPath indexLocation = this.computeIndexLocation(containerPath);
        return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
    }

    public synchronized Index getIndex(IPath containerPath, IPath indexLocation, boolean reuseExistingFile, boolean createIfMissing) {
        Index index = this.getIndex(indexLocation);
        if (index == null) {
            Integer currentIndexState;
            Object state = this.getIndexStates().get(indexLocation);
            Integer n = currentIndexState = state == null ? UNKNOWN_STATE : (Integer)state;
            if (currentIndexState == UNKNOWN_STATE) {
                this.rebuildIndex(indexLocation, containerPath);
                return null;
            }
            String containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
            String indexLocationString = indexLocation.toOSString();
            if (reuseExistingFile) {
                block13: {
                    File indexFile = new File(indexLocationString);
                    if (indexFile.exists()) {
                        try {
                            index = new Index(indexLocationString, containerPathString, true);
                            this.indexes.put(indexLocation, index);
                            return index;
                        }
                        catch (IOException iOException) {
                            if (currentIndexState == REBUILDING_STATE) break block13;
                            if (VERBOSE) {
                                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> cannot reuse existing index: " + indexLocationString + " path: " + containerPathString);
                            }
                            this.rebuildIndex(indexLocation, containerPath);
                            return null;
                        }
                    }
                }
                if (currentIndexState == SAVED_STATE) {
                    this.rebuildIndex(indexLocation, containerPath);
                    return null;
                }
            }
            if (createIfMissing) {
                try {
                    if (VERBOSE) {
                        org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> create empty index: " + indexLocationString + " path: " + containerPathString);
                    }
                    index = new Index(indexLocationString, containerPathString, false);
                    this.indexes.put(indexLocation, index);
                    return index;
                }
                catch (IOException iOException) {
                    if (VERBOSE) {
                        org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> unable to create empty index: " + indexLocationString + " path: " + containerPathString);
                    }
                    return null;
                }
            }
        }
        return index;
    }

    public synchronized Index getIndex(IPath indexLocation) {
        return (Index)this.indexes.get(indexLocation);
    }

    public synchronized Index getIndexForUpdate(IPath containerPath, boolean reuseExistingFile, boolean createIfMissing) {
        IPath indexLocation = this.computeIndexLocation(containerPath);
        if (this.getIndexStates().get(indexLocation) == REBUILDING_STATE) {
            return this.getIndex(containerPath, indexLocation, reuseExistingFile, createIfMissing);
        }
        return null;
    }

    private SimpleLookupTable getIndexStates() {
        if (this.indexStates != null) {
            return this.indexStates;
        }
        this.indexStates = new SimpleLookupTable();
        IPath indexesDirectoryPath = this.getJavaPluginWorkingLocation();
        char[][] savedNames = this.readIndexState(indexesDirectoryPath.toOSString());
        if (savedNames != null) {
            int i = 1;
            int l = savedNames.length;
            while (i < l) {
                char[] savedName = savedNames[i];
                if (savedName.length > 0) {
                    IPath indexLocation = indexesDirectoryPath.append(new String(savedName));
                    if (VERBOSE) {
                        org.eclipse.wst.jsdt.internal.core.util.Util.verbose("Reading saved index file " + indexLocation);
                    }
                    this.indexStates.put(indexLocation, SAVED_STATE);
                }
                ++i;
            }
        } else {
            this.deleteIndexFiles();
        }
        return this.indexStates;
    }

    private IPath getJavaPluginWorkingLocation() {
        if (this.javaPluginLocation != null) {
            return this.javaPluginLocation;
        }
        IPath stateLocation = JavaScriptCore.getPlugin().getStateLocation().addTrailingSeparator().append("indexes");
        try {
            IFileStore store = EFS.getLocalFileSystem().getStore(stateLocation);
            if (!store.fetchInfo().exists()) {
                store.mkdir(4, null);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.javaPluginLocation = stateLocation;
        return this.javaPluginLocation;
    }

    private File getSavedIndexesDirectory() {
        return new File(this.getJavaPluginWorkingLocation().toOSString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void indexDocument(SearchDocument searchDocument, SearchParticipant searchParticipant, Index index, IPath indexLocation) {
        try {
            searchDocument.index = index;
            searchParticipant.indexDocument(searchDocument, indexLocation);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            searchDocument.index = null;
            throw throwable;
        }
        {
            Object var5_7 = null;
            searchDocument.index = null;
            return;
        }
    }

    public void indexAll(IProject project) {
        if (JavaScriptCore.getPlugin() == null) {
            return;
        }
        try {
            JavaModel model = JavaModelManager.getJavaModelManager().getJavaModel();
            JavaProject javaProject = (JavaProject)model.getJavaProject((IResource)project);
            IIncludePathEntry[] entries = javaProject.getResolvedClasspath();
            int i = 0;
            while (i < entries.length) {
                IIncludePathEntry entry = entries[i];
                if (entry.getEntryKind() == 1) {
                    this.indexLibrary(entry, project);
                }
                ++i;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        IndexAllProject request = new IndexAllProject(project, this);
        if (!this.isJobWaiting(request)) {
            this.request(request);
        }
    }

    public void indexLibrary(IIncludePathEntry entry, IProject requestingProject) {
        if (JavaScriptCore.getPlugin() == null) {
            return;
        }
        IndexRequest request = null;
        Object target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), entry.getPath(), true);
        char[][] inclusionPatterns = ((ClasspathEntry)entry).fullInclusionPatternChars();
        char[][] exclusionPatterns = ((ClasspathEntry)entry).fullExclusionPatternChars();
        request = target instanceof IFolder || target instanceof IProject ? new AddLibraryFolderToIndex(entry.getPath(), requestingProject, inclusionPatterns, exclusionPatterns, this) : (target instanceof IFile ? new AddLibraryFileToIndex((IFile)target, this) : new AddLibraryFileToIndex(entry.getPath(), inclusionPatterns, exclusionPatterns, this));
        if (!this.isJobWaiting(request)) {
            this.request(request);
        }
    }

    public void indexLibrary(LibraryFragmentRoot entry, IProject requestingProject) {
        try {
            this.indexLibrary(entry.getRawIncludepathEntry(), requestingProject);
        }
        catch (JavaScriptModelException ex) {
            ex.printStackTrace();
        }
    }

    public void indexSourceFolder(JavaProject javaProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IndexAllProject request;
        IProject project = javaProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(request = new IndexAllProject(project, this))) {
            return;
        }
        this.request(new AddFolderToIndex(sourceFolder, project, inclusionPatterns, exclusionPatterns, this));
    }

    public synchronized void jobWasCancelled(IPath containerPath) {
        IPath indexLocation = this.computeIndexLocation(containerPath);
        Index index = this.getIndex(indexLocation);
        if (index != null) {
            index.monitor = null;
            this.indexes.removeKey(indexLocation);
        }
        this.updateIndexState(indexLocation, UNKNOWN_STATE);
    }

    protected synchronized void moveToNextJob() {
        this.needToSave = true;
        super.moveToNextJob();
    }

    protected void notifyIdle(long idlingTime) {
        if (idlingTime > 1000L && this.needToSave) {
            this.saveIndexes();
        }
    }

    public String processName() {
        return Messages.process_name;
    }

    private void rebuildIndex(IPath indexLocation, IPath containerPath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return;
        }
        Object target = JavaModel.getTarget((IContainer)workspace.getRoot(), containerPath, true);
        if (target == null) {
            return;
        }
        if (VERBOSE) {
            org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> request to rebuild index: " + indexLocation + " path: " + containerPath);
        }
        this.updateIndexState(indexLocation, REBUILDING_STATE);
        IndexRequest request = null;
        if (target instanceof IProject) {
            IProject p = (IProject)target;
            if (JavaProject.hasJavaNature(p)) {
                request = new IndexAllProject(p, this);
            }
        } else if (target instanceof IFolder) {
            request = new IndexBinaryFolder((IContainer)((IFolder)target), this);
        } else if (target instanceof IFile && Util.isArchiveFileName(((IFile)target).getName())) {
            request = new AddJarFileToIndex((IFile)target, this);
        } else if (target instanceof File) {
            request = Util.isArchiveFileName(((File)target).getName()) ? new AddJarFileToIndex(containerPath, this) : new AddLibraryFileToIndex(containerPath, this);
        }
        if (request != null) {
            this.request(request);
        }
    }

    public synchronized Index recreateIndex(IPath containerPath) {
        String containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
        try {
            ReadWriteMonitor monitor;
            IPath indexLocation = this.computeIndexLocation(containerPath);
            Index index = this.getIndex(indexLocation);
            ReadWriteMonitor readWriteMonitor = monitor = index == null ? null : index.monitor;
            if (VERBOSE) {
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> recreating index: " + indexLocation + " for path: " + containerPathString);
            }
            index = new Index(indexLocation.toOSString(), containerPathString, false);
            this.indexes.put(indexLocation, index);
            index.monitor = monitor;
            return index;
        }
        catch (IOException e) {
            if (VERBOSE) {
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> failed to recreate index for path: " + containerPathString);
                e.printStackTrace();
            }
            return null;
        }
    }

    public void remove(String containerRelativePath, IPath indexedContainer) {
        this.request(new RemoveFromIndex(containerRelativePath, indexedContainer, this));
    }

    public synchronized void removeIndex(IPath containerPath) {
        if (VERBOSE) {
            org.eclipse.wst.jsdt.internal.core.util.Util.verbose("removing index " + containerPath);
        }
        IPath indexLocation = this.computeIndexLocation(containerPath);
        Index index = this.getIndex(indexLocation);
        File indexFile = null;
        if (index != null) {
            index.monitor = null;
            indexFile = index.getIndexFile();
        }
        if (indexFile == null) {
            indexFile = new File(indexLocation.toOSString());
        }
        if (indexFile.exists()) {
            indexFile.delete();
        }
        this.indexes.removeKey(indexLocation);
        this.updateIndexState(indexLocation, null);
    }

    public synchronized void removeIndexPath(IPath path) {
        Object[] keyTable = this.indexes.keyTable;
        Object[] valueTable = this.indexes.valueTable;
        IPath[] locations = null;
        int max = this.indexes.elementSize;
        int count = 0;
        int i = 0;
        int l = keyTable.length;
        while (i < l) {
            IPath indexLocation = (IPath)keyTable[i];
            if (indexLocation != null) {
                if (path.isPrefixOf(indexLocation)) {
                    Index index = (Index)valueTable[i];
                    index.monitor = null;
                    if (locations == null) {
                        locations = new IPath[max];
                    }
                    locations[count++] = indexLocation;
                    File indexFile = index.getIndexFile();
                    if (indexFile.exists()) {
                        indexFile.delete();
                    }
                } else {
                    --max;
                }
            }
            ++i;
        }
        if (locations != null) {
            i = 0;
            while (i < count) {
                this.indexes.removeKey(locations[i]);
                ++i;
            }
            this.removeIndexesState(locations);
        }
    }

    public synchronized void removeIndexFamily(IPath path) {
        ArrayList<IPath> toRemove = null;
        Object[] containerPaths = this.indexLocations.keyTable;
        int i = 0;
        int length = containerPaths.length;
        while (i < length) {
            IPath containerPath = (IPath)containerPaths[i];
            if (containerPath != null && path.isPrefixOf(containerPath)) {
                if (toRemove == null) {
                    toRemove = new ArrayList<IPath>();
                }
                toRemove.add(containerPath);
            }
            ++i;
        }
        if (toRemove != null) {
            i = 0;
            length = toRemove.size();
            while (i < length) {
                this.removeIndex((IPath)toRemove.get(i));
                ++i;
            }
        }
    }

    public void removeSourceFolderFromIndex(JavaProject javaProject, IPath sourceFolder, char[][] inclusionPatterns, char[][] exclusionPatterns) {
        IndexAllProject request;
        IProject project = javaProject.getProject();
        if (this.jobEnd > this.jobStart && this.isJobWaiting(request = new IndexAllProject(project, this))) {
            return;
        }
        this.request(new RemoveFolderFromIndex(sourceFolder, inclusionPatterns, exclusionPatterns, project, this));
    }

    public synchronized void reset() {
        super.reset();
        if (this.indexes != null) {
            this.indexes = new SimpleLookupTable();
            this.indexStates = null;
        }
        this.indexLocations = new SimpleLookupTable();
        this.javaPluginLocation = null;
    }

    public synchronized boolean resetIndex(IPath containerPath) {
        String containerPathString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
        try {
            IPath indexLocation = this.computeIndexLocation(containerPath);
            Index index = this.getIndex(indexLocation);
            if (VERBOSE) {
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> reseting index: " + indexLocation + " for path: " + containerPathString);
            }
            if (index == null) {
                return this.recreateIndex(containerPath) != null;
            }
            index.reset();
            return true;
        }
        catch (IOException e) {
            if (VERBOSE) {
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> failed to reset index for path: " + containerPathString);
                e.printStackTrace();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIndex(Index index) throws IOException {
        if (index.hasChanged()) {
            if (VERBOSE) {
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> saving index " + index.getIndexFile());
            }
            index.save();
        }
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Path containerPath = new Path(index.containerPath);
            if (this.jobEnd > this.jobStart) {
                int i = this.jobEnd;
                while (i > this.jobStart) {
                    IJob job = this.awaitingJobs[i];
                    if (job instanceof IndexRequest && ((IndexRequest)job).containerPath.equals((Object)containerPath)) {
                        return;
                    }
                    --i;
                }
            }
            IPath indexLocation = this.computeIndexLocation((IPath)containerPath);
            this.updateIndexState(indexLocation, SAVED_STATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveIndexes() {
        ArrayList<Index> toSave = new ArrayList<Index>();
        IndexManager indexManager = this;
        synchronized (indexManager) {
            Object[] valueTable = this.indexes.valueTable;
            int i = 0;
            int l = valueTable.length;
            while (i < l) {
                Index index = (Index)valueTable[i];
                if (index != null) {
                    toSave.add(index);
                }
                ++i;
            }
        }
        boolean allSaved = true;
        int i = 0;
        int length = toSave.size();
        while (i < length) {
            Index index = (Index)toSave.get(i);
            ReadWriteMonitor monitor = index.monitor;
            if (monitor != null) {
                Object var10_12;
                try {
                    monitor.enterRead();
                    if (index.hasChanged()) {
                        if (monitor.exitReadEnterWrite()) {
                            Object var8_11;
                            try {
                                try {
                                    this.saveIndex(index);
                                }
                                catch (IOException e) {
                                    if (VERBOSE) {
                                        org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> got the following exception while saving:", System.err);
                                        e.printStackTrace();
                                    }
                                    allSaved = false;
                                }
                                var8_11 = null;
                                monitor.exitWriteEnterRead();
                            }
                            catch (Throwable throwable) {
                                var8_11 = null;
                                monitor.exitWriteEnterRead();
                                throw throwable;
                            }
                        } else {
                            allSaved = false;
                        }
                    }
                    var10_12 = null;
                    monitor.exitRead();
                }
                catch (Throwable throwable) {
                    var10_12 = null;
                    monitor.exitRead();
                    throw throwable;
                }
            }
            ++i;
        }
        this.needToSave = !allSaved;
    }

    public void scheduleDocumentIndexing(final SearchDocument searchDocument, IPath container, final IPath indexLocation, final SearchParticipant searchParticipant) {
        this.request(new IndexRequest(container, this){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean execute(IProgressMonitor progressMonitor) {
                if (this.isCancelled) return true;
                if (progressMonitor != null && progressMonitor.isCanceled()) {
                    return true;
                }
                Index index = IndexManager.this.getIndex(this.containerPath, indexLocation, true, true);
                if (index == null) {
                    return true;
                }
                ReadWriteMonitor monitor = index.monitor;
                if (monitor == null) {
                    return true;
                }
                try {
                    monitor.enterWrite();
                    IndexManager.this.indexDocument(searchDocument, searchParticipant, index, indexLocation);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    monitor.exitWrite();
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    monitor.exitWrite();
                    return true;
                }
            }

            public String toString() {
                return "indexing " + searchDocument.getPath();
            }
        });
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(10);
        buffer.append(super.toString());
        buffer.append("In-memory indexes:\n");
        int count = 0;
        Object[] valueTable = this.indexes.valueTable;
        int i = 0;
        int l = valueTable.length;
        while (i < l) {
            Index index = (Index)valueTable[i];
            if (index != null) {
                buffer.append(++count).append(" - ").append(index.toString()).append('\n');
            }
            ++i;
        }
        return buffer.toString();
    }

    private char[][] readIndexState(String dirOSString) {
        block3: {
            try {
                String savedSignature;
                char[][] names;
                char[] savedIndexNames = Util.getFileCharContent(this.savedIndexNamesFile, null);
                if (savedIndexNames.length > 0 && (names = CharOperation.splitOn('\n', savedIndexNames)).length > 1 && (savedSignature = "INDEX VERSION 1.3+" + dirOSString).equals(new String(names[0]))) {
                    return names;
                }
            }
            catch (IOException iOException) {
                if (!VERBOSE) break block3;
                org.eclipse.wst.jsdt.internal.core.util.Util.verbose("Failed to read saved index file names");
            }
        }
        return null;
    }

    private synchronized void removeIndexesState(IPath[] locations) {
        this.getIndexStates();
        int length = locations.length;
        boolean changed = false;
        int i = 0;
        while (i < length) {
            if (locations[i] != null && this.indexStates.removeKey(locations[i]) != null) {
                changed = true;
                if (VERBOSE) {
                    org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> index state updated to: ? for: " + locations[i]);
                }
            }
            ++i;
        }
        if (!changed) {
            return;
        }
        this.writeSavedIndexNamesFile();
    }

    private synchronized void updateIndexState(IPath indexLocation, Integer indexState) {
        if (indexLocation.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.getIndexStates();
        if (indexState != null) {
            if (indexState.equals(this.indexStates.get(indexLocation))) {
                return;
            }
            this.indexStates.put(indexLocation, indexState);
        } else {
            if (!this.indexStates.containsKey(indexLocation)) {
                return;
            }
            this.indexStates.removeKey(indexLocation);
        }
        this.writeSavedIndexNamesFile();
        if (VERBOSE) {
            String state = "?";
            if (indexState == SAVED_STATE) {
                state = "SAVED";
            } else if (indexState == UPDATING_STATE) {
                state = "UPDATING";
            } else if (indexState == UNKNOWN_STATE) {
                state = "UNKNOWN";
            } else if (indexState == REBUILDING_STATE) {
                state = "REBUILDING";
            }
            org.eclipse.wst.jsdt.internal.core.util.Util.verbose("-> index state updated to: " + state + " for: " + indexLocation);
        }
    }

    /*
     * Exception decompiling
     */
    private void writeSavedIndexNamesFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 186->190)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

