/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.prefs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.ui.JptJpaUiMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class JpaEntityGenPreferencePage
extends PropertyPage {
    private EntityGenComposite entityGenComposite;

    public JpaEntityGenPreferencePage() {
        this.setDescription(JptJpaUiMessages.JpaEntityGenPreferencePage_Description);
    }

    public boolean performOk() {
        super.performOk();
        this.updateProjectEntityGenPreferences();
        return true;
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.entityGenComposite = new EntityGenComposite(composite);
        return composite;
    }

    private void updateProjectEntityGenPreferences() {
        String pkgName = this.getDefaultPackage();
        JpaPreferences.setEntityGenDefaultPackageName((IProject)this.getProject(), (String)(StringTools.isNotBlank((String)pkgName) ? pkgName : null));
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        return adaptable == null ? null : (IProject)adaptable.getAdapter(IProject.class);
    }

    private String getDefaultPackage() {
        return this.entityGenComposite.getDefaultPackage();
    }

    private String getDefaultPackagePreference() {
        return JpaPreferences.getEntityGenDefaultPackageName((IProject)this.getProject());
    }

    class EntityGenComposite {
        private final Text defaultPackageText;

        private EntityGenComposite(Composite parent) {
            Group group = new Group(parent, 0);
            group.setText(JptJpaUiMessages.JpaEntityGenPreferencePage_generalGroup_title);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(768));
            this.buildLabel((Composite)group, 1, JptJpaUiMessages.JpaEntityGenPreferencePage_defaultPackageLabel);
            this.defaultPackageText = this.buildText((Composite)group, 1);
            this.initializeFromPreferences();
        }

        private void initializeFromPreferences() {
            this.defaultPackageText.setText(JpaEntityGenPreferencePage.this.getDefaultPackagePreference());
        }

        private Text buildText(Composite parent, int horizontalSpan) {
            Text text = new Text(parent, 2052);
            GridData gridData = new GridData(4, 0x1000000, true, false);
            gridData.horizontalSpan = horizontalSpan;
            text.setLayoutData((Object)gridData);
            return text;
        }

        private Label buildLabel(Composite parent, int span, String text) {
            Label label = new Label(parent, 0);
            label.setText(text);
            GridData gridData = new GridData();
            gridData.horizontalSpan = span;
            label.setLayoutData((Object)gridData);
            return label;
        }

        private String getDefaultPackage() {
            return this.defaultPackageText.getText();
        }
    }
}

