/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui.text2;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.TextSearchQueryProvider;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.text2.FindInRecentScopeActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class FindInFileActionDelegate
extends FindInRecentScopeActionDelegate {
    private IEditorPart fEditor = null;

    public FindInFileActionDelegate() {
        super(SearchMessages.FindInFileActionDelegate_text);
        this.setActionDefinitionId("org.eclipse.search.ui.performTextSearchFile");
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IEditorPart editor;
        IWorkbenchPart part;
        this.fEditor = null;
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page != null && (part = page.getActivePart()) instanceof IEditorPart && (editor = (IEditorPart)part).getEditorInput() instanceof IFileEditorInput) {
            this.fEditor = editor;
        }
        action.setEnabled(this.fEditor != null);
    }

    public void setActiveEditor(IAction action, IEditorPart editor) {
        this.fEditor = editor != null && editor.getEditorInput() instanceof IFileEditorInput ? editor : null;
        super.setActiveEditor(action, editor);
    }

    private IFile getFile() {
        IEditorInput ei;
        if (this.fEditor != null && (ei = this.fEditor.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)ei).getFile();
        }
        return null;
    }

    protected ISearchQuery createQuery(TextSearchQueryProvider provider, String searchForString) throws CoreException {
        return provider.createQuery(searchForString, new IResource[]{this.getFile()});
    }
}

